/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a:\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019\u001a&\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000b2\u0006\u0010%\u001a\u00020\u0013H\u0002\u001a\u000e\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013\u001a\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010)\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0013\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0013\u001a\u0016\u0010+\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010,\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00100\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00101\u001a\u00020\u00012\u0006\u0010 \u001a\u000202\u001a\u000e\u00103\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00104\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013\u001a\u0016\u00105\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013\u001a\u001e\u00107\u001a\u0002082\u0006\u0010%\u001a\u00020\u00132\f\u00109\u001a\b\u0012\u0004\u0012\u00020$0\u000bH\u0002\u001a\u0012\u0010:\u001a\u00020\u0001*\u00020!2\u0006\u0010;\u001a\u00020<\u001a\u0014\u0010=\u001a\u00020\u0001*\u00020!2\u0006\u0010;\u001a\u00020<H\u0002\u00a8\u0006>"}, d2={"arrayAssignmentToVarargInNamedFormInAnnotation", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createResolutionCandidatesForConstructors", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "typeWithConstructors", "Lorg/jetbrains/kotlin/types/KotlinType;", "useKnownTypeSubstitutor", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "getEffectiveExpectedType", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getEffectiveExpectedTypeForSingleArgument", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getExpectedType", "getParameterArgumentsOfCallableType", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "getReturnTypeForCallable", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "hasUnknownFunctionParameter", "hasUnknownReturnType", "isArrayOrArrayLiteral", "isBinaryRemOperator", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSuperOrDelegatingConstructorCall", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "frontend"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block4: {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean bl3 = bl2 = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
            if (_Assertions.ENABLED && !bl2) {
                String string = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeProjection it = (TypeProjection)element$iv;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                    if (!(TypeUtilsKt.contains(kotlinType, hasUnknownFunctionParameter.2.1.INSTANCE) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(given, "given");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<TypeProjectionImpl> newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        ArrayList<TypeProjectionImpl> arrayList = newArguments;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, (List<? extends TypeProjection>)arrayList);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, simpleType2);
    }

    private static final SimpleType replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments) {
        return KotlinTypeFactory.simpleType(type2.getAnnotations(), type2.getConstructor(), newArguments, type2.isMarkedNullable());
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return CollectionsKt.last(type2.getArguments()).getType();
    }

    private static final boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor $receiver, ConstraintSystem constraintSystem) {
        boolean bl;
        block4: {
            KotlinType returnType;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType kotlinType2 = returnType = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "returnType");
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, kotlinType2);
            Iterable $receiver$iv = nestedTypeVariables;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        TypeConstructor typeConstructor2;
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        KotlinType receiverType = receiverParameterDescriptor.getType();
        Iterator<TypeParameterDescriptor> iterator2 = descriptor2.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            if (!Intrinsics.areEqual(typeParameterDescriptor.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = TypeIntersector.getUpperBoundsAsType(typeParameter);
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        if (receiverType.getConstructor() instanceof IntersectionTypeConstructor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Collection<KotlinType> collection = receiverType.getConstructor().getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "receiverType.constructor.supertypes");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void supertype;
                Iterable $receiver$iv2;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Iterable iterable2 = $receiver$iv2 = (Iterable)supertype.getArguments();
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void it;
                    TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it.getProjectionKind(), TypeUtils.DONT_CARE);
                    collection3.add(typeProjectionImpl);
                }
                List fakeArguments = (List)destination$iv$iv2;
                void v2 = supertype;
                Intrinsics.checkExpressionValueIsNotNull(v2, "supertype");
                KotlinType kotlinType2 = TypeSubstitutionKt.replace$default((KotlinType)v2, fakeArguments, null, 2, null);
                collection2.add(kotlinType2);
            }
            List superTypesWithFakeArguments = (List)destination$iv$iv;
            typeConstructor2 = new IntersectionTypeConstructor(superTypesWithFakeArguments);
        } else {
            typeConstructor2 = receiverType.getConstructor();
        }
        TypeConstructor receiverTypeConstructor = typeConstructor2;
        Annotations annotations2 = receiverType.getAnnotations();
        List list2 = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "fakeTypeArguments");
        boolean bl = receiverType.isMarkedNullable();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, receiverTypeConstructor, list2, bl, memberScope2);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            boolean bl;
            block5: {
                Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.overriddenDescriptors");
                Iterable $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        CallableMemberDescriptor p1 = (CallableMemberDescriptor)element$iv;
                        if (CallResolverUtilKt.isOrOverridesSynthesized(p1)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    public static final boolean isBinaryRemOperator(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression callElement = ktBinaryExpression;
        IElementType operator = callElement.getOperationToken();
        if (!(operator instanceof KtToken)) {
            return false;
        }
        Name name = OperatorConventions.getNameForOperationSymbol((KtToken)operator, true, true);
        return ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains(name);
    }

    public static final boolean isConventionCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2 instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement callElement = call2.getCallElement();
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return calleeExpression.isConventionOperator();
    }

    public static final boolean isInfixCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        return binaryExpression.getOperationReference() == operationRefExpression && operationRefExpression.getOperationSignTokenType() == null;
    }

    public static final boolean isSuperOrDelegatingConstructorCall(@NotNull Call call2) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtExpression it = ktExpression = call2.getCalleeExpression();
        return it instanceof KtConstructorCalleeExpression || it instanceof KtConstructorDelegationReferenceExpression;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call2) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call2.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression2 = ((ExpressionReceiver)receiverValue).getExpression();
        return expression2 instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return false;
        }
        return call2.getExplicitReceiver() != null && call2.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Receiver receiver = call2.getExplicitReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            receiver = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiver;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(resolvedArgument, "resolvedArgument");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "resolvedArgument.arguments");
        ValueArgument argument = CollectionsKt.singleOrNull(list2);
        return argument != null ? CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, trace) : CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(context, "context");
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "context.languageVersionSettings");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, bindingTrace);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedTypeForSingleArgument(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (argument.getSpreadElement() != null) {
            KotlinType kotlinType;
            if (parameterDescriptor.getVarargElementType() == null) {
                SimpleType simpleType2 = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
                kotlinType = simpleType2;
            } else {
                KotlinType kotlinType2 = parameterDescriptor.getType();
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
            }
            return kotlinType;
        }
        if (CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInAnnotation(parameterDescriptor, argument, languageVersionSettings, trace)) {
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
            return kotlinType;
        }
        return CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    private static final KotlinType getExpectedType(ValueParameterDescriptor parameterDescriptor) {
        KotlinType kotlinType = parameterDescriptor.getVarargElementType();
        if (kotlinType == null) {
            KotlinType kotlinType2 = parameterDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
        }
        return kotlinType;
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInAnnotation(ValueParameterDescriptor parameterDescriptor, ValueArgument argument, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        if (!DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor)) {
            return false;
        }
        return argument.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor) && CallResolverUtilKt.isArrayOrArrayLiteral(argument, trace);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull ValueArgument argument, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression argumentExpression = ktExpression;
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            return true;
        }
        KotlinType kotlinType = trace.getType(argumentExpression);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call2, @NotNull KotlinType typeWithConstructors, boolean useKnownTypeSubstitutor, @NotNull SyntheticScopes syntheticScopes) {
        Iterable $receiver$iv$iv;
        ReceiverValue dispatchReceiver;
        ExplicitReceiverKind receiverKind;
        Object receiver;
        CallableDescriptor it;
        Collection collection;
        TypeAliasDescriptor typeAliasDescriptor;
        Object object;
        TypeAliasDescriptor typeAliasDescriptor2;
        TypeSubstitutor knownSubstitutor;
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Intrinsics.checkParameterIsNotNull(typeWithConstructors, "typeWithConstructors");
        Intrinsics.checkParameterIsNotNull(syntheticScopes, "syntheticScopes");
        ClassifierDescriptor classifierDescriptor = typeWithConstructors.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor classWithConstructors = (ClassDescriptor)classifierDescriptor;
        UnwrappedType unwrappedType = typeWithConstructors.unwrap();
        if (useKnownTypeSubstitutor) {
            SimpleType simpleType2;
            UnwrappedType unwrappedType2 = unwrappedType;
            if (!(unwrappedType2 instanceof AbbreviatedType)) {
                unwrappedType2 = null;
            }
            typeSubstitutor2 = TypeSubstitutor.create((simpleType2 = (AbbreviatedType)unwrappedType2) != null && (simpleType2 = simpleType2.getAbbreviation()) != null ? (KotlinType)simpleType2 : (KotlinType)unwrappedType);
        } else {
            typeSubstitutor2 = knownSubstitutor = null;
        }
        if (unwrappedType instanceof AbbreviatedType) {
            ClassifierDescriptor classifierDescriptor2 = ((AbbreviatedType)unwrappedType).getAbbreviation().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) {
                classifierDescriptor2 = null;
            }
            typeAliasDescriptor2 = (TypeAliasDescriptor)classifierDescriptor2;
        } else {
            typeAliasDescriptor2 = null;
        }
        if ((object = (typeAliasDescriptor = typeAliasDescriptor2)) != null && (object = object.getConstructors()) != null) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                TypeAliasConstructorDescriptor typeAliasConstructorDescriptor;
                Object element$iv$iv = element$iv$iv$iv;
                Object receiver2 = element$iv$iv;
                if (((TypeAliasConstructorDescriptor)receiver2).getWithDispatchReceiver() == null) continue;
                TypeAliasConstructorDescriptor it$iv$iv = typeAliasConstructorDescriptor;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            Collection collection2 = classWithConstructors.getConstructors();
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "classWithConstructors.constructors");
        }
        Collection constructors2 = collection;
        if (constructors2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (classWithConstructors.isInner()) {
            Object v13;
            block20: {
                Annotated annotated;
                DeclarationDescriptor declarationDescriptor = classWithConstructors.getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((annotated = (ClassDescriptor)declarationDescriptor) == null || (annotated = annotated.getDefaultType()) == null) {
                    return CollectionsKt.emptyList();
                }
                Annotated outerClassType = annotated;
                Object object2 = knownSubstitutor;
                if (object2 == null || (object2 = ((TypeSubstitutor)object2).substitute((KotlinType)outerClassType, Variance.INVARIANT)) == null) {
                    Annotated annotated2 = outerClassType;
                    Intrinsics.checkExpressionValueIsNotNull(annotated2, "outerClassType");
                    object2 = (KotlinType)annotated2;
                }
                Object substitutedOuterClassType = object2;
                Iterable $receiver$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                for (Object element$iv : $receiver$iv) {
                    it = (ReceiverParameterDescriptor)element$iv;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it.getType(), (KotlinType)substitutedOuterClassType)) continue;
                    v13 = element$iv;
                    break block20;
                }
                v13 = null;
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = v13;
            if (receiverParameterDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            receiver = receiverParameterDescriptor;
            receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
            dispatchReceiver = receiver.getValue();
        } else {
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        Iterable $receiver$iv = constructors2;
        receiver = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ConstructorDescriptor)element$iv$iv;
            ConstructorDescriptor constructorDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor, "it");
            Iterable list$iv$iv = SyntheticScopesKt.collectSyntheticConstructors(syntheticScopes, constructorDescriptor);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List syntheticConstructors = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)CollectionsKt.plus(constructors2, (Iterable)syntheticConstructors);
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ConstructorDescriptor)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, it, dispatchReceiver, receiverKind, knownSubstitutor);
            collection3.add(resolutionCandidate);
        }
        return (List)destination$iv$iv;
    }
}

