/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Properties;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;
import org.protege.editor.owl.model.user.UserNameProvider;

public class DefaultUserNameProvider
implements UserNameProvider {
    public static final String SYSTEM_USER_NAME_PROPERTY = "user.name";
    private final UserNamePreferencesManager preferencesManager;
    private final Properties properties;

    public DefaultUserNameProvider(UserNamePreferencesManager preferencesManager, Properties properties) {
        this.preferencesManager = (UserNamePreferencesManager)Preconditions.checkNotNull((Object)preferencesManager);
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
    }

    @Override
    public Optional<String> getUserName() {
        Optional<String> userName = this.preferencesManager.getUserName();
        if (userName.isPresent()) {
            return userName;
        }
        return Optional.ofNullable(this.properties.getProperty(SYSTEM_USER_NAME_PROPERTY));
    }
}

