/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    public static RubyArray convertToRubyArray(Ruby runtime, IRubyObject value2, boolean coerce2) {
        if (value2 == null) {
            return RubyArray.newEmptyArray(runtime);
        }
        if (coerce2) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime, value2);
        }
        return RubyArray.newArrayLight(runtime, value2);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        IRubyObject newValue = TypeConverter.convertToType(value2, runtime.getArray(), "to_ary", false);
        if (newValue.isNil()) {
            return RubyArray.newArrayLight(runtime, value2);
        }
        if (!(newValue instanceof RubyArray)) {
            throw runtime.newTypeError(newValue.getMetaClass() + "#to_ary should return Array");
        }
        return (RubyArray)newValue;
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public static IRubyObject getOptionsArg(Ruby runtime, IRubyObject ... args2) {
        if (args2.length >= 1) {
            return TypeConverter.checkHashType(runtime, args2[args2.length - 1]);
        }
        return runtime.getNil();
    }

    public static IRubyObject getOptionsArg(Ruby runtime, IRubyObject arg2) {
        if (arg2 == null) {
            return runtime.getNil();
        }
        return TypeConverter.checkHashType(runtime, arg2);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, RubyHash options2, String[] validKeys) {
        IRubyObject[] ret = new IRubyObject[validKeys.length];
        int index2 = 0;
        HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>();
        for (String key2 : validKeys) {
            RubySymbol keySym = context.runtime.newSymbol(key2);
            ret[index2] = options2.containsKey(keySym) ? options2.fastARef(keySym) : RubyBasicObject.UNDEF;
            ++index2;
            validKeySet.add(keySym);
        }
        for (Object obj : options2.keySet()) {
            if (validKeySet.contains(obj)) continue;
            throw context.runtime.newArgumentError("unknown keyword: " + obj);
        }
        return ret;
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject[] args2, String[] validKeys) {
        IRubyObject options2 = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (options2 instanceof RubyHash) {
            return ArgsUtil.extractKeywordArgs(context, (RubyHash)options2, validKeys);
        }
        return null;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject arg2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg2);
        if (!opts.isNil()) {
            return ((RubyHash)opts).op_aref(context, context.runtime.newSymbol(keyword));
        }
        return context.nil;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject ... args2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (!opts.isNil()) {
            return ((RubyHash)opts).op_aref(context, context.runtime.newSymbol(keyword));
        }
        return context.nil;
    }

    public static IRubyObject extractArg(int index2, IRubyObject _default, IRubyObject ... args2) {
        if (index2 < args2.length) {
            return args2[index2];
        }
        return _default;
    }
}

