/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class MathDetailsProvider
extends DetailsProvider.Basic {
    private static final String BIG_INTEGRER_MASK = "java.math.BigInteger";
    private static final String BIG_DECIMAL_MASK = "java.math.BigDecimal";

    public MathDetailsProvider() {
        super(BIG_INTEGRER_MASK, BIG_DECIMAL_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        String string2;
        if (BIG_INTEGRER_MASK.equals(string)) {
            BigInteger bigInteger = this.getBigInteger(instance);
            if (bigInteger != null) {
                return bigInteger.toString();
            }
        } else if (BIG_DECIMAL_MASK.equals(string) && (string2 = DetailsUtils.getInstanceFieldString(instance, "stringCache", heap)) == null) {
            BigInteger bigInteger;
            int n = DetailsUtils.getIntFieldValue(instance, "scale", 0);
            long l = DetailsUtils.getLongFieldValue(instance, "intCompact", Long.MIN_VALUE);
            if (l != Long.MIN_VALUE) {
                return BigDecimal.valueOf(l, n).toString();
            }
            Object object = instance.getValueOfField("intVal");
            if (object instanceof Instance && (bigInteger = this.getBigInteger((Instance)object)) != null) {
                return new BigDecimal(bigInteger, n).toString();
            }
        }
        return null;
    }

    private BigInteger getBigInteger(Instance instance) {
        int n = DetailsUtils.getIntFieldValue(instance, "signum", Integer.MAX_VALUE);
        int[] nArray = DetailsUtils.getIntArray(DetailsUtils.getPrimitiveArrayFieldValues(instance, "mag"));
        if (nArray != null && n != Integer.MAX_VALUE) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(nArray.length * 4);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.put(nArray);
            return new BigInteger(n, byteBuffer.array());
        }
        return null;
    }
}

