/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

final class PrintTable {
    private final String[] names;
    private final List<String[]> data;
    private int[] limits;

    public PrintTable(String ... stringArray) {
        this.names = stringArray;
        this.data = new ArrayList<String[]>();
    }

    public void setLimits(int ... nArray) {
        assert (nArray.length == this.names.length);
        this.limits = nArray;
    }

    public void addRow(String ... stringArray) {
        this.data.add(stringArray);
    }

    public void write(PrintStream printStream) {
        int[] nArray = new int[this.names.length];
        PrintTable.length(this.names, nArray, this.limits);
        for (String[] stringArray : this.data) {
            PrintTable.length(stringArray, nArray, this.limits);
        }
        PrintTable.printRow(printStream, this.names, nArray, this.limits);
        PrintTable.printSeparator(printStream, nArray);
        for (String[] stringArray : this.data) {
            PrintTable.printRow(printStream, stringArray, nArray, this.limits);
        }
        PrintTable.printSeparator(printStream, nArray);
    }

    private static void length(String[] stringArray, int[] nArray, int[] nArray2) {
        assert (stringArray.length == nArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length();
            if (nArray2 != null && nArray2[i] >= 0 && n > nArray2[i]) {
                n = nArray2[i];
            }
            if (nArray[i] >= n) continue;
            nArray[i] = n;
        }
    }

    private static void printRow(PrintStream printStream, String[] stringArray, int[] nArray, int[] nArray2) {
        assert (stringArray.length == nArray.length);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.print(string);
            String string2 = stringArray[i];
            if (nArray2 != null && nArray2[i] >= 0 && string2.length() > nArray2[i]) {
                string2 = string2.substring(0, nArray2[i]);
            }
            printStream.print(string2);
            int n = nArray[i] - string2.length();
            while (n-- > 0) {
                printStream.print(' ');
            }
            string = " ";
        }
        printStream.println();
    }

    private static void printSeparator(PrintStream printStream, int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            printStream.print(string);
            for (int j = 0; j < nArray[i]; ++j) {
                printStream.print('-');
            }
            string = " ";
        }
        printStream.println();
    }
}

