/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestisk";
        final String metaValue_ar = "arabisk";
        final String metaValue_bo = "tibetansk";
        final String metaValue_el = "gresk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ja = "japansk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_lo = "laotisk";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_or = "oriya";
        final String metaValue_su = "sundanesisk";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_arc = "arameisk";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_cop = "koptisk";
        final String metaValue_got = "gotisk";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "gammelpersisk";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_saz = "saurashtra";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "syrisk";
        final String metaValue_uga = "ugaritisk";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f8lnsk" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesisk" },
            { "Zsym", "symboler" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egl", "emiliansk" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "gniva- og njivadialekt" },
            { "xmf", "mingrelsk" },
            { "egy", "gammelegyptisk" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotongansk" },
            { "tet", "tetum" },
            { "%%BARLA", "barlaventa-dialektgruppen av kappverdiansk" },
            { "AD", "Andorra" },
            { "AE", "De forente arabiske emirater" },
            { "nl_BE", "flamsk" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "glk", "gileki" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "inskripsjonsparthisk" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "\u00d8sterrike" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "amerikansk engelsk" },
            { "AX", "\u00c5land" },
            { "mye", "myene" },
            { "AZ", "Aserbajdsjan" },
            { "%%AREVELA", "\u00f8st-armensk" },
            { "BA", "Bosnia-Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuansk" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "Belgia" },
            { "gmh", "mellomh\u00f8ytysk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibisk Nederland" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8ya" },
            { "BW", "Botswana" },
            { "BY", "Hviterussland" },
            { "BZ", "Belize" },
            { "Visp", "synlig tale" },
            { "CA", "Canada" },
            { "CC", "Kokos\u00f8yene" },
            { "mzn", "mazandarani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Den sentralafrikanske republikk" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Sveits" },
            { "CI", "Elfenbenskysten" },
            { "CK", "Cook\u00f8yene" },
            { "CL", "Chile" },
            { "Kthi", "kaithisk" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8ya" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kapp Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas\u00f8ya" },
            { "CY", "Kypros" },
            { "CZ", "Tsjekkia" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "pau cin hau" },
            { "vls", "vestflamsk" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "DE", "Tyskland" },
            { "goh", "gammelh\u00f8ytysk" },
            { "ace", "achinesisk" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "goansk konkani" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "DO", "Den dominikanske republikk" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-frankisk" },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "Takr", "takri" },
            { "DZ", "Algerie" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta og Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tiv" },
            { "EG", "Egypt" },
            { "EH", "Vest-Sahara" },
            { "chg", "chagatai" },
            { "pau", "palauisk" },
            { "chk", "chuukesisk" },
            { "chn", "chinook" },
            { "chm", "mari" },
            { "chp", "chipewiansk" },
            { "cho", "choctaw" },
            { "chr", "cherokesisk" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "EU" },
            { "elx", "elamittisk" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adyghe" },
            { "aeb", "tunisisk-arabisk" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8yene" },
            { "FM", "Mikronesiaf\u00f8derasjonen" },
            { "FO", "F\u00e6r\u00f8yene" },
            { "Taml", "tamilsk" },
            { "FR", "Frankrike" },
            { "Kpel", metaValue_kpe },
            { "pcd", "pikardisk" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "%%DAJNKO", "dajnkoalfabet" },
            { "rgn", "romagnolsk" },
            { "grc", "gammelgresk" },
            { "GA", "Gabon" },
            { "tkr", "tsakhursk" },
            { "vot", "votisk" },
            { "GB", "Storbritannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f8nland" },
            { "enm", "mellomengelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorial-Guinea" },
            { "GR", "Hellas" },
            { "GS", "S\u00f8r-Georgia og S\u00f8r-Sandwich\u00f8yene" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "pennsylvaniatysk" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "ny tai lue" },
            { "GY", "Guyana" },
            { "ckb", "kurdisk (sorani)" },
            { "zxx", "uten spr\u00e5klig innhold" },
            { "Jurc", "jurchen" },
            { "tly", "talysh" },
            { "pdt", "plautdietsch" },
            { "de_AT", "\u00f8sterriksk tysk" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong S.A.R. Kina" },
            { "HM", "Heard- og McDonald\u00f8yene" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsertysk" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "rif", "riff" },
            { "tmh", "tamasjek" },
            { "IC", "Kanari\u00f8yene" },
            { "nan", "minnan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "nap", "napolitansk" },
            { "%%NDYUKA", "ndyuka-dialekt" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabataeansk" },
            { "IM", "Man" },
            { "IN", "India" },
            { "IO", "Det britiske territoriet i Indiahavet" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "Zmth", "matematisk notasjon" },
            { "vro", "s\u00f8restisk" },
            { "guc", "wayuu" },
            { "%%POSIX", "dataspr\u00e5k" },
            { "pfl", "palatintysk" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "Beng", "bengalsk" },
            { "%%EKAVSK", "serbisk med ekavisk uttale" },
            { "JO", "Jordan" },
            { "gur", "frafra" },
            { "JP", "Japan" },
            { "%%1606NICT", "nyere mellomfransk til 1606" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "kociewie" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasa-tongansk" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "sveitsisk h\u00f8ytysk" },
            { "izh", "ingrisk" },
            { "KE", "Kenya" },
            { "419", "Latin-Amerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodsja" },
            { "KI", "Kiribati" },
            { "KM", "Komorene" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts og Nevis" },
            { "Zinh", "nedarvet" },
            { "fr_CA", "canadisk fransk" },
            { "KP", "Nord-Korea" },
            { "KR", "S\u00f8r-Korea" },
            { "Plrd", "pollard-fonetisk" },
            { "fr_CH", "sveitsisk fransk" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f8yene" },
            { "KZ", "Kasakhstan" },
            { "Cyrl", "kyrillisk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "kirkeslavisk kyrillisk" },
            { "gwi", "gwichin" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "nedertysk" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadisk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "sentralyupik" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libya" },
            { "lad", "ladinsk" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "%%LAUKIKA", "laukika" },
            { "lah", "lahnda" },
            { "Mahj", "mahajani" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f8yene" },
            { "ale", "aleutisk" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao S.A.R. Kina" },
            { "aln", "gegisk-albansk" },
            { "MP", "Nord-Marianene" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "kapiz" },
            { "MU", "Mauritius" },
            { "alt", "s\u00f8raltaisk" },
            { "MV", "Maldivene" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "Phli", "inskripsjonspahlavi" },
            { "NA", "Namibia" },
            { "NC", "Ny-Caledonia" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "harmonisert revidert ortografi" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f8ya" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Nederland" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakonisk" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "New Zealand" },
            { "Merc", "meroitisk kursiv" },
            { "rom", "romani" },
            { "Mero", "meroitisk" },
            { "crh", "krimtatarisk" },
            { "ang", "gammelengelsk" },
            { "OM", "Oman" },
            { "%%PETR1708", "PETR1708" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "kasjubisk" },
            { "en_GB", "britisk engelsk" },
            { "PE", "Peru" },
            { "ttt", "muslimsk tat" },
            { "PF", "Fransk Polynesia" },
            { "PG", "Papua Ny-Guinea" },
            { "PH", "Filippinene" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "St. Pierre og Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Det palestinske omr\u00e5det" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk standard engelsk" },
            { "jam", "jamaicansk kreolengelsk" },
            { "pms", "piemontesisk" },
            { "niu", "niueansk" },
            { "QO", "ytre Oseania" },
            { "ext", "ekstremaduransk" },
            { "lez", "lezghian" },
            { "%%FONUPA", "det uraliske fonetiske alfabet (UPA)" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "sotavento-dialektgruppen av kappverdiansk" },
            { "001", "verden" },
            { "002", "Afrika" },
            { "njo", "ao naga" },
            { "003", "Nord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00f8r-Amerika" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontisk" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "%%SURSILV", "sursilvan" },
            { "RO", "Romania" },
            { "Qaaw", "qaaw" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "Qaax", "qaax" },
            { "Qaau", "qaau" },
            { "RU", "Russland" },
            { "Qaav", "qaav" },
            { "Qaas", "qaas" },
            { "RW", "Rwanda" },
            { "Qaat", "qaat" },
            { "Qaaq", "qaaq" },
            { "Qaar", "qaar" },
            { "Qaba", "qaba" },
            { "%%METELKO", "Metelko-alfabet" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeisk" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi-Arabia" },
            { "pon", "ponapisk" },
            { "Mand", "mandaisk" },
            { "Qaay", "qaay" },
            { "SB", "Salomon\u00f8yene" },
            { "twq", "tasawaq" },
            { "Qaaz", "qaaz" },
            { "011", "Vest-Afrika" },
            { "SC", "Seychellene" },
            { "Qabh", "qabh" },
            { "SD", "Sudan" },
            { "Qabi", "qabi" },
            { "013", "Mellom-Amerika" },
            { "SE", "Sverige" },
            { "Qabf", "qafb" },
            { "arc", metaValue_arc },
            { "014", "\u00d8st-Afrika" },
            { "Loma", "loma" },
            { "Qabg", "qabg" },
            { "015", "Nord-Afrika" },
            { "SG", "Singapore" },
            { "Qabd", "qabd" },
            { "SH", "St. Helena" },
            { "Qabe", "qabe" },
            { "017", "Sentral-Afrika" },
            { "SI", "Slovenia" },
            { "Qabb", "qabb" },
            { "018", "S\u00f8rlige Afrika" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "Qabc", "qabc" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "Bamu", "bamum" },
            { "Qabp", "qabp" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "Qabq", "qabq" },
            { "SM", "San Marino" },
            { "Qabn", "qabn" },
            { "SN", "Senegal" },
            { "Qabo", "qabo" },
            { "SO", "Somalia" },
            { "arn", "araukansk" },
            { "Qabl", "qabl" },
            { "Qabm", "qabm" },
            { "arp", "arapaho" },
            { "Qabj", "qabj" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "Qabk", "qabk" },
            { "SS", "S\u00f8r-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "arq", "algerisk arabisk" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "arz", "egyptisk arabisk" },
            { "ary", "marokkansk-arabisk" },
            { "yap", "yapesisk" },
            { "rtm", "rotumansk" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Nordlige Amerika" },
            { "TC", "Turks- og Caicos\u00f8yene" },
            { "yav", "yangben" },
            { "TD", "Tsjad" },
            { "Qaag", "qaag" },
            { "Qaah", "qaah" },
            { "TF", "De franske s\u00f8rterritorier" },
            { "ase", "amerikansk tegnspr\u00e5k" },
            { "Qaae", "qaae" },
            { "TG", "Togo" },
            { "Qaaf", "qaaf" },
            { "TH", "Thailand" },
            { "Qaac", "qaac" },
            { "Qaad", "qaad" },
            { "TJ", "Tadsjikistan" },
            { "Qaaa", "qaaa" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "Qaab", "qaab" },
            { "TL", "\u00d8st-Timor" },
            { "ybb", "yemba" },
            { "Qaao", "qaao" },
            { "TM", "Turkmenistan" },
            { "Qaap", "qaap" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "Qaam", "qaam" },
            { "TO", "Tonga" },
            { "Qaan", "qaan" },
            { "%%NULIK", "moderne volap\u00fck" },
            { "Qaak", "qaak" },
            { "Qaal", "qaal" },
            { "TR", "Tyrkia" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturisk" },
            { "rue", "rusinsk" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ukjent skrift" },
            { "Sind", "khudawadi" },
            { "UA", "Ukraina" },
            { "lij", "ligurisk" },
            { "rup", "aromansk" },
            { "030", "\u00d8st-Asia" },
            { "tyv", "tuvinisk" },
            { "sw_CD", "kongolesisk swahili" },
            { "034", "S\u00f8r-Asia" },
            { "hai", "haida" },
            { "035", "S\u00f8r\u00f8st-Asia" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "039", "S\u00f8r-Europa" },
            { "Sinh", "sinhala" },
            { "UM", "USAs ytre \u00f8yer" },
            { "liv", "livisk" },
            { "US", "USA" },
            { "haw", "hawaiisk" },
            { "Qabx", "qabx" },
            { "%%1959ACAD", "akademisk" },
            { "Qabv", "qabv" },
            { "Qabw", "qabw" },
            { "UY", "Uruguay" },
            { "prg", "pr\u00f8yssisk" },
            { "Qabt", "qabt" },
            { "UZ", "Usbekistan" },
            { "Qabu", "qabu" },
            { "tzm", "sentralmarokkansk tamazight" },
            { "Qabr", "qabr" },
            { "Qabs", "qabs" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "gammelproven\u00e7alsk" },
            { "VC", "St. Vincent og Grenadinene" },
            { "VE", "Venezuela" },
            { "VG", "De britiske jomfru\u00f8yene" },
            { "VI", "De amerikanske jomfru\u00f8yene" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "gammelnorsk" },
            { "053", "Australasia" },
            { "%%AREVMDA", "vest-armensk" },
            { "054", "Melanesia" },
            { "WF", "Wallis og Futuna" },
            { "057", "Mikronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "standard ortografi" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "spr\u00e5k uten skrift" },
            { "Olck", "ol-chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "blissymbol" },
            { "YE", "Jemen" },
            { "nqo", "n\u02bcko" },
            { "lmo", "lombardisk" },
            { "fan", "fang" },
            { "%%BALANKA", "balankadialekten av anii" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%SUTSILV", "sutsilvan" },
            { "fat", "fanti" },
            { "Sgnw", "tegnskrift" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00f8r-Afrika" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ukjent omr\u00e5de" },
            { "Runr", "runer" },
            { "lol", "mongo" },
            { "nso", "nord-sotho" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba" },
            { "jmc", "machame" },
            { "hif", "fijiansk hindi" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hettittisk" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "maya-hieroglyfer" },
            { "lrc", "nord-luri" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newari" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "jakutsk" },
            { "ltg", "latgallisk" },
            { "sam", "samaritansk arameisk" },
            { "Aghb", "kaukasus-albansk" },
            { "%%SCOUSE", "scouse dialekt" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "j\u00f8depersisk" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "biscayan" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippinsk" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "baluchi" },
            { "den", "slavisk" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "tornedalsfinsk" },
            { "luy", "luhya" },
            { "bar", "bairisk" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "jrb", "j\u00f8dearabisk" },
            { "es_ES", "europeisk spansk" },
            { "nzi", "nzima" },
            { "sco", "skotsk" },
            { "scn", "siciliansk" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "bbc", "batak toba" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharisk" },
            { "Arab", metaValue_ar },
            { "an", "aragonsk" },
            { "%%SOLBA", "stolvizza- og solbicadialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana eller hiragana" },
            { "as", "assamisk" },
            { "sdc", "sassarisk sardinsk" },
            { "Lina", "line\u00e6r A" },
            { "av", "avarisk" },
            { "Linb", "line\u00e6r B" },
            { "sdh", "s\u00f8rkurdisk" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "oseacco- og osojanedialekt" },
            { "%%UNIFON", "Unifon fonetisk alfabet" },
            { "ba", "basjkirsk" },
            { "be", "hviterussisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "see", "seneca" },
            { "Mymr", "myanmar" },
            { "sei", "seri" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko" },
            { "sel", "selkupisk" },
            { "ca", "katalansk" },
            { "ses", "koyraboro senni" },
            { "ce", "tsjetsjensk" },
            { "ch", "chamorro" },
            { "%%REVISED", "revidert ortografi" },
            { "co", "korsikansk" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tsjekkisk" },
            { "cu", "kirkeslavisk" },
            { "yrl", "nheengatu" },
            { "cv", "tsjuvasjisk" },
            { "cy", "walisisk" },
            { "Yiii", "yi" },
            { "da", "dansk" },
            { "pt_PT", "europeisk portugisisk" },
            { "de", "tysk" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "jut", "jysk" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "gammelirsk" },
            { "dv", "divehi" },
            { "es_419", "latinamerikansk spansk" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "lzh", "klassisk kinesisk" },
            { "Lisu", "fraser" },
            { "dje", "zarma" },
            { "sgs", "samogitisk" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "ro_MD", "moldovsk" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazisk" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "eu", "baskisk" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritansk" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00f8ysorbisk" },
            { "Hani", "han" },
            { "%%ULSTER", "ulster" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persisk" },
            { "Hans", "forenklet" },
            { "Hant", "tradisjonell" },
            { "ff", "fulani" },
            { "shu", "Tsjad-arabisk" },
            { "hsn", "xiang" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fon", "fon" },
            { "bgn", "vestbalutsji" },
            { "yue", "kantonesisk" },
            { "fo", "f\u00e6r\u00f8ysk" },
            { "umb", "umbundu" },
            { "fr", "fransk" },
            { "sid", "sidamo" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk g\u00e6lisk" },
            { "gl", "galisisk" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "ukjent spr\u00e5k" },
            { "gu", metaValue_gu },
            { "gv", "mansk" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "kajunfransk" },
            { "%%FONIPA", "det internasjonale fonetiske alfabet (IPA)" },
            { "ia", "interlingua" },
            { "id", "indonesisk" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan-yi" },
            { "frm", "mellomfransk" },
            { "%%RUMGR", "RUMGR" },
            { "ik", "inupiak" },
            { "fro", "gammelfransk" },
            { "frp", "arpitansk" },
            { "io", "ido" },
            { "frs", "\u00f8stfrisisk" },
            { "bjn", "banjar" },
            { "frr", "nordfrisisk" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "sli", "lavschlesisk" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "gammels\u00f8rarabisk" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "bkm", "kom" },
            { "sma", "s\u00f8rsamisk" },
            { "jv", metaValue_jv },
            { "Shaw", "shavisk" },
            { "%%BAUDDHA", "bauddha" },
            { "mad", "maduresisk" },
            { "smj", "lulesamisk" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "enaresamisk" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "skoltesamisk" },
            { "man", "mandingo" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kasjmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "kornisk" },
            { "ky", "kirgisisk" },
            { "snk", "soninke" },
            { "Mult", "multani" },
            { "la", "latin" },
            { "Hatr", "hatransk armensk" },
            { "lb", "luxemburgsk" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgisk" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friuliansk" },
            { "lo", metaValue_lo },
            { "lt", "litauisk" },
            { "lu", "luba-katanga" },
            { "lv", "latvisk" },
            { "sog", "sogdisk" },
            { "mg", "gassisk" },
            { "mh", "marshallesisk" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayisk" },
            { "mt", "maltesisk" },
            { "Saur", metaValue_saz },
            { "my", "burmesisk" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "Armi", metaValue_arc },
            { "dsb", "lavsorbisk" },
            { "na", "nauru" },
            { "nb", "norsk bokm\u00e5l" },
            { "nd", "nord-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederlandsk" },
            { "nn", "norsk nynorsk" },
            { "no", "norsk" },
            { "nr", "s\u00f8r-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakisk" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabylsk" },
            { "%%POLYTON", "polytonisk rettskriving" },
            { "oc", "oksitansk" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "tidlig moderne engelsk" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "sentraldusun" },
            { "or", metaValue_or },
            { "Modi", "modi" },
            { "os", "ossetisk" },
            { "%%ALALC97", "ALA-LC-romanisering, 1997-utgaven" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardisk" },
            { "mfe", "mauritisk-kreolsk" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "resia med Lipovaz-dialekt" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polsk" },
            { "dum", "mellomnederlandsk" },
            { "%%VALLADER", "vallader" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "mga", "mellomirsk" },
            { "pt_BR", "brasiliansk portugisisk" },
            { "%%BOHORIC", "bohorisk alfabet" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "braj" },
            { "%%JAUER", "jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiransk" },
            { "mgo", "meta\u2019" },
            { "ssy", metaValue_ssy },
            { "brh", "brahui" },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "vaidika" },
            { "stq", "saterfrisisk" },
            { "Ethi", "etiopisk" },
            { "%%JYUTPING", "jyutping" },
            { "rm", "retoromansk" },
            { "rn", "rundi" },
            { "ro", "rumensk" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "russisk" },
            { "bss", "akose" },
            { "rw", "kinyarwanda" },
            { "zbl", "blissymboler" },
            { "kea", "kappverdisk" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australsk engelsk" },
            { "Dupl", "duployan stenografi" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "harmonisert ortografi" },
            { "sc", "sardinsk" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "ken", "kenyang" },
            { "si", "singalesisk" },
            { "sux", "sumerisk" },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "Gran", "gammeltamilsk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "Java", metaValue_jv },
            { "st", "s\u00f8r-sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonedialekt" },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamil" },
            { "142", "Asia" },
            { "bua", "buriat" },
            { "143", "Sentral-Asia" },
            { "te", metaValue_te },
            { "145", "Vest-Asia" },
            { "tg", "tadsjikisk" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "en_CA", "canadisk engelsk" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "setswana" },
            { "to", "tongansk" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "swb", "komorisk" },
            { "Cakm", "chakma" },
            { "tt", "tatarisk" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitisk" },
            { "%%BISKE", "san giorgio- og biladialekt" },
            { "150", "Europa" },
            { "151", "\u00d8st-Europa" },
            { "154", "Nord-Europa" },
            { "dzg", "dazaga" },
            { "155", "Vest-Europa" },
            { "ug", "uigurisk" },
            { "Kore", metaValue_ko },
            { "Ital", "gammelitalisk" },
            { "kgp", "kaingang" },
            { "Zyyy", "felles" },
            { "uk", "ukrainsk" },
            { "zea", "zeeuws" },
            { "ur", "urdu" },
            { "%%1994", "standardisert resisk ortografi" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "usbekisk" },
            { "kha", "khasi" },
            { "%%1996", "tysk ortografi fra 1996" },
            { "nds_NL", "nedersaksisk" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "vi", "vietnamesisk" },
            { "kho", "khotanesisk" },
            { "khq", "koyra chiini" },
            { "%%TARASK", "taraskievica-ortografi" },
            { "vo", "volapyk" },
            { "khw", "khowar" },
            { "syc", "klassisk syrisk" },
            { "Osma", "osmanya" },
            { "quc", "quich\u00e9" },
            { "qug", "kichwa (Chimborazo-h\u00f8ylandet)" },
            { "gaa", "ga" },
            { "wa", "vallonsk" },
            { "gag", "gagausisk" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmancki" },
            { "Lydi", "lydisk" },
            { "Xsux", "sumersk-akkadisk kileskrift" },
            { "wo", "wolof" },
            { "zgh", "standard marrokansk tamazight" },
            { "ar_001", "moderne standard arabisk" },
            { "Cans", "felles kanadiske urspr\u00e5ksstavelser" },
            { "%%FONXSAMP", "fonxsamp" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "mandsju" },
            { "Latf", "frakturlatinsk" },
            { "szl", "schlesisk" },
            { "Hluw", "anatoliske hieroglyfer" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinsk" },
            { "Latg", "g\u00e6lisk latinsk" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "Lyci", "lykisk" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zoroastrisk dari" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "eldre nyfransk" },
            { "Syrc", metaValue_syr },
            { "yi", "jiddisk" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "es_MX", "meksikansk spansk" },
            { "Syrj", "vestlig syriakisk" },
            { "ota", "ottomansk tyrkisk" },
            { "Syre", "estrangelosyriakisk" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "karisk" },
            { "kln", "kalenjin" },
            { "zh", "kinesisk" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "gammelpermisk" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotonisk rettskriving" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "Cham", "cham" },
            { "gez", "ges" },
            { "mrj", "vestmarisk" },
            { "Syrn", "\u00f8stlig syriakisk" },
            { "Elba", "elbasisk" },
            { "Narb", "gammelnordarabisk" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "%%ITIHASA", "itihasa" },
            { "Palm", "palmyrensk" },
            { "ebu", "kiembu" },
            { "Egyp", "egyptiske hieroglyfer" },
            { "Geok", "georgisk khutsuri" },
            { "zh_Hans", "forenklet kinesisk" },
            { "koi", "komipermjakisk" },
            { "Hung", "gammelungarsk" },
            { "kok", "konkani" },
            { "%%1901", "tradisjonell tysk ortografi" },
            { "kos", "kosraeansk" },
            { "vec", "venetiansk" },
            { "zh_Hant", "tradisjonell kinesisk" },
            { "Sund", metaValue_su },
            { "vep", "vepsisk" },
            { "kpe", metaValue_kpe },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensiansk" },
            { "Cprt", "kypriotisk" },
            { "%%BAKU1926", "samlet tyrkisk-latinsk alfabet" },
            { "%%IJEKAVSK", "serbisk med ijekavisk uttale" },
            { "mua", "mundang" },
            { "mul", "flere spr\u00e5k" },
            { "%%PUTER", "PUTER" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagolittisk" },
            { "gil", "kiribatisk" },
            { "%%KKCOR", "felles ortografi" },
            { "Cher", "cherokee" },
            { "car", "karibisk" },
            { "cay", "cayuga" },
            { "krc", "karachay-balkar" },
            { "inh", "ingusjisk" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karelsk" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
