/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.BufferedChecksumStreamOutput;
import org.elasticsearch.index.translog.ChannelFactory;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.MultiSnapshot;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogReader;
import org.elasticsearch.index.translog.TranslogSnapshot;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.index.translog.TruncatedTranslogException;

public class Translog
extends AbstractIndexShardComponent
implements IndexShardComponent,
Closeable {
    public static final String TRANSLOG_GENERATION_KEY = "translog_generation";
    public static final String TRANSLOG_UUID_KEY = "translog_uuid";
    public static final String TRANSLOG_FILE_PREFIX = "translog-";
    public static final String TRANSLOG_FILE_SUFFIX = ".tlog";
    public static final String CHECKPOINT_SUFFIX = ".ckp";
    public static final String CHECKPOINT_FILE_NAME = "translog.ckp";
    public static final int DEFAULT_HEADER_SIZE_IN_BYTES = TranslogWriter.getHeaderLength(UUIDs.randomBase64UUID());
    static final Pattern PARSE_STRICT_ID_PATTERN = Pattern.compile("^translog-(\\d+)(\\.tlog)$");
    private final List<TranslogReader> readers;
    private BigArrays bigArrays;
    protected final ReleasableLock readLock;
    protected final ReleasableLock writeLock;
    private final Path location;
    private TranslogWriter current;
    private final AtomicBoolean closed;
    private final TranslogConfig config;
    private final LongSupplier globalCheckpointSupplier;
    private final String translogUUID;
    private final TranslogDeletionPolicy deletionPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Translog(TranslogConfig config, String expectedTranslogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier) throws IOException {
        block10: {
            super(config.getShardId(), config.getIndexSettings());
            this.readers = new ArrayList<TranslogReader>();
            this.closed = new AtomicBoolean();
            this.config = config;
            this.globalCheckpointSupplier = globalCheckpointSupplier;
            this.deletionPolicy = deletionPolicy;
            this.translogUUID = expectedTranslogUUID == null ? UUIDs.randomBase64UUID() : expectedTranslogUUID;
            this.bigArrays = config.getBigArrays();
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            this.readLock = new ReleasableLock(rwl.readLock());
            this.writeLock = new ReleasableLock(rwl.writeLock());
            this.location = config.getTranslogPath();
            Files.createDirectories(this.location, new FileAttribute[0]);
            try {
                if (expectedTranslogUUID != null) {
                    Checkpoint checkpoint = Translog.readCheckpoint(this.location);
                    Path nextTranslogFile = this.location.resolve(Translog.getFilename(checkpoint.generation + 1L));
                    Path currentCheckpointFile = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
                    assert (!Files.exists(nextTranslogFile, new LinkOption[0]) || Files.size(nextTranslogFile) <= (long)TranslogWriter.getHeaderLength(expectedTranslogUUID)) : "unexpected translog file: [" + nextTranslogFile + "]";
                    if (Files.exists(currentCheckpointFile, new LinkOption[0]) && Files.deleteIfExists(nextTranslogFile)) {
                        this.logger.warn("deleted previously created, but not yet committed, next generation [{}]. This can happen due to a tragic exception when creating a new generation", (Object)nextTranslogFile.getFileName());
                    }
                    this.readers.addAll(this.recoverFromFiles(checkpoint));
                    if (this.readers.isEmpty()) {
                        throw new IllegalStateException("at least one reader must be recovered");
                    }
                    boolean success = false;
                    this.current = null;
                    try {
                        this.current = this.createWriter(checkpoint.generation + 1L, this.getMinFileGeneration(), checkpoint.globalCheckpoint);
                        success = true;
                        break block10;
                    }
                    finally {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.readers);
                        }
                    }
                }
                IOUtils.rm((Path[])new Path[]{this.location});
                long generation = deletionPolicy.getMinTranslogGenerationForRecovery();
                this.logger.debug("wipe translog location - creating new translog, starting generation [{}]", (Object)generation);
                Files.createDirectories(this.location, new FileAttribute[0]);
                long initialGlobalCheckpoint = globalCheckpointSupplier.getAsLong();
                Checkpoint checkpoint = Checkpoint.emptyTranslogCheckpoint(0L, generation, initialGlobalCheckpoint, generation);
                Path checkpointFile = this.location.resolve(CHECKPOINT_FILE_NAME);
                Checkpoint.write(this.getChannelFactory(), checkpointFile, checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                IOUtils.fsync((Path)checkpointFile, (boolean)false);
                this.current = this.createWriter(generation, generation, initialGlobalCheckpoint);
                this.readers.clear();
            }
            catch (Exception e) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.current});
                IOUtils.closeWhileHandlingException(this.readers);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TranslogReader> recoverFromFiles(Checkpoint checkpoint) throws IOException {
        boolean success = false;
        ArrayList<TranslogReader> foundTranslogs = new ArrayList<TranslogReader>();
        Path tempFile = Files.createTempFile(this.location, TRANSLOG_FILE_PREFIX, TRANSLOG_FILE_SUFFIX, new FileAttribute[0]);
        boolean tempFileRenamed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            long minGenerationToRecoverFrom;
            this.logger.debug("open uncommitted translog checkpoint {}", (Object)checkpoint);
            if (checkpoint.minTranslogGeneration < 0L) {
                Version indexVersionCreated = this.indexSettings().getIndexVersionCreated();
                assert (indexVersionCreated.before(Version.V_6_0_0_beta1)) : "no minTranslogGeneration in checkpoint, but index was created with version [" + indexVersionCreated + "]";
                minGenerationToRecoverFrom = this.deletionPolicy.getMinTranslogGenerationForRecovery();
            } else {
                minGenerationToRecoverFrom = checkpoint.minTranslogGeneration;
            }
            String checkpointTranslogFile = Translog.getFilename(checkpoint.generation);
            foundTranslogs.add(this.openReader(this.location.resolve(checkpointTranslogFile), checkpoint));
            for (long i = checkpoint.generation - 1L; i >= minGenerationToRecoverFrom; --i) {
                Path committedTranslogFile = this.location.resolve(Translog.getFilename(i));
                if (!Files.exists(committedTranslogFile, new LinkOption[0])) {
                    throw new IllegalStateException("translog file doesn't exist with generation: " + i + " recovering from: " + minGenerationToRecoverFrom + " checkpoint: " + checkpoint.generation + " - translog ids must be consecutive");
                }
                TranslogReader reader = this.openReader(committedTranslogFile, Checkpoint.read(this.location.resolve(Translog.getCommitCheckpointFileName(i))));
                foundTranslogs.add(reader);
                this.logger.debug("recovered local translog from checkpoint {}", (Object)checkpoint);
            }
            Collections.reverse(foundTranslogs);
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.location.resolve(Translog.getFilename(minGenerationToRecoverFrom - 1L)), this.location.resolve(Translog.getCommitCheckpointFileName(minGenerationToRecoverFrom - 1L))});
            Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
            if (Files.exists(commitCheckpoint, new LinkOption[0])) {
                Checkpoint checkpointFromDisk = Checkpoint.read(commitCheckpoint);
                if (!checkpoint.equals(checkpointFromDisk)) {
                    throw new IllegalStateException("Checkpoint file " + commitCheckpoint.getFileName() + " already exists but has corrupted content expected: " + checkpoint + " but got: " + checkpointFromDisk);
                }
            } else {
                Files.copy(this.location.resolve(CHECKPOINT_FILE_NAME), tempFile, StandardCopyOption.REPLACE_EXISTING);
                IOUtils.fsync((Path)tempFile, (boolean)false);
                Files.move(tempFile, commitCheckpoint, StandardCopyOption.ATOMIC_MOVE);
                tempFileRenamed = true;
                IOUtils.fsync((Path)commitCheckpoint.getParent(), (boolean)true);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(foundTranslogs);
            }
            if (!tempFileRenamed) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException ex) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to delete temp file {}", (Object)tempFile), (Throwable)ex);
                }
            }
        }
        return foundTranslogs;
    }

    TranslogReader openReader(Path path, Checkpoint checkpoint) throws IOException {
        return Translog.openReader(path, checkpoint, this.translogUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TranslogReader openReader(Path path, Checkpoint checkpoint, String translogUUID) throws IOException {
        TranslogReader translogReader;
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        try {
            assert (Translog.parseIdFromFileName(path) == checkpoint.generation) : "expected generation: " + Translog.parseIdFromFileName(path) + " but got: " + checkpoint.generation;
            TranslogReader reader = TranslogReader.open(channel, path, checkpoint, translogUUID);
            channel = null;
            translogReader = reader;
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{channel});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{channel});
        return translogReader;
    }

    public static long parseIdFromFileName(Path translogFile) {
        String fileName = translogFile.getFileName().toString();
        Matcher matcher = PARSE_STRICT_ID_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("number formatting issue in a file that passed PARSE_STRICT_ID_PATTERN: " + fileName + "]", e);
            }
        }
        throw new IllegalArgumentException("can't parse id from file: " + fileName);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                try {
                    this.current.sync();
                }
                finally {
                    this.closeFilesIfNoPendingRetentionLocks();
                }
            }
            finally {
                this.logger.debug("translog closed");
            }
        }
    }

    public Path location() {
        return this.location;
    }

    public long currentFileGeneration() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            long l = this.current.getGeneration();
            return l;
        }
    }

    public long getMinFileGeneration() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            if (this.readers.isEmpty()) {
                long l = this.current.getGeneration();
                return l;
            }
            assert (this.readers.stream().map(BaseTranslogReader::getGeneration).min(Long::compareTo).get().equals(this.readers.get(0).getGeneration())) : "the first translog isn't the one with the minimum generation:" + this.readers;
            long l = this.readers.get(0).getGeneration();
            return l;
        }
    }

    public int totalOperations() {
        return this.totalOperationsByMinGen(-1L);
    }

    public long sizeInBytes() {
        return this.sizeInBytesByMinGen(-1L);
    }

    public int totalOperationsByMinGen(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            int n = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToInt(BaseTranslogReader::totalOperations).sum();
            return n;
        }
    }

    public int estimateTotalOperationsFromMinSeq(long minSeqNo) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            int n = this.readersAboveMinSeqNo(minSeqNo).mapToInt(BaseTranslogReader::totalOperations).sum();
            return n;
        }
    }

    public long sizeInBytesByMinGen(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            long l = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToLong(BaseTranslogReader::sizeInBytes).sum();
            return l;
        }
    }

    TranslogWriter createWriter(long fileGeneration) throws IOException {
        return this.createWriter(fileGeneration, this.getMinFileGeneration(), this.globalCheckpointSupplier.getAsLong());
    }

    TranslogWriter createWriter(long fileGeneration, long initialMinTranslogGen, long initialGlobalCheckpoint) throws IOException {
        TranslogWriter newFile;
        try {
            newFile = TranslogWriter.create(this.shardId, this.translogUUID, fileGeneration, this.location.resolve(Translog.getFilename(fileGeneration)), this.getChannelFactory(), this.config.getBufferSize(), initialMinTranslogGen, initialGlobalCheckpoint, this.globalCheckpointSupplier, this::getMinFileGeneration);
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", e);
        }
        return newFile;
    }

    /*
     * Exception decompiling
     */
    public Location add(Operation operation) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean shouldRollGeneration() {
        long threshold;
        long size = this.current.sizeInBytes();
        return size > (threshold = this.indexSettings.getGenerationThresholdSize().getBytes());
    }

    public Location getLastWriteLocation() {
        try (ReleasableLock lock = this.readLock.acquire();){
            Location location = new Location(this.current.generation, this.current.sizeInBytes() - 1L, Integer.MAX_VALUE);
            return location;
        }
    }

    public long getLastSyncedGlobalCheckpoint() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            long l = this.current.getLastSyncedCheckpoint().globalCheckpoint;
            return l;
        }
    }

    public Snapshot newSnapshot() throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            Snapshot snapshot = this.newSnapshotFromGen(this.getMinFileGeneration());
            return snapshot;
        }
    }

    public Snapshot newSnapshotFromGen(long minGeneration) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            if (minGeneration < this.getMinFileGeneration()) {
                throw new IllegalArgumentException("requested snapshot generation [" + minGeneration + "] is not available. Min referenced generation is [" + this.getMinFileGeneration() + "]");
            }
            TranslogSnapshot[] snapshots = (TranslogSnapshot[])Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(reader -> reader.getGeneration() >= minGeneration).map(BaseTranslogReader::newSnapshot).toArray(TranslogSnapshot[]::new);
            Snapshot snapshot = this.newMultiSnapshot(snapshots);
            return snapshot;
        }
    }

    public Snapshot newSnapshotFromMinSeqNo(long minSeqNo) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            TranslogSnapshot[] snapshots = (TranslogSnapshot[])this.readersAboveMinSeqNo(minSeqNo).map(BaseTranslogReader::newSnapshot).toArray(TranslogSnapshot[]::new);
            Snapshot snapshot = this.newMultiSnapshot(snapshots);
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Snapshot newMultiSnapshot(TranslogSnapshot[] snapshots) throws IOException {
        Closeable onClose;
        if (snapshots.length == 0) {
            onClose = () -> {};
        } else {
            assert (Arrays.stream(snapshots).map(BaseTranslogReader::getGeneration).min(Long::compareTo).get() == snapshots[0].generation) : "first reader generation of " + snapshots + " is not the smallest";
            onClose = this.acquireTranslogGenFromDeletionPolicy(snapshots[0].generation);
        }
        boolean success = false;
        try {
            MultiSnapshot result = new MultiSnapshot(snapshots, onClose);
            success = true;
            MultiSnapshot multiSnapshot = result;
            return multiSnapshot;
        }
        finally {
            if (!success) {
                onClose.close();
            }
        }
    }

    private Stream<? extends BaseTranslogReader> readersAboveMinSeqNo(long minSeqNo) {
        assert (this.readLock.isHeldByCurrentThread().booleanValue() || this.writeLock.isHeldByCurrentThread().booleanValue()) : "callers of readersAboveMinSeqNo must hold a lock: readLock [" + this.readLock.isHeldByCurrentThread() + "], writeLock [" + this.readLock.isHeldByCurrentThread() + "]";
        return Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(reader -> {
            long maxSeqNo = reader.getCheckpoint().maxSeqNo;
            return maxSeqNo == -2L || maxSeqNo >= minSeqNo;
        });
    }

    public Closeable acquireRetentionLock() {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            long viewGen = this.getMinFileGeneration();
            Closeable closeable = this.acquireTranslogGenFromDeletionPolicy(viewGen);
            return closeable;
        }
    }

    private Closeable acquireTranslogGenFromDeletionPolicy(long viewGen) {
        Releasable toClose = this.deletionPolicy.acquireTranslogGen(viewGen);
        return () -> {
            try {
                toClose.close();
            }
            finally {
                this.trimUnreferencedReaders();
                this.closeFilesIfNoPendingRetentionLocks();
            }
        };
    }

    public void sync() throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (!this.closed.get()) {
                this.current.sync();
            }
        }
        catch (Exception ex) {
            try {
                this.closeOnTragicEvent(ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
    }

    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded();
            return bl;
        }
    }

    public static String getFilename(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + TRANSLOG_FILE_SUFFIX;
    }

    static String getCommitCheckpointFileName(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + CHECKPOINT_SUFFIX;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ensureSynced(Location location) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (location.generation != this.current.getGeneration()) return false;
            this.ensureOpen();
            boolean bl = this.current.syncUpTo(location.translogLocation + (long)location.size);
            return bl;
        }
        catch (Exception ex) {
            try {
                this.closeOnTragicEvent(ex);
                throw ex;
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
    }

    public boolean ensureSynced(Stream<Location> locations) throws IOException {
        Optional<Location> max = locations.max(Location::compareTo);
        if (max.isPresent()) {
            return this.ensureSynced(max.get());
        }
        return false;
    }

    private void closeOnTragicEvent(Exception ex) {
        if (this.current.getTragicException() != null) {
            try {
                this.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception inner) {
                assert (ex != inner.getCause());
                ex.addSuppressed(inner);
            }
        }
    }

    public TranslogStats stats() {
        try (ReleasableLock lock = this.readLock.acquire();){
            long uncommittedGen = this.deletionPolicy.getTranslogGenerationOfLastCommit();
            TranslogStats translogStats = new TranslogStats(this.totalOperations(), this.sizeInBytes(), this.totalOperationsByMinGen(uncommittedGen), this.sizeInBytesByMinGen(uncommittedGen));
            return translogStats;
        }
    }

    public TranslogConfig getConfig() {
        return this.config;
    }

    public TranslogDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    private static void verifyChecksum(BufferedChecksumStreamInput in) throws IOException {
        long expectedChecksum = in.getChecksum();
        long readChecksum = (long)in.readInt() & 0xFFFFFFFFL;
        if (readChecksum != expectedChecksum) {
            throw new TranslogCorruptedException("translog stream is corrupted, expected: 0x" + Long.toHexString(expectedChecksum) + ", got: 0x" + Long.toHexString(readChecksum));
        }
    }

    public static List<Operation> readOperations(StreamInput input) throws IOException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        int numOps = input.readInt();
        BufferedChecksumStreamInput checksumStreamInput = new BufferedChecksumStreamInput(input);
        for (int i = 0; i < numOps; ++i) {
            operations.add(Translog.readOperation(checksumStreamInput));
        }
        return operations;
    }

    static Operation readOperation(BufferedChecksumStreamInput in) throws IOException {
        Operation operation;
        try {
            int opSize = in.readInt();
            if (opSize < 4) {
                throw new TranslogCorruptedException("operation size must be at least 4 but was: " + opSize);
            }
            in.resetDigest();
            if (in.markSupported()) {
                in.mark(opSize);
                in.skip(opSize - 4);
                Translog.verifyChecksum(in);
                in.reset();
            }
            operation = Operation.readOperation(in);
            Translog.verifyChecksum(in);
        }
        catch (TranslogCorruptedException e) {
            throw e;
        }
        catch (EOFException e) {
            throw new TruncatedTranslogException("reached premature end of file, translog is truncated", e);
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOperations(StreamOutput outStream, List<Operation> toWrite) throws IOException {
        ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(BigArrays.NON_RECYCLING_INSTANCE);
        try {
            outStream.writeInt(toWrite.size());
            BufferedChecksumStreamOutput checksumStreamOutput = new BufferedChecksumStreamOutput(out);
            for (Operation op : toWrite) {
                out.reset();
                long start = out.position();
                out.skip(4);
                Translog.writeOperationNoSize(checksumStreamOutput, op);
                long end = out.position();
                int operationSize = (int)(out.position() - 4L - start);
                out.seek(start);
                out.writeInt(operationSize);
                out.seek(end);
                ReleasablePagedBytesReference bytes = out.bytes();
                bytes.writeTo(outStream);
            }
        }
        catch (Throwable throwable) {
            Releasables.close(out);
            throw throwable;
        }
        Releasables.close(out);
    }

    public static void writeOperationNoSize(BufferedChecksumStreamOutput out, Operation op) throws IOException {
        out.resetDigest();
        Operation.writeOperation(out, op);
        long checksum = out.getChecksum();
        out.writeInt((int)checksum);
    }

    public TranslogGeneration getMinGenerationForSeqNo(long seqNo) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            long minTranslogFileGeneration = this.currentFileGeneration();
            for (TranslogReader reader : this.readers) {
                if (seqNo > reader.getCheckpoint().maxSeqNo) continue;
                minTranslogFileGeneration = Math.min(minTranslogFileGeneration, reader.getGeneration());
            }
            TranslogGeneration translogGeneration = new TranslogGeneration(this.translogUUID, minTranslogFileGeneration);
            return translogGeneration;
        }
    }

    public void rollGeneration() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            try {
                TranslogReader reader = this.current.closeIntoReader();
                this.readers.add(reader);
                Path checkpoint = this.location.resolve(CHECKPOINT_FILE_NAME);
                assert (Checkpoint.read((Path)checkpoint).generation == this.current.getGeneration());
                Path generationCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(this.current.getGeneration()));
                Files.copy(checkpoint, generationCheckpoint, new CopyOption[0]);
                IOUtils.fsync((Path)generationCheckpoint, (boolean)false);
                IOUtils.fsync((Path)generationCheckpoint.getParent(), (boolean)true);
                this.current = this.createWriter(this.current.getGeneration() + 1L);
                this.logger.trace("current translog set to [{}]", (Object)this.current.getGeneration());
            }
            catch (Exception e) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
                throw e;
            }
        }
    }

    public void trimUnreferencedReaders() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            TranslogReader reader;
            if (this.closed.get()) {
                return;
            }
            long minReferencedGen = this.deletionPolicy.minTranslogGenRequired(this.readers, this.current);
            assert (minReferencedGen >= this.getMinFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
            assert (minReferencedGen <= this.currentFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
            Iterator<TranslogReader> iterator = this.readers.iterator();
            while (iterator.hasNext() && (reader = iterator.next()).getGeneration() < minReferencedGen) {
                iterator.remove();
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                Path translogPath = reader.path();
                this.logger.trace("delete translog file [{}], not referenced and not current anymore", (Object)translogPath);
                this.current.sync();
                this.deleteReaderFiles(reader);
            }
            assert (!this.readers.isEmpty() || this.current.generation == minReferencedGen) : "all readers were cleaned but the minReferenceGen [" + minReferencedGen + "] is not the current writer's gen [" + this.current.generation + "]";
        }
        catch (Exception ex) {
            try {
                this.closeOnTragicEvent(ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
    }

    void deleteReaderFiles(TranslogReader reader) {
        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{reader.path(), reader.path().resolveSibling(Translog.getCommitCheckpointFileName(reader.getGeneration()))});
    }

    void closeFilesIfNoPendingRetentionLocks() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            if (this.closed.get() && this.deletionPolicy.pendingTranslogRefCount() == 0) {
                this.logger.trace("closing files. translog is closed and there are no pending retention locks");
                ArrayList<TranslogReader> toClose = new ArrayList<TranslogReader>(this.readers);
                toClose.add((TranslogReader)((Object)this.current));
                IOUtils.close(toClose);
            }
        }
    }

    public TranslogGeneration getGeneration() {
        try (ReleasableLock lock = this.writeLock.acquire();){
            TranslogGeneration translogGeneration = new TranslogGeneration(this.translogUUID, this.currentFileGeneration());
            return translogGeneration;
        }
    }

    public boolean isCurrent(TranslogGeneration generation) {
        try (ReleasableLock lock = this.writeLock.acquire();){
            if (generation != null) {
                if (!generation.translogUUID.equals(this.translogUUID)) {
                    throw new IllegalArgumentException("commit belongs to a different translog: " + generation.translogUUID + " vs. " + this.translogUUID);
                }
                boolean bl = generation.translogFileGeneration == this.currentFileGeneration();
                return bl;
            }
        }
        return false;
    }

    long getFirstOperationPosition() {
        return this.current.getFirstOperationOffset();
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new AlreadyClosedException("translog is already closed", (Throwable)this.current.getTragicException());
        }
    }

    ChannelFactory getChannelFactory() {
        return FileChannel::open;
    }

    public Exception getTragicException() {
        return this.current.getTragicException();
    }

    static Checkpoint readCheckpoint(Path location) throws IOException {
        return Checkpoint.read(location.resolve(CHECKPOINT_FILE_NAME));
    }

    public static long readGlobalCheckpoint(Path location, String expectedTranslogUUID) throws IOException {
        Checkpoint checkpoint = Translog.readCheckpoint(location);
        Path translogFile = location.resolve(Translog.getFilename(checkpoint.generation));
        try {
            TranslogReader reader = Translog.openReader(translogFile, checkpoint, expectedTranslogUUID);
            Throwable throwable = null;
            if (reader != null) {
                Translog.$closeResource(throwable, reader);
            }
        }
        catch (TranslogCorruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TranslogCorruptedException("Translog at [" + location + "] is corrupted", ex);
        }
        return checkpoint.globalCheckpoint;
    }

    public static long readMinReferencedGen(Path location) throws IOException {
        return Translog.readCheckpoint((Path)location).minTranslogGeneration;
    }

    public String getTranslogUUID() {
        return this.translogUUID;
    }

    TranslogWriter getCurrent() {
        return this.current;
    }

    List<TranslogReader> getReaders() {
        return this.readers;
    }

    public static final class TranslogGeneration {
        public final String translogUUID;
        public final long translogFileGeneration;

        public TranslogGeneration(String translogUUID, long translogFileGeneration) {
            this.translogUUID = translogUUID;
            this.translogFileGeneration = translogFileGeneration;
        }
    }

    public static enum Durability {
        ASYNC,
        REQUEST;

    }

    public static class NoOp
    implements Operation {
        private final long seqNo;
        private final long primaryTerm;
        private final String reason;

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public String reason() {
            return this.reason;
        }

        private NoOp(StreamInput in) throws IOException {
            this.seqNo = in.readLong();
            this.primaryTerm = in.readLong();
            this.reason = in.readString();
        }

        public NoOp(long seqNo, long primaryTerm, String reason) {
            assert (seqNo > -1L);
            assert (primaryTerm >= 0L);
            assert (reason != null);
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.reason = reason;
        }

        private void write(StreamOutput out) throws IOException {
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeString(this.reason);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.NO_OP;
        }

        @Override
        public long estimateSize() {
            return 2 * this.reason.length() + 16;
        }

        @Override
        public Source getSource() {
            throw new UnsupportedOperationException("source does not exist for a no-op");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NoOp that = (NoOp)obj;
            return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && this.reason.equals(that.reason);
        }

        public int hashCode() {
            return 29791 + 961 * Long.hashCode(this.seqNo) + 31 * Long.hashCode(this.primaryTerm) + this.reason().hashCode();
        }

        public String toString() {
            return "NoOp{seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", reason='" + this.reason + '\'' + '}';
        }
    }

    public static class Delete
    implements Operation {
        public static final int FORMAT_5_0 = 2;
        private static final int FORMAT_SINGLE_TYPE = 3;
        private static final int FORMAT_SEQ_NO = 4;
        public static final int SERIALIZATION_FORMAT = 4;
        private final String type;
        private final String id;
        private final Term uid;
        private final long seqNo;
        private final long primaryTerm;
        private final long version;
        private final VersionType versionType;

        private Delete(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format >= 2) : "format was: " + format;
            if (format >= 3) {
                this.type = in.readString();
                this.id = in.readString();
                this.uid = format >= 4 ? new Term(in.readString(), in.readBytesRef()) : new Term(in.readString(), in.readString());
            } else {
                this.uid = new Term(in.readString(), in.readString());
                Uid uidObject = Uid.createUid(this.uid.text());
                this.type = uidObject.type();
                this.id = uidObject.id();
            }
            this.version = in.readLong();
            this.versionType = VersionType.fromValue(in.readByte());
            assert (this.versionType.validateVersionForWrites(this.version));
            if (format >= 4) {
                this.seqNo = in.readLong();
                this.primaryTerm = in.readLong();
            } else {
                this.seqNo = -2L;
                this.primaryTerm = 0L;
            }
        }

        public Delete(Engine.Delete delete, Engine.DeleteResult deleteResult) {
            this(delete.type(), delete.id(), delete.uid(), deleteResult.getSeqNo(), delete.primaryTerm(), deleteResult.getVersion(), delete.versionType());
        }

        public Delete(String type, String id, long seqNo, Term uid) {
            this(type, id, uid, seqNo, 0L, -3L, VersionType.INTERNAL);
        }

        public Delete(String type, String id, Term uid, long seqNo, long primaryTerm, long version, VersionType versionType) {
            this.type = Objects.requireNonNull(type);
            this.id = Objects.requireNonNull(id);
            this.uid = uid;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
            this.versionType = versionType;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            throw new IllegalStateException("trying to read doc source from delete operation");
        }

        private void write(StreamOutput out) throws IOException {
            out.writeVInt(4);
            out.writeString(this.type);
            out.writeString(this.id);
            out.writeString(this.uid.field());
            out.writeBytesRef(this.uid.bytes());
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Delete delete = (Delete)o;
            return this.version == delete.version && this.seqNo == delete.seqNo && this.primaryTerm == delete.primaryTerm && this.uid.equals((Object)delete.uid) && this.versionType == delete.versionType;
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + Long.hashCode(this.seqNo);
            result = 31 * result + Long.hashCode(this.primaryTerm);
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            return result;
        }

        public String toString() {
            return "Delete{uid=" + this.uid + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + '}';
        }
    }

    public static class Index
    implements Operation {
        public static final int FORMAT_2_X = 6;
        public static final int FORMAT_AUTO_GENERATED_IDS = 7;
        public static final int FORMAT_SEQ_NO = 8;
        public static final int SERIALIZATION_FORMAT = 8;
        private final String id;
        private final long autoGeneratedIdTimestamp;
        private final String type;
        private final long seqNo;
        private final long primaryTerm;
        private final long version;
        private final VersionType versionType;
        private final BytesReference source;
        private final String routing;
        private final String parent;

        private Index(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format >= 6) : "format was: " + format;
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            this.routing = in.readOptionalString();
            this.parent = in.readOptionalString();
            this.version = in.readLong();
            if (format < 8) {
                in.readLong();
                in.readLong();
            }
            this.versionType = VersionType.fromValue(in.readByte());
            assert (this.versionType.validateVersionForWrites(this.version)) : "invalid version for writes: " + this.version;
            this.autoGeneratedIdTimestamp = format >= 7 ? in.readLong() : -1L;
            if (format >= 8) {
                this.seqNo = in.readLong();
                this.primaryTerm = in.readLong();
            } else {
                this.seqNo = -2L;
                this.primaryTerm = 0L;
            }
        }

        public Index(Engine.Index index, Engine.IndexResult indexResult) {
            this.id = index.id();
            this.type = index.type();
            this.source = index.source();
            this.routing = index.routing();
            this.parent = index.parent();
            this.seqNo = indexResult.getSeqNo();
            this.primaryTerm = index.primaryTerm();
            this.version = indexResult.getVersion();
            this.versionType = index.versionType();
            this.autoGeneratedIdTimestamp = index.getAutoGeneratedIdTimestamp();
        }

        public Index(String type, String id, long seqNo, byte[] source) {
            this(type, id, seqNo, -3L, VersionType.INTERNAL, source, null, null, -1L);
        }

        public Index(String type, String id, long seqNo, long version, VersionType versionType, byte[] source, String routing, String parent, long autoGeneratedIdTimestamp) {
            this.type = type;
            this.id = id;
            this.source = new BytesArray(source);
            this.seqNo = seqNo;
            this.primaryTerm = 0L;
            this.version = version;
            this.versionType = versionType;
            this.routing = routing;
            this.parent = parent;
            this.autoGeneratedIdTimestamp = autoGeneratedIdTimestamp;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.INDEX;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public BytesReference source() {
            return this.source;
        }

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            return new Source(this.source, this.routing, this.parent);
        }

        private void write(StreamOutput out) throws IOException {
            out.writeVInt(8);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            out.writeOptionalString(this.routing);
            out.writeOptionalString(this.parent);
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
            out.writeLong(this.autoGeneratedIdTimestamp);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (!(this.version == index.version && this.seqNo == index.seqNo && this.primaryTerm == index.primaryTerm && this.id.equals(index.id) && this.type.equals(index.type) && this.versionType == index.versionType && this.autoGeneratedIdTimestamp == index.autoGeneratedIdTimestamp && this.source.equals(index.source))) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(index.routing) : index.routing != null) {
                return false;
            }
            return !(this.parent == null ? index.parent != null : !this.parent.equals(index.parent));
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + Long.hashCode(this.seqNo);
            result = 31 * result + Long.hashCode(this.primaryTerm);
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + Long.hashCode(this.autoGeneratedIdTimestamp);
            return result;
        }

        public String toString() {
            return "Index{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + '}';
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;
        public final String parent;

        public Source(BytesReference source, String routing, String parent) {
            this.source = source;
            this.routing = routing;
            this.parent = parent;
        }
    }

    public static interface Operation {
        public Type opType();

        public long estimateSize();

        public Source getSource();

        public long seqNo();

        public long primaryTerm();

        public static Operation readOperation(StreamInput input) throws IOException {
            Type type = Type.fromId(input.readByte());
            switch (type) {
                case CREATE: 
                case INDEX: {
                    return new Index(input);
                }
                case DELETE: {
                    return new Delete(input);
                }
                case NO_OP: {
                    return new NoOp(input);
                }
            }
            throw new AssertionError((Object)("no case for [" + (Object)((Object)type) + "]"));
        }

        public static void writeOperation(StreamOutput output, Operation operation) throws IOException {
            output.writeByte(operation.opType().id());
            switch (operation.opType()) {
                case CREATE: 
                case INDEX: {
                    ((Index)operation).write(output);
                    break;
                }
                case DELETE: {
                    ((Delete)operation).write(output);
                    break;
                }
                case NO_OP: {
                    ((NoOp)operation).write(output);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("no case for [" + (Object)((Object)operation.opType()) + "]"));
                }
            }
        }

        public static enum Type {
            CREATE(1),
            INDEX(2),
            DELETE(3),
            NO_OP(4);

            private final byte id;

            private Type(byte id) {
                this.id = id;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id) {
                switch (id) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return INDEX;
                    }
                    case 3: {
                        return DELETE;
                    }
                    case 4: {
                        return NO_OP;
                    }
                }
                throw new IllegalArgumentException("no type mapped for [" + id + "]");
            }
        }
    }

    public static interface Snapshot
    extends Closeable {
        public int totalOperations();

        default public int overriddenOperations() {
            return 0;
        }

        public Operation next() throws IOException;
    }

    public static class Location
    implements Comparable<Location> {
        public final long generation;
        public final long translogLocation;
        public final int size;

        public Location(long generation, long translogLocation, int size) {
            this.generation = generation;
            this.translogLocation = translogLocation;
            this.size = size;
        }

        public String toString() {
            return "[generation: " + this.generation + ", location: " + this.translogLocation + ", size: " + this.size + "]";
        }

        @Override
        public int compareTo(Location o) {
            if (this.generation == o.generation) {
                return Long.compare(this.translogLocation, o.translogLocation);
            }
            return Long.compare(this.generation, o.generation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.generation != location.generation) {
                return false;
            }
            if (this.translogLocation != location.translogLocation) {
                return false;
            }
            return this.size == location.size;
        }

        public int hashCode() {
            int result = Long.hashCode(this.generation);
            result = 31 * result + Long.hashCode(this.translogLocation);
            result = 31 * result + this.size;
            return result;
        }
    }
}

