/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatVariable(@NotNull PsiVariable variable2, @FormatVariableOptions int options, PsiSubstitutor substitutor2) {
        if (variable2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable2, options, substitutor2, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable2, @FormatVariableOptions int options, PsiSubstitutor substitutor2, @NotNull StringBuilder buffer) {
        PsiExpression initializer2;
        String name;
        if (variable2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(1);
        }
        if (buffer == null) {
            PsiFormatUtil.$$$reportNull$$$0(2);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable2, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(variable2.getType(), options, substitutor2));
        }
        if (variable2 instanceof PsiField && BitUtil.isSet(options, 4096)) {
            String className2;
            PsiClass aClass2 = ((PsiField)variable2).getContainingClass();
            if (aClass2 != null && (className2 = aClass2.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if (BitUtil.isSet(options, 2048)) {
                    buffer.append(ObjectUtils.notNull(aClass2.getQualifiedName(), className2));
                } else {
                    buffer.append(className2);
                }
                buffer.append('.');
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(variable2.getName());
            }
        } else if (BitUtil.isSet(options, 1) && StringUtil.isNotEmpty(name = variable2.getName())) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name);
        }
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4)) {
            if (BitUtil.isSet(options, 1) && variable2.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable2.getType(), options, substitutor2));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable2, options, buffer);
        }
        if (BitUtil.isSet(options, 128) && (initializer2 = variable2.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text2 = PsiExpressionTrimRenderer.render(initializer2);
            int index1 = text2.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text2.length();
            }
            if ((index2 = text2.lastIndexOf(13)) < 0) {
                index2 = text2.length();
            }
            int index3 = Math.min(index1, index2);
            buffer.append(text2.substring(0, index3));
            if (index3 < text2.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(4);
        }
        return PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(5);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(6);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type2;
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(7);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(8);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4) && (type2 = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(type2, options, substitutor2));
        }
        if (BitUtil.isSet(options, 4096)) {
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name = aClass2.getName();
                if (name != null) {
                    if (BitUtil.isSet(options, 2048)) {
                        buffer.append(ObjectUtils.notNull(aClass2.getQualifiedName(), name));
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(method.getName());
            }
        } else if (BitUtil.isSet(options, 1)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        if (BitUtil.isSet(options, 256)) {
            buffer.append('(');
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(params.length, maxParametersToShow); ++i) {
                PsiParameter parm = params[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(parm, parameterOptions, substitutor2));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4) && (type2 = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type2, options, substitutor2));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 512) && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ");
            buffer.append(throwsText);
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass2, @FormatClassOptions int options) {
        if (aClass2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(9);
        }
        StringBuilder buffer = new StringBuilder();
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass2, options, buffer);
        }
        if (BitUtil.isSet(options, 1)) {
            if (aClass2 instanceof PsiAnonymousClass && BitUtil.isSet(options, 32768)) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass2).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass2.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if (BitUtil.isSet(options, 2048)) {
                        String qName = aClass2.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass2.getName());
                        }
                    } else {
                        buffer.append(aClass2.getName());
                    }
                }
            }
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass2, options, buffer);
        }
        if (BitUtil.isSet(options, 1024)) {
            String implementsText;
            PsiReferenceList implementsList;
            String extendsText;
            PsiReferenceList extendsList = aClass2.getExtendsList();
            if (extendsList != null && !(extendsText = PsiFormatUtil.formatReferenceList(extendsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ");
                buffer.append(extendsText);
            }
            if ((implementsList = aClass2.getImplementsList()) != null && !(implementsText = PsiFormatUtil.formatReferenceList(implementsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ");
                buffer.append(implementsText);
            }
        }
        String string = buffer.toString();
        if (string == null) {
            PsiFormatUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static String formatModifiers(PsiElement element, int options) throws IllegalArgumentException {
        if (element instanceof PsiModifierListOwner) {
            return PsiFormatUtil.formatModifiers((PsiModifierListOwner)element, options);
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public static String formatModifiers(@NotNull PsiModifierListOwner element, int options) {
        if (element == null) {
            PsiFormatUtil.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        String string = buffer.toString();
        if (string == null) {
            PsiFormatUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void formatModifiers(PsiModifierListOwner element, int options, StringBuilder buffer) {
        boolean isInterface;
        PsiModifierList list2 = element.getModifierList();
        if (list2 == null) {
            return;
        }
        if (!BitUtil.isSet(options, 32) ? list2.hasExplicitModifier("public") : list2.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list2.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list2.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if (!BitUtil.isSet(options, 32) ? list2.hasExplicitModifier("packageLocal") : list2.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.append(buffer, PsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, "packageLocal");
            }
        }
        if (!BitUtil.isSet(options, 32) ? list2.hasExplicitModifier("static") : list2.hasModifierProperty("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        boolean bl = isInterface = element instanceof PsiClass && ((PsiClass)element).isInterface();
        if (!isInterface && (!BitUtil.isSet(options, 32) ? list2.hasExplicitModifier("abstract") : list2.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if (!BitUtil.isSet(options, 32) ? list2.hasExplicitModifier("final") : list2.hasModifierProperty("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list2.hasModifierProperty("native") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list2.hasModifierProperty("synchronized") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list2.hasModifierProperty("strictfp") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list2.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list2.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, @PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            PsiFormatUtil.$$$reportNull$$$0(13);
        }
        PsiFormatUtil.append(buffer, VisibilityUtil.toPresentableText(modifier));
    }

    private static void append(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    public static String formatReferenceList(PsiReferenceList list2, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiJavaCodeReferenceElement[] refs = list2.getReferenceElements();
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(PsiFormatUtil.formatReference(ref, options));
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type2, int options, @NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(14);
        }
        type2 = substitutor2.substitute(type2);
        if (BitUtil.isSet(options, 65536)) {
            type2 = TypeConversionUtil.erasure(type2);
        } else if (BitUtil.isSet(options, 131072) && !(PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type2 instanceof PsiEllipsisType;
            type2 = TypeConversionUtil.erasure(type2);
            if (preserveEllipsis && type2 instanceof PsiArrayType) {
                type2 = new PsiEllipsisType(((PsiArrayType)type2).getComponentType());
            }
        }
        if (type2 == null) {
            return "null";
        }
        return !BitUtil.isSet(options, 8192) ? type2.getPresentableText(false) : (!BitUtil.isSet(options, 262144) ? type2.getCanonicalText(false) : type2.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return !BitUtil.isSet(options, 8192) ? ref.getText() : ref.getCanonicalText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(" ");
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(" ").append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(" ");
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
            builder.append(" ");
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiFormatUtil.$$$reportNull$$$0(15);
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        if (PsiUtil.isLocalClass(psiClass)) {
            return "local class";
        }
        String packageName = psiClass.getQualifiedName();
        String string = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.isEmpty()) {
            packageName = "default package";
        }
        return packageName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatVariable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatModifiers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendModifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

