/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.plugins.repository.jar.JarRepository;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;

public class JarResolver
extends RepositoryResolver {
    private URL url;

    public JarResolver() {
        this.setRepository(new JarRepository());
    }

    @Override
    public String getTypeName() {
        return "jar";
    }

    public void setFile(String string) {
        this.setJarFile(new File(string));
    }

    public void setUrl(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("the jar repository " + this.getName() + " has an malformed url : " + string + " (" + malformedURLException.getMessage() + ")");
        }
    }

    public JarRepository getJarRepository() {
        return (JarRepository)super.getRepository();
    }

    private void setJarFile(File file) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("the jar repository " + this.getName() + " could not be read (" + iOException.getMessage() + ")", iOException);
        }
        this.getJarRepository().setJarFile(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSettings(ResolverSettings resolverSettings) {
        super.setSettings(resolverSettings);
        if (this.url != null) {
            ArtifactDownloadReport artifactDownloadReport;
            EventManager eventManager = this.getEventManager();
            try {
                if (eventManager != null) {
                    this.getRepository().addTransferListener(eventManager);
                }
                URLResource uRLResource = new URLResource(this.url);
                CacheResourceOptions cacheResourceOptions = new CacheResourceOptions();
                artifactDownloadReport = this.getRepositoryCacheManager().downloadRepositoryResource(uRLResource, "jarrepository", "jar", "jar", cacheResourceOptions, new URLRepository());
            }
            finally {
                if (eventManager != null) {
                    this.getRepository().removeTransferListener(eventManager);
                }
            }
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
                throw new RuntimeException("The jar file " + this.url.toExternalForm() + " could not be downloaded (" + artifactDownloadReport.getDownloadDetails() + ")");
            }
            this.setJarFile(artifactDownloadReport.getLocalFile());
        }
    }
}

