/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.AbstractNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;

public class IndexedNormalizedFileSnapshot
extends AbstractNormalizedFileSnapshot {
    private final String absolutePath;
    private final int index;

    public IndexedNormalizedFileSnapshot(String absolutePath, int index, FileContentSnapshot snapshot) {
        super(snapshot);
        this.absolutePath = absolutePath;
        this.index = index;
    }

    public String getNormalizedPath() {
        return this.absolutePath.substring(this.index);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean hasSameNormalizedPathAs(AbstractNormalizedFileSnapshot other) {
        if (other instanceof IndexedNormalizedFileSnapshot) {
            int otherLength;
            IndexedNormalizedFileSnapshot that = (IndexedNormalizedFileSnapshot)other;
            int myLength = this.absolutePath.length() - this.index;
            if (myLength != (otherLength = that.absolutePath.length() - that.index)) {
                return false;
            }
            return this.absolutePath.regionMatches(this.index, that.absolutePath, that.index, myLength);
        }
        return false;
    }

    protected int hashNormalizedPath() {
        int h = 0;
        for (int i = this.index; i < this.absolutePath.length(); ++i) {
            h = 31 * h + this.absolutePath.charAt(i);
        }
        return h;
    }
}

