/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderSensitiveTaskFilePropertyCompareStrategy
implements TaskFilePropertyCompareStrategy.Impl {
    OrderSensitiveTaskFilePropertyCompareStrategy() {
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, final String fileType, boolean isPathAbsolute, final boolean includeAdded) {
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = current.entrySet().iterator();
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> previousEntries = previous.entrySet().iterator();
        return new AbstractIterator<TaskStateChange>(){
            private TaskStateChange remaining;

            protected TaskStateChange computeNext() {
                if (this.remaining != null) {
                    TaskStateChange next = this.remaining;
                    this.remaining = null;
                    return next;
                }
                while (currentEntries.hasNext()) {
                    Map.Entry current = (Map.Entry)currentEntries.next();
                    String currentAbsolutePath = (String)current.getKey();
                    if (previousEntries.hasNext()) {
                        String previousNormalizedPath;
                        Map.Entry previous = (Map.Entry)previousEntries.next();
                        NormalizedFileSnapshot currentNormalizedSnapshot = (NormalizedFileSnapshot)current.getValue();
                        NormalizedFileSnapshot previousNormalizedSnapshot = (NormalizedFileSnapshot)previous.getValue();
                        String currentNormalizedPath = currentNormalizedSnapshot.getNormalizedPath();
                        if (currentNormalizedPath.equals(previousNormalizedPath = previousNormalizedSnapshot.getNormalizedPath())) {
                            if (currentNormalizedSnapshot.getSnapshot().isContentUpToDate(previousNormalizedSnapshot.getSnapshot())) continue;
                            return FileChange.modified(currentAbsolutePath, fileType, previousNormalizedSnapshot.getSnapshot().getType(), currentNormalizedSnapshot.getSnapshot().getType());
                        }
                        String previousAbsolutePath = (String)previous.getKey();
                        if (includeAdded) {
                            this.remaining = FileChange.added(currentAbsolutePath, fileType, currentNormalizedSnapshot.getSnapshot().getType());
                        }
                        return FileChange.removed(previousAbsolutePath, fileType, previousNormalizedSnapshot.getSnapshot().getType());
                    }
                    if (!includeAdded) continue;
                    return FileChange.added(currentAbsolutePath, fileType, ((NormalizedFileSnapshot)current.getValue()).getSnapshot().getType());
                }
                if (previousEntries.hasNext()) {
                    Map.Entry previousEntry = (Map.Entry)previousEntries.next();
                    return FileChange.removed((String)previousEntry.getKey(), fileType, ((NormalizedFileSnapshot)previousEntry.getValue()).getSnapshot().getType());
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        for (NormalizedFileSnapshot normalizedSnapshot : snapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

