/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolationException;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetValueSnapshot
implements ValueSnapshot,
Isolatable<Set> {
    private final ImmutableSet<ValueSnapshot> elements;

    public SetValueSnapshot(ImmutableSet<ValueSnapshot> elements) {
        this.elements = elements;
    }

    public ImmutableSet<ValueSnapshot> getElements() {
        return this.elements;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString((CharSequence)"Set");
        hasher.putInt(this.elements.size());
        for (ValueSnapshot element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot newSnapshot = snapshotter.snapshot(value);
        if (this.isEqualSetValueSnapshot(newSnapshot)) {
            return this;
        }
        return newSnapshot;
    }

    private boolean isEqualSetValueSnapshot(ValueSnapshot newSnapshot) {
        if (newSnapshot instanceof SetValueSnapshot) {
            SetValueSnapshot other = (SetValueSnapshot)newSnapshot;
            if (this.elements.equals(other.elements)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetValueSnapshot other = (SetValueSnapshot)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public Set isolate() {
        LinkedHashSet set = new LinkedHashSet();
        for (ValueSnapshot snapshot : this.elements) {
            if (snapshot instanceof Isolatable) {
                set.add(((Isolatable)((Object)snapshot)).isolate());
                continue;
            }
            throw new IsolationException(snapshot);
        }
        return set;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        return null;
    }
}

