/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableActionSet<T>
implements Action<T> {
    private static final ImmutableActionSet<Object> EMPTY = new EmptySet<Object>();

    public static <T> ImmutableActionSet<T> empty() {
        return (ImmutableActionSet)Cast.uncheckedCast(EMPTY);
    }

    public static <T> ImmutableActionSet<T> of(Action<? super T> ... actions) {
        if (actions.length == 0) {
            return ImmutableActionSet.empty();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Action<? super T> action : actions) {
            if (action == Actions.DO_NOTHING || action instanceof EmptySet) continue;
            ImmutableActionSet.unpackAction(action, builder);
        }
        ImmutableSet set = builder.build();
        if (set.isEmpty()) {
            return ImmutableActionSet.empty();
        }
        if (set.size() == 1) {
            return new SingletonSet((Action)set.iterator().next());
        }
        return new CompositeSet(set);
    }

    private static <T> void unpackAction(Action<? super T> action, ImmutableSet.Builder<Action<? super T>> builder) {
        if (action instanceof SingletonSet) {
            SingletonSet singletonSet = (SingletonSet)action;
            builder.add((Object)singletonSet.singleAction);
        } else if (action instanceof CompositeSet) {
            CompositeSet compositeSet = (CompositeSet)action;
            builder.addAll((Iterable)compositeSet.multipleActions);
        } else {
            builder.add(action);
        }
    }

    public ImmutableActionSet<T> add(Action<? super T> action) {
        if (action == Actions.DO_NOTHING || action instanceof EmptySet || action == this) {
            return this;
        }
        if (action instanceof SingletonSet) {
            SingletonSet singletonSet = (SingletonSet)action;
            return this.doAdd(singletonSet.singleAction);
        }
        if (action instanceof CompositeSet) {
            CompositeSet compositeSet = (CompositeSet)action;
            return this.doAddAll(compositeSet);
        }
        return this.doAdd(action);
    }

    public abstract boolean isEmpty();

    abstract ImmutableActionSet<T> doAddAll(CompositeSet<T> var1);

    abstract ImmutableActionSet<T> doAdd(Action<? super T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeSet<T>
    extends ImmutableActionSet<T> {
        private final ImmutableSet<Action<? super T>> multipleActions;

        CompositeSet(ImmutableSet<Action<? super T>> multipleActions) {
            this.multipleActions = multipleActions;
        }

        @Override
        ImmutableActionSet<T> doAdd(Action<? super T> action) {
            if (this.multipleActions.contains(action)) {
                return this;
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(this.multipleActions);
            builder.add(action);
            return new CompositeSet<T>(builder.build());
        }

        @Override
        ImmutableActionSet<T> doAddAll(CompositeSet<T> source) {
            if (this.multipleActions.containsAll(source.multipleActions)) {
                return this;
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(this.multipleActions);
            builder.addAll(source.multipleActions);
            return new CompositeSet<T>(builder.build());
        }

        @Override
        public void execute(T t) {
            for (Action action : this.multipleActions) {
                action.execute(t);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonSet<T>
    extends ImmutableActionSet<T> {
        private final Action<? super T> singleAction;

        SingletonSet(Action<? super T> singleAction) {
            this.singleAction = singleAction;
        }

        @Override
        ImmutableActionSet<T> doAdd(Action<? super T> action) {
            if (action.equals(this.singleAction)) {
                return this;
            }
            ImmutableSet of = (ImmutableSet)Cast.uncheckedCast(ImmutableSet.of(this.singleAction, action));
            return new CompositeSet(of);
        }

        @Override
        ImmutableActionSet<T> doAddAll(CompositeSet<T> source) {
            if (((CompositeSet)source).multipleActions.contains(this.singleAction)) {
                return source;
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add(this.singleAction);
            builder.addAll((Iterable)((CompositeSet)source).multipleActions);
            return new CompositeSet(builder.build());
        }

        @Override
        public void execute(T t) {
            this.singleAction.execute(t);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySet<T>
    extends ImmutableActionSet<T> {
        private EmptySet() {
        }

        @Override
        ImmutableActionSet<T> doAdd(Action<? super T> action) {
            return new SingletonSet<T>(action);
        }

        @Override
        ImmutableActionSet<T> doAddAll(CompositeSet<T> source) {
            return source;
        }

        @Override
        public void execute(Object o) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

