/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.BuildIdentity;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final BuildIdentifier currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildTaskGraph includedBuildTaskGraph, BuildIdentity buildIdentity) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.currentBuild = buildIdentity.getCurrentBuild();
    }

    public void execute(Configuration classpath) {
        ArtifactCollection artifacts = classpath.getIncoming().getArtifacts();
        for (ResolvedArtifactResult artifactResult : artifacts.getArtifacts()) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifactResult.getId();
            this.build(this.currentBuild, componentArtifactIdentifier);
        }
    }

    private BuildIdentifier getBuildIdentifier(CompositeProjectComponentArtifactMetadata artifact) {
        return artifact.getComponentId().getBuild();
    }

    public void build(BuildIdentifier requestingBuild, ComponentArtifactIdentifier artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier targetBuild = this.getBuildIdentifier(compositeBuildArtifact);
            assert (!requestingBuild.equals(targetBuild));
            Set<String> tasks = compositeBuildArtifact.getTasks();
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.addTask(requestingBuild, targetBuild, taskName);
            }
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.awaitCompletion(targetBuild, taskName);
            }
        }
    }
}

