/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.AffectedClasses;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.internal.hash.HashCode;

public class JarSnapshot {
    private final JarSnapshotData data;

    public JarSnapshot(JarSnapshotData data) {
        this.data = data;
    }

    public DependentsSet getAllClasses() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, HashCode> cls : this.getHashes().entrySet()) {
            String className = cls.getKey();
            if (this.getAnalysis().isDependencyToAll(className)) {
                return DependentsSet.dependencyToAll();
            }
            result.add(className);
        }
        return DependentsSet.dependents(result);
    }

    public IntSet getAllConstants(DependentsSet dependents) {
        IntOpenHashSet result = new IntOpenHashSet();
        for (String cn : dependents.getDependentClasses()) {
            result.addAll((IntCollection)this.data.data.getConstants(cn));
        }
        return result;
    }

    public IntSet getRelevantConstants(JarSnapshot other, Set<String> affectedClasses) {
        IntOpenHashSet result = new IntOpenHashSet();
        for (String affectedClass : affectedClasses) {
            IntOpenHashSet difference = new IntOpenHashSet((IntCollection)other.getData().data.getConstants(affectedClass));
            difference.removeAll((IntCollection)this.data.data.getConstants(affectedClass));
            result.addAll((IntCollection)difference);
        }
        return result;
    }

    public AffectedClasses getAffectedClassesSince(JarSnapshot other) {
        DependentsSet affectedClasses = this.affectedSince(other);
        Set<String> addedClasses = this.addedSince(other);
        return new AffectedClasses(affectedClasses, addedClasses);
    }

    private DependentsSet affectedSince(JarSnapshot other) {
        HashSet<String> affected = new HashSet<String>();
        for (Map.Entry<String, HashCode> otherClass : other.getHashes().entrySet()) {
            String otherClassName = otherClass.getKey();
            HashCode otherClassBytes = otherClass.getValue();
            HashCode thisClsBytes = this.getHashes().get(otherClassName);
            if (thisClsBytes != null && thisClsBytes.equals((Object)otherClassBytes)) continue;
            affected.add(otherClassName);
            DependentsSet dependents = other.getAnalysis().getRelevantDependents(otherClassName, (IntSet)IntSets.EMPTY_SET);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            affected.addAll(dependents.getDependentClasses());
        }
        return DependentsSet.dependents(affected);
    }

    private Set<String> addedSince(JarSnapshot other) {
        HashSet<String> addedClasses = new HashSet<String>(this.getClasses());
        addedClasses.removeAll(other.getClasses());
        return addedClasses;
    }

    public HashCode getHash() {
        return this.data.hash;
    }

    public Map<String, HashCode> getHashes() {
        return this.data.hashes;
    }

    public ClassSetAnalysis getAnalysis() {
        return new ClassSetAnalysis(this.data.data);
    }

    public Set<String> getClasses() {
        return this.data.hashes.keySet();
    }

    public JarSnapshotData getData() {
        return this.data;
    }
}

