/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String methodName;
    private final String methodParameterTypes;

    public static MethodSource from(String className, String methodName) {
        return new MethodSource(className, methodName);
    }

    public static MethodSource from(String className, String methodName, String methodParameterTypes) {
        return new MethodSource(className, methodName, methodParameterTypes);
    }

    public static MethodSource from(Method method) {
        return new MethodSource(method);
    }

    private MethodSource(String className, String methodName) {
        this(className, methodName, null);
    }

    private MethodSource(String className, String methodName, String methodParameterTypes) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    private MethodSource(Method method) {
        Preconditions.notNull((Object)method, (String)"method must not be null");
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.methodParameterTypes = ClassUtils.nullSafeToString((Class[])method.getParameterTypes());
    }

    public String getClassName() {
        return this.className;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSource that = (MethodSource)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodParameterTypes, that.methodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("methodName", (Object)this.methodName).append("methodParameterTypes", (Object)this.methodParameterTypes).toString();
    }
}

