/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.VectorSet;
import org.apache.tools.zip.ZipLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntClassLoader
extends ClassLoader
implements SubBuildListener,
Closeable {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int BUFFER_SIZE = 8192;
    private static final int NUMBER_OF_STRINGS = 256;
    private final Vector<File> pathComponents = new VectorSet<File>();
    private Project project;
    private boolean parentFirst = true;
    private final Vector<String> systemPackages = new Vector();
    private final Vector<String> loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable<File, JarFile> jarFiles = new Hashtable();
    private static Map<String, String> pathMap = Collections.synchronizedMap(new HashMap());
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong SINGLE_SEGMENT_SPLIT_MARKER = new ZipLong(808471376L);

    public AntClassLoader(ClassLoader parent, Project project, Path classpath) {
        this.setParent(parent);
        this.setClassPath(classpath);
        this.setProject(project);
    }

    public AntClassLoader() {
        this.setParent(null);
    }

    public AntClassLoader(Project project, Path classpath) {
        this.setParent(null);
        this.setProject(project);
        this.setClassPath(classpath);
    }

    public AntClassLoader(ClassLoader parent, Project project, Path classpath, boolean parentFirst) {
        this(project, classpath);
        if (parent != null) {
            this.setParent(parent);
        }
        this.setParentFirst(parentFirst);
        this.addJavaLibraries();
    }

    public AntClassLoader(Project project, Path classpath, boolean parentFirst) {
        this(null, project, classpath, parentFirst);
    }

    public AntClassLoader(ClassLoader parent, boolean parentFirst) {
        this.setParent(parent);
        this.project = null;
        this.parentFirst = parentFirst;
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener(this);
        }
    }

    public void setClassPath(Path classpath) {
        this.pathComponents.removeAllElements();
        if (classpath != null) {
            Path actualClasspath = classpath.concatSystemClasspath("ignore");
            String[] pathElements = actualClasspath.list();
            for (int i = 0; i < pathElements.length; ++i) {
                try {
                    this.addPathElement(pathElements[i]);
                    continue;
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
        }
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent == null ? AntClassLoader.class.getClassLoader() : parent;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    protected void log(String message, int priority) {
        if (this.project != null) {
            this.project.log(message, priority);
        } else if (priority < 2) {
            System.err.println(message);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (LoaderUtils.isContextLoaderAvailable()) {
            this.savedContextLoader = LoaderUtils.getContextClassLoader();
            ClassLoader loader = this;
            if (this.project != null && "only".equals(this.project.getProperty("build.sysclasspath"))) {
                loader = this.getClass().getClassLoader();
            }
            LoaderUtils.setContextClassLoader(loader);
            this.isContextLoaderSaved = true;
        }
    }

    public void resetThreadContextLoader() {
        if (LoaderUtils.isContextLoaderAvailable() && this.isContextLoaderSaved) {
            LoaderUtils.setContextClassLoader(this.savedContextLoader);
            this.savedContextLoader = null;
            this.isContextLoaderSaved = false;
        }
    }

    public void addPathElement(String pathElement) throws BuildException {
        File pathComponent = this.project != null ? this.project.resolveFile(pathElement) : new File(pathElement);
        try {
            this.addPathFile(pathComponent);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    public void addPathComponent(File file) {
        if (this.pathComponents.contains(file)) {
            return;
        }
        this.pathComponents.addElement(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPathFile(File pathComponent) throws IOException {
        if (!this.pathComponents.contains(pathComponent)) {
            this.pathComponents.addElement(pathComponent);
        }
        if (pathComponent.isDirectory()) {
            return;
        }
        String absPathPlusTimeAndLength = pathComponent.getAbsolutePath() + pathComponent.lastModified() + "-" + pathComponent.length();
        String classpath = pathMap.get(absPathPlusTimeAndLength);
        if (classpath == null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(pathComponent);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                classpath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            if (classpath == null) {
                classpath = "";
            }
            pathMap.put(absPathPlusTimeAndLength, classpath);
        }
        if (!"".equals(classpath)) {
            URL baseURL = FILE_UTILS.getFileURL(pathComponent);
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String classpathElement = st.nextToken();
                URL libraryURL = new URL(baseURL, classpathElement);
                if (!libraryURL.getProtocol().equals("file")) {
                    this.log("Skipping jar library " + classpathElement + " since only relative URLs are supported by this" + " loader", 3);
                    continue;
                }
                String decodedPath = Locator.decodeUri((String)libraryURL.getFile());
                File libraryFile = new File(decodedPath);
                if (!libraryFile.exists() || this.isInPath(libraryFile)) continue;
                this.addPathFile(libraryFile);
            }
        }
    }

    public String getClasspath() {
        StringBuilder sb = new StringBuilder();
        boolean firstPass = true;
        Enumeration<File> componentEnum = this.pathComponents.elements();
        while (componentEnum.hasMoreElements()) {
            if (!firstPass) {
                sb.append(System.getProperty("path.separator"));
            } else {
                firstPass = false;
            }
            sb.append(componentEnum.nextElement().getAbsolutePath());
        }
        return sb.toString();
    }

    public synchronized void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    @Deprecated
    public static void initializeClass(Class<?> theClass) {
        Constructor<?>[] cons = theClass.getDeclaredConstructors();
        if (cons != null && cons.length > 0 && cons[0] != null) {
            String[] strs = new String[256];
            try {
                cons[0].newInstance(strs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public Class<?> forceLoadClass(String classname) throws ClassNotFoundException {
        this.log("force loading " + classname, 4);
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    public Class<?> forceLoadSystemClass(String classname) throws ClassNotFoundException {
        this.log("force system loading " + classname, 4);
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findBaseClass(classname);
        }
        return theClass;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream = null;
        if (this.isParentFirst(name)) {
            resourceStream = this.loadBaseResource(name);
        }
        if (resourceStream != null) {
            this.log("ResourceStream for " + name + " loaded from parent loader", 4);
        } else {
            resourceStream = this.loadResource(name);
            if (resourceStream != null) {
                this.log("ResourceStream for " + name + " loaded from ant loader", 4);
            }
        }
        if (resourceStream == null && !this.isParentFirst(name) && (resourceStream = this.ignoreBase ? (this.getRootLoader() == null ? null : this.getRootLoader().getResourceAsStream(name)) : this.loadBaseResource(name)) != null) {
            this.log("ResourceStream for " + name + " loaded from parent loader", 4);
        }
        if (resourceStream == null) {
            this.log("Couldn't load ResourceStream for " + name, 4);
        }
        return resourceStream;
    }

    private InputStream loadResource(String name) {
        InputStream stream = null;
        Enumeration<File> e = this.pathComponents.elements();
        while (e.hasMoreElements() && stream == null) {
            File pathComponent = e.nextElement();
            stream = this.getResourceStream(pathComponent, name);
        }
        return stream;
    }

    private InputStream loadBaseResource(String name) {
        return this.parent == null ? super.getResourceAsStream(name) : this.parent.getResourceAsStream(name);
    }

    private InputStream getResourceStream(File file, String resourceName) {
        try {
            JarFile jarFile = this.jarFiles.get(file);
            if (jarFile == null && file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    return new FileInputStream(resource);
                }
            } else {
                JarEntry entry;
                if (jarFile == null) {
                    if (!file.exists()) {
                        return null;
                    }
                    jarFile = new JarFile(file);
                    this.jarFiles.put(file, jarFile);
                    jarFile = this.jarFiles.get(file);
                }
                if ((entry = jarFile.getJarEntry(resourceName)) != null) {
                    return jarFile.getInputStream(entry);
                }
            }
        }
        catch (Exception e) {
            this.log("Ignoring Exception " + e.getClass().getName() + ": " + e.getMessage() + " reading resource " + resourceName + " from " + file, 3);
        }
        return null;
    }

    private boolean isParentFirst(String resourceName) {
        String packageName;
        boolean useParentFirst = this.parentFirst;
        Enumeration<String> e = this.systemPackages.elements();
        while (e.hasMoreElements()) {
            packageName = e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        e = this.loaderPackages.elements();
        while (e.hasMoreElements()) {
            packageName = e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    private ClassLoader getRootLoader() {
        ClassLoader ret;
        for (ret = this.getClass().getClassLoader(); ret != null && ret.getParent() != null; ret = ret.getParent()) {
        }
        return ret;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
        }
        if (url != null) {
            this.log("Resource " + name + " loaded from parent loader", 4);
        } else {
            Enumeration<File> e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                this.log("Resource " + name + " loaded from ant loader", 4);
            }
        }
        if (url == null && !this.isParentFirst(name)) {
            if (this.ignoreBase) {
                url = this.getRootLoader() == null ? null : this.getRootLoader().getResource(name);
            } else {
                URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
            }
            if (url != null) {
                this.log("Resource " + name + " loaded from parent loader", 4);
            }
        }
        if (url == null) {
            this.log("Couldn't load Resource " + name, 4);
        }
        return url;
    }

    public Enumeration<URL> getNamedResources(String name) throws IOException {
        return this.findResources(name, false);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.findResources(name, true);
    }

    protected Enumeration<URL> findResources(String name, boolean parentHasBeenSearched) throws IOException {
        ResourceEnumeration mine = new ResourceEnumeration(name);
        Enumeration<Object> base = this.parent != null && (!parentHasBeenSearched || this.parent != this.getParent()) ? this.parent.getResources(name) : new CollectionUtils.EmptyEnumeration();
        if (this.isParentFirst(name)) {
            return CollectionUtils.append(base, mine);
        }
        if (this.ignoreBase) {
            return this.getRootLoader() == null ? mine : CollectionUtils.append(mine, this.getRootLoader().getResources(name));
        }
        return CollectionUtils.append(mine, base);
    }

    protected URL getResourceURL(File file, String resourceName) {
        try {
            JarFile jarFile = this.jarFiles.get(file);
            if (jarFile == null && file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    try {
                        return FILE_UTILS.getFileURL(resource);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            } else {
                JarEntry entry;
                if (jarFile == null) {
                    if (file.exists()) {
                        if (!AntClassLoader.isZip(file)) {
                            String msg = "CLASSPATH element " + file + " is not a JAR.";
                            this.log(msg, 1);
                            return null;
                        }
                    } else {
                        return null;
                    }
                    jarFile = new JarFile(file);
                    this.jarFiles.put(file, jarFile);
                    jarFile = this.jarFiles.get(file);
                }
                if ((entry = jarFile.getJarEntry(resourceName)) != null) {
                    try {
                        return new URL("jar:" + FILE_UTILS.getFileURL(file) + "!/" + entry);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Unable to obtain resource from " + file + ": ";
            this.log(msg + e, 1);
            this.log(StringUtils.getStackTrace(e), 1);
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass != null) {
            return theClass;
        }
        if (this.isParentFirst(classname)) {
            try {
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader " + "(parentFirst)", 4);
            }
            catch (ClassNotFoundException cnfe) {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader " + "(parentFirst)", 4);
            }
        } else {
            try {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreBase) {
                    throw cnfe;
                }
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader", 4);
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    private String getClassFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    protected Class<?> defineClassFromData(File container, byte[] classData, String classname) throws IOException {
        this.definePackage(container, classname);
        ProtectionDomain currentPd = Project.class.getProtectionDomain();
        String classResource = this.getClassFilename(classname);
        CodeSource src = new CodeSource(FILE_UTILS.getFileURL(container), this.getCertificates(container, classResource));
        ProtectionDomain classesPd = new ProtectionDomain(src, currentPd.getPermissions(), this, currentPd.getPrincipals());
        return this.defineClass(classname, classData, 0, classData.length, classesPd);
    }

    protected void definePackage(File container, String className) throws IOException {
        int classIndex = className.lastIndexOf(46);
        if (classIndex == -1) {
            return;
        }
        String packageName = className.substring(0, classIndex);
        if (this.getPackage(packageName) != null) {
            return;
        }
        Manifest manifest = this.getJarManifest(container);
        if (manifest == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        } else {
            this.definePackage(container, packageName, manifest);
        }
    }

    private Manifest getJarManifest(File container) throws IOException {
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = this.jarFiles.get(container);
        if (jarFile == null) {
            return null;
        }
        return jarFile.getManifest();
    }

    private Certificate[] getCertificates(File container, String entry) {
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = this.jarFiles.get(container);
        if (jarFile == null) {
            return null;
        }
        JarEntry ent = jarFile.getJarEntry(entry);
        return ent == null ? null : ent.getCertificates();
    }

    protected void definePackage(File container, String packageName, Manifest manifest) {
        Attributes mainAttributes;
        String sectionName = packageName.replace('.', '/') + "/";
        String specificationTitle = null;
        String specificationVendor = null;
        String specificationVersion = null;
        String implementationTitle = null;
        String implementationVendor = null;
        String implementationVersion = null;
        String sealedString = null;
        URL sealBase = null;
        Attributes sectionAttributes = manifest.getAttributes(sectionName);
        if (sectionAttributes != null) {
            specificationTitle = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specificationVendor = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            specificationVersion = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implementationTitle = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implementationVendor = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            implementationVersion = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            sealedString = sectionAttributes.getValue(Attributes.Name.SEALED);
        }
        if ((mainAttributes = manifest.getMainAttributes()) != null) {
            if (specificationTitle == null) {
                specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specificationVendor == null) {
                specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (specificationVersion == null) {
                specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (implementationTitle == null) {
                implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implementationVendor == null) {
                implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (implementationVersion == null) {
                implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (sealedString == null) {
                sealedString = mainAttributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealedString != null && sealedString.equalsIgnoreCase("true")) {
            try {
                sealBase = new URL(FileUtils.getFileUtils().toURI(container.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
    }

    private Class<?> getClassFromStream(InputStream stream, String classname, File container) throws IOException, SecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = -1;
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClassFromData(container, classData, classname);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        this.log("Finding class " + name, 4);
        return this.findClassInComponents(name);
    }

    protected boolean isInPath(File component) {
        return this.pathComponents.contains(component);
    }

    /*
     * Exception decompiling
     */
    private Class<?> findClassInComponents(String name) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Class<?> findBaseClass(String name) throws ClassNotFoundException {
        return this.parent == null ? this.findSystemClass(name) : this.parent.loadClass(name);
    }

    public synchronized void cleanup() {
        Enumeration<JarFile> e = this.jarFiles.elements();
        while (e.hasMoreElements()) {
            JarFile jarFile = e.nextElement();
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        this.jarFiles = new Hashtable();
        if (this.project != null) {
            this.project.removeBuildListener(this);
        }
        this.project = null;
    }

    public ClassLoader getConfiguredParent() {
        return this.parent;
    }

    @Override
    public void buildStarted(BuildEvent event) {
    }

    @Override
    public void buildFinished(BuildEvent event) {
        this.cleanup();
    }

    @Override
    public void subBuildFinished(BuildEvent event) {
        if (event.getProject() == this.project) {
            this.cleanup();
        }
    }

    @Override
    public void subBuildStarted(BuildEvent event) {
    }

    @Override
    public void targetStarted(BuildEvent event) {
    }

    @Override
    public void targetFinished(BuildEvent event) {
    }

    @Override
    public void taskStarted(BuildEvent event) {
    }

    @Override
    public void taskFinished(BuildEvent event) {
    }

    @Override
    public void messageLogged(BuildEvent event) {
    }

    public void addJavaLibraries() {
        Vector<String> packages = JavaEnvUtils.getJrePackages();
        Enumeration<String> e = packages.elements();
        while (e.hasMoreElements()) {
            String packageName = e.nextElement();
            this.addSystemPackageRoot(packageName);
        }
    }

    public String toString() {
        return "AntClassLoader[" + this.getClasspath() + "]";
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getNamedResources(name);
    }

    @Override
    public void close() {
        this.cleanup();
    }

    public static AntClassLoader newAntClassLoader(ClassLoader parent, Project project, Path path, boolean parentFirst) {
        return new AntClassLoader(parent, project, path, parentFirst);
    }

    private static boolean isZip(File file) throws IOException {
        byte[] sig = new byte[4];
        if (AntClassLoader.readFully(file, sig)) {
            ZipLong start = new ZipLong(sig);
            return ZipLong.LFH_SIG.equals(start) || EOCD_SIG.equals(start) || ZipLong.DD_SIG.equals(start) || SINGLE_SEGMENT_SPLIT_MARKER.equals(start);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readFully(File f, byte[] b) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        try {
            int count;
            int len = b.length;
            int x = 0;
            for (count = 0; count != len && (x = fis.read(b, count, len - count)) != -1; count += x) {
            }
            boolean bl = count == len;
            return bl;
        }
        finally {
            fis.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceEnumeration
    implements Enumeration<URL> {
        private final String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String name) {
            this.resourceName = name;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        @Override
        public URL nextElement() {
            URL ret = this.nextResource;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.findNextResource();
            return ret;
        }

        private void findNextResource() {
            URL url = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && url == null) {
                try {
                    File pathComponent = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    url = AntClassLoader.this.getResourceURL(pathComponent, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {}
            }
            this.nextResource = url;
        }
    }
}

