/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.net.URI;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.wagon.Wagon;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.publication.maven.internal.action.MavenDeployAction;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.wagon.RepositoryTransportDeployWagon;
import org.gradle.api.publication.maven.internal.wagon.RepositoryTransportWagonAdapter;
import org.gradle.api.publish.maven.internal.publisher.AbstractMavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.logging.LoggingManagerInternal;

public class MavenRemotePublisher
extends AbstractMavenPublisher {
    private final Factory<File> temporaryDirFactory;
    private final RepositoryTransportFactory repositoryTransportFactory;

    public MavenRemotePublisher(Factory<LoggingManagerInternal> loggingManagerFactory, LocalMavenRepositoryLocator mavenRepositoryLocator, Factory<File> temporaryDirFactory, RepositoryTransportFactory repositoryTransportFactory) {
        super(loggingManagerFactory, mavenRepositoryLocator);
        this.temporaryDirFactory = temporaryDirFactory;
        this.repositoryTransportFactory = repositoryTransportFactory;
    }

    @Override
    protected MavenPublishAction createDeployTask(File pomFile, File metadataFile, LocalMavenRepositoryLocator mavenRepositoryLocator, MavenArtifactRepository artifactRepository) {
        GradleWagonMavenDeployAction deployTask = new GradleWagonMavenDeployAction(pomFile, metadataFile, artifactRepository, this.repositoryTransportFactory);
        deployTask.setLocalMavenRepositoryLocation((File)this.temporaryDirFactory.create());
        deployTask.setRepositories(this.createMavenRemoteRepository(artifactRepository), null);
        return deployTask;
    }

    private RemoteRepository createMavenRemoteRepository(MavenArtifactRepository repository) {
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setUrl(repository.getUrl().toString());
        return remoteRepository;
    }

    private static class GradleWagonMavenDeployAction
    extends MavenDeployAction {
        private final MavenArtifactRepository artifactRepository;
        private final RepositoryTransportFactory repositoryTransportFactory;

        public GradleWagonMavenDeployAction(File pomFile, File metadataFile, MavenArtifactRepository artifactRepository, RepositoryTransportFactory repositoryTransportFactory) {
            super(pomFile, metadataFile, null);
            this.artifactRepository = artifactRepository;
            this.repositoryTransportFactory = repositoryTransportFactory;
            this.registerWagonProtocols();
        }

        private void registerWagonProtocols() {
            RepositoryTransportDeployWagon wagon = new RepositoryTransportDeployWagon();
            for (String protocol : this.repositoryTransportFactory.getRegisteredProtocols()) {
                this.getContainer().addComponent((Object)wagon, Wagon.class, protocol);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish() {
            String protocol = this.artifactRepository.getUrl().getScheme().toLowerCase();
            RepositoryTransportWagonAdapter adapter = this.createAdapter(protocol, this.artifactRepository, this.repositoryTransportFactory);
            RepositoryTransportDeployWagon.contextualize(adapter);
            try {
                super.publish();
            }
            finally {
                RepositoryTransportDeployWagon.decontextualize();
            }
        }

        private RepositoryTransportWagonAdapter createAdapter(String protocol, MavenArtifactRepository artifactRepository, RepositoryTransportFactory repositoryTransportFactory) {
            RepositoryTransport transport = repositoryTransportFactory.createTransport(protocol, artifactRepository.getName(), ((AuthenticationSupportedInternal)artifactRepository).getConfiguredAuthentication());
            URI rootUri = artifactRepository.getUrl();
            return new RepositoryTransportWagonAdapter(transport, rootUri);
        }
    }
}

