/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.gradle.internal.resource.UriTextResource;

public class DownloadedUriTextResource
extends UriTextResource {
    private final String contentType;
    private final File downloadedResource;

    public DownloadedUriTextResource(String description, URI sourceUri, String contentType, File downloadedResource) {
        super(description, sourceUri);
        this.contentType = contentType;
        this.downloadedResource = downloadedResource;
    }

    protected Reader openReader() throws IOException {
        String charset = DownloadedUriTextResource.extractCharacterEncoding(this.contentType, "utf-8");
        FileInputStream inputStream = new FileInputStream(this.downloadedResource);
        return new InputStreamReader((InputStream)inputStream, charset);
    }
}

