/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Intrinsic", "js.translator"})
public final class ThrowableConstructorIntrinsicFactory
implements FunctionIntrinsicFactory {
    public static final ThrowableConstructorIntrinsicFactory INSTANCE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof ConstructorDescriptor)) {
            return null;
        }
        ClassDescriptor classDescriptor = ((ConstructorDescriptor)descriptor2).getConstructedClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"descriptor.constructedClass");
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"descriptor.constructedClass.defaultType");
        if (!TypeUtilsKt.isNotNullThrowable(simpleType2)) {
            return null;
        }
        return Intrinsic.INSTANCE;
    }

    private ThrowableConstructorIntrinsicFactory() {
    }

    static {
        ThrowableConstructorIntrinsicFactory throwableConstructorIntrinsicFactory;
        INSTANCE = throwableConstructorIntrinsicFactory = new ThrowableConstructorIntrinsicFactory();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory$Intrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    public static final class Intrinsic
    extends FunctionIntrinsic {
        public static final Intrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            boolean hasCauseParameter;
            List argumentsToPass;
            CallableDescriptor constructor;
            block4: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
                Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                constructor = callInfo.getResolvedCall().getResultingDescriptor();
                argumentsToPass = CollectionsKt.toMutableList((Collection)arguments2);
                List<ValueParameterDescriptor> list2 = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constructor.valueParameters");
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ValueParameterDescriptor it;
                        ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                        ClassifierDescriptor classifierDescriptor = valueParameterDescriptor.getType().getConstructor().getDeclarationDescriptor();
                        if (!Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null), (Object)KotlinBuiltIns.FQ_NAMES.throwable)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = hasCauseParameter = false;
                }
            }
            if (constructor.getValueParameters().size() == 1 && hasCauseParameter) {
                JsExpression jsExpression = Namer.getUndefinedExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"Namer.getUndefinedExpression()");
                argumentsToPass.add(0, jsExpression);
            }
            return new JsInvocation((JsExpression)JsAstUtils.pureFqn("newThrowable", (JsExpression)Namer.kotlinObject()), argumentsToPass);
        }

        private Intrinsic() {
        }

        static {
            Intrinsic intrinsic;
            INSTANCE = intrinsic = new Intrinsic();
        }
    }
}

