/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.BinaryModuleData;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingKt;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.jvm.JvmModuleProtoBuf;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B+\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0004J\b\u0010\u0010\u001a\u00020\u0004H\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "moduleData", "Lorg/jetbrains/kotlin/load/kotlin/BinaryModuleData;", "debugName", "(Ljava/util/Map;Lorg/jetbrains/kotlin/load/kotlin/BinaryModuleData;Ljava/lang/String;)V", "getModuleData", "()Lorg/jetbrains/kotlin/load/kotlin/BinaryModuleData;", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "toString", "Companion", "descriptors.jvm"})
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull BinaryModuleData moduleData, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, moduleData, debugName);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "create", "bytes", "", "debugName", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "descriptors.jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream2.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_15 = i$iv;
                    void var23_18 = i$iv++;
                    object = result$iv;
                    object[var23_18] = n3 = stream2.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable $receiver$iv2;
                Object packageParts;
                JvmModuleProtoBuf.Module module2 = JvmModuleProtoBuf.Module.parseFrom(stream2);
                if (module2 == null) {
                    return EMPTY;
                }
                JvmModuleProtoBuf.Module moduleProto = module2;
                LinkedHashMap result2 = new LinkedHashMap();
                Iterator<JvmModuleProtoBuf.PackageParts> it = moduleProto.getPackagePartsList().iterator();
                while (it.hasNext()) {
                    int index2;
                    Object object2;
                    String key$iv;
                    void $receiver$iv222;
                    JvmModuleProtoBuf.PackageParts proto;
                    JvmModuleProtoBuf.PackageParts packageParts2 = proto = it.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageParts2, (String)"proto");
                    String packageFqName = packageParts2.getPackageFqName();
                    Map map2 = result2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageFqName, (String)"packageFqName");
                    Object value$iv = $receiver$iv222.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv222.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    packageParts = (PackageParts)object2;
                    boolean $receiver$iv222 = false;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                    for (String partShortName : (Iterable)protocolStringList) {
                        String string;
                        String facadeShortName;
                        String string2;
                        ProtocolStringList protocolStringList2;
                        Integer multifileFacadeId;
                        List<Integer> list2 = proto.getMultifileFacadeShortNameIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.multifileFacadeShortNameIdList");
                        Integer n = (Integer)CollectionsKt.getOrNull(list2, (int)index2);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            Intrinsics.checkExpressionValueIsNotNull((Object)proto.getMultifileFacadeShortNameList(), (String)"proto.multifileFacadeShortNameList");
                            int p1 = ((Number)n5).intValue();
                            string2 = (String)CollectionsKt.getOrNull((List)protocolStringList2, (int)p1);
                        } else {
                            string2 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it2 = protocolStringList2;
                            string = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it2));
                        } else {
                            string = null;
                        }
                        String facadeInternalName = string;
                        String string3 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string3), facadeInternalName);
                        ++index2;
                    }
                    if (!configuration.isJvmPackageNameSupported()) continue;
                    index2 = 0;
                    ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList3, (String)"proto.classWithJvmPackageNameShortNameList");
                    for (String partShortName : (Iterable)protocolStringList3) {
                        List<Integer> list3 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"proto.classWithJvmPackageNamePackageIdList");
                        Integer n = (Integer)CollectionsKt.getOrNull(list3, (int)index2);
                        if (n == null) {
                            List<Integer> list4 = proto.getClassWithJvmPackageNamePackageIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"proto.classWithJvmPackageNamePackageIdList");
                            n = (Integer)CollectionsKt.lastOrNull(list4);
                        }
                        if (n == null) {
                        } else {
                            int packageId = n;
                            ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList4, (String)"moduleProto.jvmPackageNameList");
                            if ((String)CollectionsKt.getOrNull((List)protocolStringList4, (int)packageId) == null) {
                            } else {
                                String jvmPackageName;
                                String string = partShortName;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"partShortName");
                                ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string), null);
                            }
                        }
                        ++index2;
                    }
                }
                for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                    Object object3;
                    packageParts = result2;
                    JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3, (String)"proto");
                    String string = packageParts3.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                    String key$iv = string;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        String string4 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string4);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    PackageParts packageParts4 = (PackageParts)object3;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                    $receiver$iv2 = protocolStringList;
                    for (Object element$iv : $receiver$iv2) {
                        String p1 = (String)element$iv;
                        packageParts4.addMetadataPart(p1);
                    }
                }
                ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"moduleProto.stringTable");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"moduleProto.qualifiedNameTable");
                NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
                List<ProtoBuf.Annotation> list5 = moduleProto.getAnnotationList();
                Intrinsics.checkExpressionValueIsNotNull(list5, (String)"moduleProto.annotationList");
                $receiver$iv2 = $receiver$iv = (Iterable)list5;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void proto;
                    ProtoBuf.Annotation $i$a$1$unknown = (ProtoBuf.Annotation)item$iv$iv;
                    object = destination$iv$iv;
                    void v24 = proto;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"proto");
                    ClassId classId = nameResolver.getClassId(v24.getId());
                    object.add(classId);
                }
                List annotations2 = (List)destination$iv$iv;
                return new ModuleMapping(result2, new BinaryModuleData(annotations2), debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

