/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTWrapperPsiElement;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "Lorg/jetbrains/kotlin/com/intellij/lang/ParserDefinition;", "()V", "createElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "astNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "createFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "fileViewProvider", "Lorg/jetbrains/kotlin/com/intellij/psi/FileViewProvider;", "createLexer", "Lorg/jetbrains/kotlin/com/intellij/lexer/Lexer;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "createParser", "Lorg/jetbrains/kotlin/com/intellij/lang/PsiParser;", "getCommentTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "getFileNodeType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "spaceExistanceTypeBetweenTokens", "Lorg/jetbrains/kotlin/com/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "Companion", "frontend"})
public final class KotlinParserDefinition
implements ParserDefinition {
    @JvmField
    @NotNull
    public static final String STD_SCRIPT_SUFFIX = "kts";
    @JvmField
    @NotNull
    public static final String STD_SCRIPT_EXT = ".kts";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new KotlinLexer();
    }

    @Override
    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new KotlinParser(project);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        KtFileElementType ktFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFileElementType, (String)"KtStubElementTypes.FILE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = KtTokens.WHITESPACES;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.WHITESPACES");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = KtTokens.COMMENTS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.COMMENTS");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = KtTokens.STRINGS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.STRINGS");
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode astNode) {
        PsiElement psiElement;
        IElementType elementType;
        Intrinsics.checkParameterIsNotNull((Object)astNode, (String)"astNode");
        IElementType iElementType = elementType = astNode.getElementType();
        if (iElementType instanceof KtStubElementType) {
            Object PsiT = ((KtStubElementType)elementType).createPsiFromAst(astNode);
            Intrinsics.checkExpressionValueIsNotNull(PsiT, (String)"elementType.createPsiFromAst(astNode)");
            psiElement = (PsiElement)PsiT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_CODE_FRAGMENT) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK_CODE_FRAGMENT)) {
            psiElement = new ASTWrapperPsiElement(astNode);
        } else if (iElementType instanceof KDocElementType) {
            PsiElement psiElement2 = ((KDocElementType)elementType).createPsi(astNode);
            psiElement = psiElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elementType.createPsi(astNode)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KDocTokens.MARKDOWN_LINK)) {
            psiElement = new KDocLink(astNode);
        } else {
            IElementType iElementType2 = elementType;
            if (iElementType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.KtNodeType");
            }
            KtElement ktElement = ((KtNodeType)iElementType2).createPsi(astNode);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"(elementType as KtNodeType).createPsi(astNode)");
            psiElement = ktElement;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkParameterIsNotNull((Object)fileViewProvider, (String)"fileViewProvider");
        return new KtFile(fileViewProvider, false);
    }

    @Override
    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        IElementType rightTokenType = right.getElementType();
        if (Intrinsics.areEqual((Object)rightTokenType, (Object)KtTokens.GET_KEYWORD) || Intrinsics.areEqual((Object)rightTokenType, (Object)KtTokens.SET_KEYWORD)) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        IElementType leftTokenType = left.getElementType();
        if (leftTokenType instanceof KtKeywordToken && rightTokenType instanceof KtKeywordToken) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        PsiElement psiElement = right.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"right.psi");
        PsiElement $receiver$iv = psiElement;
        KtWhenEntry rightWhenEntry = PsiTreeUtil.getParentOfType($receiver$iv, KtWhenEntry.class, false);
        if (rightWhenEntry != null) {
            PsiElement psiElement2 = left.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"left.psi");
            PsiElement $receiver$iv2 = psiElement2;
            KtWhenEntry leftWhenEntry = PsiTreeUtil.getParentOfType($receiver$iv2, KtWhenEntry.class, false);
            if (leftWhenEntry != null && Intrinsics.areEqual((Object)leftWhenEntry, (Object)rightWhenEntry) ^ true && Intrinsics.areEqual((Object)leftTokenType, (Object)KtTokens.SEMICOLON) ^ true) {
                return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            }
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    static {
        STD_SCRIPT_SUFFIX = STD_SCRIPT_SUFFIX;
        STD_SCRIPT_EXT = "." + STD_SCRIPT_SUFFIX;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition$Companion;", "", "()V", "STD_SCRIPT_EXT", "", "STD_SCRIPT_SUFFIX", "instance", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "getInstance", "()Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "frontend"})
    public static final class Companion {
        @NotNull
        public final KotlinParserDefinition getInstance() {
            Object t = LanguageParserDefinitions.INSTANCE.forLanguage(KotlinLanguage.INSTANCE);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.parsing.KotlinParserDefinition");
            }
            return (KotlinParserDefinition)t;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

