// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Endpoint.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Endpoint_h__
#define __Ice_Endpoint_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/Version.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/EndpointF.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class EndpointInfo;
class Endpoint;
class IPEndpointInfo;
class TCPEndpointInfo;
class UDPEndpointInfo;
class WSEndpointInfo;
class OpaqueEndpointInfo;

}

namespace Ice
{

constexpr short TCPEndpointType = 1;

constexpr short SSLEndpointType = 2;

constexpr short UDPEndpointType = 3;

constexpr short WSEndpointType = 4;

constexpr short WSSEndpointType = 5;

constexpr short BTEndpointType = 6;

constexpr short BTSEndpointType = 7;

constexpr short iAPEndpointType = 8;

constexpr short iAPSEndpointType = 9;

}

namespace Ice
{

class ICE_CLASS(ICE_API) EndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~EndpointInfo();

    EndpointInfo() = default;

    EndpointInfo(const EndpointInfo&) = default;
    EndpointInfo(EndpointInfo&&) = default;
    EndpointInfo& operator=(const EndpointInfo&) = default;
    EndpointInfo& operator=(EndpointInfo&&) = default;

    EndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress) :
        underlying(::std::move(iceP_underlying)),
        timeout(iceP_timeout),
        compress(iceP_compress)
    {
    }

    virtual short type() const = 0;

    virtual bool datagram() const = 0;

    virtual bool secure() const = 0;

    ::std::shared_ptr<::Ice::EndpointInfo> underlying;
    int timeout;
    bool compress;
};

class ICE_CLASS(ICE_API) Endpoint
{
public:

    ICE_MEMBER(ICE_API) virtual ~Endpoint();

    virtual bool operator==(const Endpoint&) const = 0;
    virtual bool operator<(const Endpoint&) const = 0;

    virtual ::std::string toString() const = 0;

    virtual ::std::shared_ptr<::Ice::EndpointInfo> getInfo() const = 0;
};

class ICE_CLASS(ICE_API) IPEndpointInfo : public ::Ice::EndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~IPEndpointInfo();

    IPEndpointInfo() = default;

    IPEndpointInfo(const IPEndpointInfo&) = default;
    IPEndpointInfo(IPEndpointInfo&&) = default;
    IPEndpointInfo& operator=(const IPEndpointInfo&) = default;
    IPEndpointInfo& operator=(IPEndpointInfo&&) = default;

    IPEndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, int iceP_port, const ::std::string& iceP_sourceAddress) :
        ::Ice::EndpointInfo(::std::move(iceP_underlying), iceP_timeout, iceP_compress),
        host(::std::move(iceP_host)),
        port(iceP_port),
        sourceAddress(::std::move(iceP_sourceAddress))
    {
    }

    ::std::string host;
    int port;
    ::std::string sourceAddress;
};

class ICE_CLASS(ICE_API) TCPEndpointInfo : public ::Ice::IPEndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~TCPEndpointInfo();

    TCPEndpointInfo() = default;

    TCPEndpointInfo(const TCPEndpointInfo&) = default;
    TCPEndpointInfo(TCPEndpointInfo&&) = default;
    TCPEndpointInfo& operator=(const TCPEndpointInfo&) = default;
    TCPEndpointInfo& operator=(TCPEndpointInfo&&) = default;

    TCPEndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, int iceP_port, const ::std::string& iceP_sourceAddress) :
        ::Ice::IPEndpointInfo(::std::move(iceP_underlying), iceP_timeout, iceP_compress, ::std::move(iceP_host), iceP_port, ::std::move(iceP_sourceAddress))
    {
    }
};

class ICE_CLASS(ICE_API) UDPEndpointInfo : public ::Ice::IPEndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~UDPEndpointInfo();

    UDPEndpointInfo() = default;

    UDPEndpointInfo(const UDPEndpointInfo&) = default;
    UDPEndpointInfo(UDPEndpointInfo&&) = default;
    UDPEndpointInfo& operator=(const UDPEndpointInfo&) = default;
    UDPEndpointInfo& operator=(UDPEndpointInfo&&) = default;

    UDPEndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, int iceP_port, const ::std::string& iceP_sourceAddress, const ::std::string& iceP_mcastInterface, int iceP_mcastTtl) :
        ::Ice::IPEndpointInfo(::std::move(iceP_underlying), iceP_timeout, iceP_compress, ::std::move(iceP_host), iceP_port, ::std::move(iceP_sourceAddress)),
        mcastInterface(::std::move(iceP_mcastInterface)),
        mcastTtl(iceP_mcastTtl)
    {
    }

    ::std::string mcastInterface;
    int mcastTtl;
};

class ICE_CLASS(ICE_API) WSEndpointInfo : public ::Ice::EndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~WSEndpointInfo();

    WSEndpointInfo() = default;

    WSEndpointInfo(const WSEndpointInfo&) = default;
    WSEndpointInfo(WSEndpointInfo&&) = default;
    WSEndpointInfo& operator=(const WSEndpointInfo&) = default;
    WSEndpointInfo& operator=(WSEndpointInfo&&) = default;

    WSEndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress, const ::std::string& iceP_resource) :
        ::Ice::EndpointInfo(::std::move(iceP_underlying), iceP_timeout, iceP_compress),
        resource(::std::move(iceP_resource))
    {
    }

    ::std::string resource;
};

class ICE_CLASS(ICE_API) OpaqueEndpointInfo : public ::Ice::EndpointInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~OpaqueEndpointInfo();

    OpaqueEndpointInfo() = default;

    OpaqueEndpointInfo(const OpaqueEndpointInfo&) = default;
    OpaqueEndpointInfo(OpaqueEndpointInfo&&) = default;
    OpaqueEndpointInfo& operator=(const OpaqueEndpointInfo&) = default;
    OpaqueEndpointInfo& operator=(OpaqueEndpointInfo&&) = default;

    OpaqueEndpointInfo(const ::std::shared_ptr<::Ice::EndpointInfo>& iceP_underlying, int iceP_timeout, bool iceP_compress, const ::Ice::EncodingVersion& iceP_rawEncoding, const ::Ice::ByteSeq& iceP_rawBytes) :
        ::Ice::EndpointInfo(::std::move(iceP_underlying), iceP_timeout, iceP_compress),
        rawEncoding(::std::move(iceP_rawEncoding)),
        rawBytes(::std::move(iceP_rawBytes))
    {
    }

    ::Ice::EncodingVersion rawEncoding;
    ::Ice::ByteSeq rawBytes;
};

}

namespace Ice
{

}

namespace Ice
{

using EndpointInfoPtr = ::std::shared_ptr<EndpointInfo>;

using EndpointPtr = ::std::shared_ptr<Endpoint>;

using IPEndpointInfoPtr = ::std::shared_ptr<IPEndpointInfo>;

using TCPEndpointInfoPtr = ::std::shared_ptr<TCPEndpointInfo>;

using UDPEndpointInfoPtr = ::std::shared_ptr<UDPEndpointInfo>;

using WSEndpointInfoPtr = ::std::shared_ptr<WSEndpointInfo>;

using OpaqueEndpointInfoPtr = ::std::shared_ptr<OpaqueEndpointInfo>;

}

#else // C++98 mapping

namespace Ice
{

class EndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::EndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::EndpointInfo> EndpointInfoPtr;

class Endpoint;
ICE_API ::Ice::LocalObject* upCast(::Ice::Endpoint*);
typedef ::IceInternal::Handle< ::Ice::Endpoint> EndpointPtr;

class IPEndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::IPEndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::IPEndpointInfo> IPEndpointInfoPtr;

class TCPEndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::TCPEndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::TCPEndpointInfo> TCPEndpointInfoPtr;

class UDPEndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::UDPEndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::UDPEndpointInfo> UDPEndpointInfoPtr;

class WSEndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::WSEndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::WSEndpointInfo> WSEndpointInfoPtr;

class OpaqueEndpointInfo;
ICE_API ::Ice::LocalObject* upCast(::Ice::OpaqueEndpointInfo*);
typedef ::IceInternal::Handle< ::Ice::OpaqueEndpointInfo> OpaqueEndpointInfoPtr;

}

namespace Ice
{

const ::Ice::Short TCPEndpointType = 1;

const ::Ice::Short SSLEndpointType = 2;

const ::Ice::Short UDPEndpointType = 3;

const ::Ice::Short WSEndpointType = 4;

const ::Ice::Short WSSEndpointType = 5;

const ::Ice::Short BTEndpointType = 6;

const ::Ice::Short BTSEndpointType = 7;

const ::Ice::Short iAPEndpointType = 8;

const ::Ice::Short iAPSEndpointType = 9;

}

namespace Ice
{

class ICE_API EndpointInfo : public virtual ::Ice::LocalObject
{
public:

    typedef EndpointInfoPtr PointerType;

    virtual ~EndpointInfo();

    EndpointInfo()
    {
    }

    EndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress) :
        underlying(iceP_underlying),
        timeout(iceP_timeout),
        compress(iceP_compress)
    {
    }

    virtual ::Ice::Short type() const = 0;

    virtual bool datagram() const = 0;

    virtual bool secure() const = 0;

    ::Ice::EndpointInfoPtr underlying;
    ::Ice::Int timeout;
    bool compress;
};

inline bool operator==(const EndpointInfo& lhs, const EndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const EndpointInfo& lhs, const EndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API Endpoint : public virtual ::Ice::LocalObject
{
public:

    typedef EndpointPtr PointerType;

    virtual ~Endpoint();

    virtual ::std::string toString() const = 0;

    virtual ::Ice::EndpointInfoPtr getInfo() const = 0;
};

inline bool operator==(const Endpoint& lhs, const Endpoint& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Endpoint& lhs, const Endpoint& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API IPEndpointInfo : public ::Ice::EndpointInfo
{
public:

    typedef IPEndpointInfoPtr PointerType;

    virtual ~IPEndpointInfo();

    IPEndpointInfo()
    {
    }

    IPEndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, ::Ice::Int iceP_port, const ::std::string& iceP_sourceAddress) :
        ::Ice::EndpointInfo(iceP_underlying, iceP_timeout, iceP_compress),
        host(iceP_host),
        port(iceP_port),
        sourceAddress(iceP_sourceAddress)
    {
    }

    ::std::string host;
    ::Ice::Int port;
    ::std::string sourceAddress;
};

inline bool operator==(const IPEndpointInfo& lhs, const IPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const IPEndpointInfo& lhs, const IPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API TCPEndpointInfo : public ::Ice::IPEndpointInfo
{
public:

    typedef TCPEndpointInfoPtr PointerType;

    virtual ~TCPEndpointInfo();

    TCPEndpointInfo()
    {
    }

    TCPEndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, ::Ice::Int iceP_port, const ::std::string& iceP_sourceAddress) :
        ::Ice::IPEndpointInfo(iceP_underlying, iceP_timeout, iceP_compress, iceP_host, iceP_port, iceP_sourceAddress)
    {
    }
};

inline bool operator==(const TCPEndpointInfo& lhs, const TCPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const TCPEndpointInfo& lhs, const TCPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API UDPEndpointInfo : public ::Ice::IPEndpointInfo
{
public:

    typedef UDPEndpointInfoPtr PointerType;

    virtual ~UDPEndpointInfo();

    UDPEndpointInfo()
    {
    }

    UDPEndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress, const ::std::string& iceP_host, ::Ice::Int iceP_port, const ::std::string& iceP_sourceAddress, const ::std::string& iceP_mcastInterface, ::Ice::Int iceP_mcastTtl) :
        ::Ice::IPEndpointInfo(iceP_underlying, iceP_timeout, iceP_compress, iceP_host, iceP_port, iceP_sourceAddress),
        mcastInterface(iceP_mcastInterface),
        mcastTtl(iceP_mcastTtl)
    {
    }

    ::std::string mcastInterface;
    ::Ice::Int mcastTtl;
};

inline bool operator==(const UDPEndpointInfo& lhs, const UDPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const UDPEndpointInfo& lhs, const UDPEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API WSEndpointInfo : public ::Ice::EndpointInfo
{
public:

    typedef WSEndpointInfoPtr PointerType;

    virtual ~WSEndpointInfo();

    WSEndpointInfo()
    {
    }

    WSEndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress, const ::std::string& iceP_resource) :
        ::Ice::EndpointInfo(iceP_underlying, iceP_timeout, iceP_compress),
        resource(iceP_resource)
    {
    }

    ::std::string resource;
};

inline bool operator==(const WSEndpointInfo& lhs, const WSEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const WSEndpointInfo& lhs, const WSEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API OpaqueEndpointInfo : public ::Ice::EndpointInfo
{
public:

    typedef OpaqueEndpointInfoPtr PointerType;

    virtual ~OpaqueEndpointInfo();

    OpaqueEndpointInfo()
    {
    }

    OpaqueEndpointInfo(const ::Ice::EndpointInfoPtr& iceP_underlying, ::Ice::Int iceP_timeout, bool iceP_compress, const ::Ice::EncodingVersion& iceP_rawEncoding, const ::Ice::ByteSeq& iceP_rawBytes) :
        ::Ice::EndpointInfo(iceP_underlying, iceP_timeout, iceP_compress),
        rawEncoding(iceP_rawEncoding),
        rawBytes(iceP_rawBytes)
    {
    }

    ::Ice::EncodingVersion rawEncoding;
    ::Ice::ByteSeq rawBytes;
};

inline bool operator==(const OpaqueEndpointInfo& lhs, const OpaqueEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const OpaqueEndpointInfo& lhs, const OpaqueEndpointInfo& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
