/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;

public class SaveConfig
extends GenericFunction {
    private JDialog _dialog = null;

    public SaveConfig(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.saveconfig";
    }

    public void begin() {
        this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        this._dialog.setDefaultCloseOperation(2);
        this._dialog.getContentPane().add(this.makeDialogComponents());
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.saveconfig.desc"));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 15, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        Properties properties = Config.getAllConfig();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement().toString();
            object2 = I18nManager.getText("dialog.saveconfig." + (String)object3);
            if (((String)object2).equals("dialog.saveconfig." + (String)object3)) continue;
            jPanel2.add(new JLabel((String)object2));
            object = properties.getProperty((String)object3);
            String string = object;
            if (Config.isKeyBoolean((String)object3)) {
                object = Config.getConfigBoolean((String)object3) ? I18nManager.getText("dialog.about.yes") : I18nManager.getText("dialog.about.no");
            } else if (object != null && ((String)object).length() > 30) {
                object = String.valueOf(((String)object).substring(0, 30)) + " ...";
            }
            JLabel jLabel2 = new JLabel((String)object);
            jLabel2.setToolTipText(string);
            jPanel2.add(jLabel2);
        }
        jPanel.add((Component)jPanel2, "Center");
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout(2));
        object2 = new JButton(I18nManager.getText("button.ok"));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveConfig.this.finish();
            }
        });
        ((Container)object3).add((Component)object2);
        object = new JButton(I18nManager.getText("button.cancel"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveConfig.this._dialog.dispose();
                SaveConfig.this._dialog = null;
            }
        });
        ((Container)object3).add((Component)object);
        jPanel.add((Component)object3, "South");
        return jPanel;
    }

    private void finish() {
        File file = Config.getConfigFile();
        if (file == null) {
            file = Config.HOME_CONFIG_FILE;
        }
        JFileChooser jFileChooser = new JFileChooser(file.getAbsoluteFile().getParent());
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this._parentFrame);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.saveConfig(file2);
        }
        this._dialog.dispose();
        this._dialog = null;
    }

    public void silentSave() {
        this.saveConfig(Config.getConfigFile());
    }

    private void saveConfig(File file) {
        block14: {
            Rectangle rectangle = this._app.getFrame().getBounds();
            String string = rectangle.x + "x" + rectangle.y + "x" + rectangle.width + "x" + rectangle.height;
            Config.setConfigString("prune.windowbounds", string);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                Config.getAllConfig().store(fileOutputStream, "GpsPrune config file");
            }
            catch (IOException iOException) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block14;
            }
            catch (NullPointerException nullPointerException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block14;
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

