/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.Bits;
import com.intellij.util.io.ByteBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.MappingFailedException;
import com.intellij.util.io.Page;
import com.intellij.util.io.ReadWriteDirectBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagedFileStorage {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PagedFileStorage");
    public static final int BUFFER_SIZE;
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    private static final ByteOrder ourNativeByteOrder;
    private static final StorageLock ourLock;
    private final StorageLockContext myStorageLockContext;
    private final boolean myNativeBytesOrder;
    private int myLastPage = -1;
    private int myLastPage2 = -1;
    private int myLastPage3 = -1;
    private ByteBufferWrapper myLastBuffer;
    private ByteBufferWrapper myLastBuffer2;
    private ByteBufferWrapper myLastBuffer3;
    private int myLastChangeCount;
    private int myLastChangeCount2;
    private int myLastChangeCount3;
    private int myStorageIndex;
    private final Object myLastAccessedBufferCacheLock = new Object();
    private final byte[] myTypedIOBuffer;
    private volatile boolean isDirty;
    private final File myFile;
    protected volatile long mySize = -1L;
    protected final int myPageSize;
    protected final boolean myValuesAreBufferAligned;

    private static long maxDirectMemory() {
        try {
            Class<?> aClass2 = Class.forName("sun.misc.VM");
            Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass2) {
            try {
                Class<?> aClass3 = Class.forName("java.nio.Bits");
                Field maxMemory = aClass3.getDeclaredField("maxMemory");
                maxMemory.setAccessible(true);
                return (Long)maxMemory.get(null);
            }
            catch (Throwable throwable) {
                return Runtime.getRuntime().maxMemory();
            }
        }
    }

    public PagedFileStorage(File file2, @Nullable StorageLockContext storageLockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        this.myFile = file2;
        this.myStorageLockContext = storageLockContext != null ? storageLockContext : PagedFileStorage.ourLock.myDefaultStorageLockContext;
        this.myPageSize = Math.max(pageSize > 0 ? pageSize : BUFFER_SIZE, Page.PAGE_SIZE);
        this.myValuesAreBufferAligned = valuesAreBufferAligned;
        this.myStorageIndex = this.myStorageLockContext.myStorageLock.registerPagedFileStorage(this);
        this.myTypedIOBuffer = valuesAreBufferAligned ? null : new byte[8];
        this.myNativeBytesOrder = nativeBytesOrder;
    }

    public void lock() {
        this.myStorageLockContext.lock();
    }

    public void unlock() {
        this.myStorageLockContext.unlock();
    }

    public StorageLockContext getStorageLockContext() {
        return this.myStorageLockContext;
    }

    public File getFile() {
        return this.myFile;
    }

    public void putInt(long addr, int value) {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            this.getBuffer(page).putInt(page_offset, value);
        } else {
            Bits.putInt(this.myTypedIOBuffer, 0, value);
            this.put(addr, this.myTypedIOBuffer, 0, 4);
        }
    }

    public int getInt(long addr) {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            return this.getReadOnlyBuffer(page).getInt(page_offset);
        }
        this.get(addr, this.myTypedIOBuffer, 0, 4);
        return Bits.getInt(this.myTypedIOBuffer, 0);
    }

    int getOffsetInPage(long addr) {
        return (int)(addr % (long)this.myPageSize);
    }

    ByteBufferWrapper getByteBuffer(long address, boolean modify) {
        long page = address / (long)this.myPageSize;
        assert (page >= 0L && page <= 65535L) : address + " in " + this.myFile;
        return this.getBufferWrapper(page, modify);
    }

    public void putLong(long addr, long value) {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            this.getBuffer(page).putLong(page_offset, value);
        } else {
            Bits.putLong(this.myTypedIOBuffer, 0, value);
            this.put(addr, this.myTypedIOBuffer, 0, 8);
        }
    }

    public long getLong(long addr) {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            return this.getReadOnlyBuffer(page).getLong(page_offset);
        }
        this.get(addr, this.myTypedIOBuffer, 0, 8);
        return Bits.getLong(this.myTypedIOBuffer, 0);
    }

    public byte get(long index2) {
        long page = index2 / (long)this.myPageSize;
        int offset2 = (int)(index2 % (long)this.myPageSize);
        return this.getReadOnlyBuffer(page).get(offset2);
    }

    public void get(long index2, byte[] dst, int offset2, int length) {
        long i = index2;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i / (long)this.myPageSize;
            int page_offset = (int)(i % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            ByteBuffer buffer = this.getReadOnlyBuffer(page);
            try {
                buffer.position(page_offset);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("can't position buffer to offset " + page_offset + ", buffer.limit=" + buffer.limit() + ", page=" + page + ", file=" + this.myFile.getName() + ", file.length=" + this.length());
            }
            buffer.get(dst, o, page_len);
            l -= page_len;
            o += page_len;
            i += (long)page_len;
        }
    }

    public void put(long index2, byte[] src, int offset2, int length) {
        long i = index2;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i / (long)this.myPageSize;
            int page_offset = (int)(i % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            ByteBuffer buffer = this.getBuffer(page);
            try {
                buffer.position(page_offset);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("can't position buffer to offset " + page_offset);
            }
            buffer.put(src, o, page_len);
            l -= page_len;
            o += page_len;
            i += (long)page_len;
        }
    }

    public void close() {
        try {
            this.force();
        }
        finally {
            this.unmapAll();
            this.myStorageLockContext.myStorageLock.myIndex2Storage.remove(this.myStorageIndex);
            this.myStorageIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmapAll() {
        this.myStorageLockContext.myStorageLock.unmapBuffersForOwner(this.myStorageIndex, this.myStorageLockContext);
        Object object = this.myLastAccessedBufferCacheLock;
        synchronized (object) {
            this.myLastPage = -1;
            this.myLastPage2 = -1;
            this.myLastPage3 = -1;
            this.myLastBuffer = null;
            this.myLastBuffer2 = null;
            this.myLastBuffer3 = null;
        }
    }

    public void resize(long newSize) throws IOException {
        long finished;
        long oldSize = this.myFile.length();
        if (oldSize == newSize && oldSize == this.length()) {
            return;
        }
        long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.myStorageLockContext.myStorageLock.invalidateBuffer(this.myStorageIndex | (int)(oldSize / (long)this.myPageSize));
        long unmapAllFinished = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.resizeFile(newSize);
        long delta = newSize - oldSize;
        if (delta > 0L) {
            this.fillWithZeros(oldSize, delta);
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Resized " + this.myFile + " from " + oldSize + " to " + newSize + " for " + (finished - started) + ", unmap all:" + (finished - unmapAllFinished));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeFile(long newSize) throws IOException {
        this.mySize = -1L;
        RandomAccessFile raf = new RandomAccessFile(this.myFile, "rw");
        try {
            raf.setLength(newSize);
        }
        finally {
            raf.close();
        }
        this.mySize = newSize;
    }

    private void fillWithZeros(long from, long length) {
        byte[] buff = new byte[8192];
        Arrays.fill(buff, (byte)0);
        while (length > 0L) {
            int filled = Math.min((int)length, 8192);
            this.put(from, buff, 0, filled);
            length -= (long)filled;
            from += (long)filled;
        }
    }

    public final long length() {
        long size = this.mySize;
        if (size == -1L) {
            this.mySize = size = this.myFile.length();
        }
        return size;
    }

    private ByteBuffer getBuffer(long page) {
        return this.getBufferWrapper(page, true).getCachedBuffer();
    }

    private ByteBuffer getReadOnlyBuffer(long page) {
        return this.getBufferWrapper(page, false).getCachedBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBufferWrapper getBufferWrapper(long page, boolean modify) {
        ByteBuffer buf;
        Object object = this.myLastAccessedBufferCacheLock;
        synchronized (object) {
            if ((long)this.myLastPage == page) {
                buf = this.myLastBuffer.getCachedBuffer();
                if (buf != null && this.myLastChangeCount == this.myStorageLockContext.myStorageLock.myMappingChangeCount) {
                    if (modify) {
                        this.markDirty(this.myLastBuffer);
                    }
                    return this.myLastBuffer;
                }
            } else if ((long)this.myLastPage2 == page) {
                buf = this.myLastBuffer2.getCachedBuffer();
                if (buf != null && this.myLastChangeCount2 == this.myStorageLockContext.myStorageLock.myMappingChangeCount) {
                    if (modify) {
                        this.markDirty(this.myLastBuffer2);
                    }
                    return this.myLastBuffer2;
                }
            } else if ((long)this.myLastPage3 == page && (buf = this.myLastBuffer3.getCachedBuffer()) != null && this.myLastChangeCount3 == this.myStorageLockContext.myStorageLock.myMappingChangeCount) {
                if (modify) {
                    this.markDirty(this.myLastBuffer3);
                }
                return this.myLastBuffer3;
            }
        }
        try {
            assert (page >= 0L && page <= 65535L) : page;
            if (this.myStorageIndex == -1) {
                this.myStorageIndex = this.myStorageLockContext.myStorageLock.registerPagedFileStorage(this);
            }
            ByteBufferWrapper byteBufferWrapper = this.myStorageLockContext.myStorageLock.get(this.myStorageIndex | (int)page);
            if (modify) {
                this.markDirty(byteBufferWrapper);
            }
            buf = byteBufferWrapper.getBuffer();
            if (this.myNativeBytesOrder && buf.order() != ourNativeByteOrder) {
                buf.order(ourNativeByteOrder);
            }
            Object object2 = this.myLastAccessedBufferCacheLock;
            synchronized (object2) {
                if ((long)this.myLastPage != page) {
                    this.myLastPage3 = this.myLastPage2;
                    this.myLastBuffer3 = this.myLastBuffer2;
                    this.myLastChangeCount3 = this.myLastChangeCount2;
                    this.myLastPage2 = this.myLastPage;
                    this.myLastBuffer2 = this.myLastBuffer;
                    this.myLastChangeCount2 = this.myLastChangeCount;
                    this.myLastBuffer = byteBufferWrapper;
                    this.myLastPage = (int)page;
                } else {
                    this.myLastBuffer = byteBufferWrapper;
                }
                this.myLastChangeCount = this.myStorageLockContext.myStorageLock.myMappingChangeCount;
            }
            return byteBufferWrapper;
        }
        catch (IOException e) {
            throw new MappingFailedException("Cannot map buffer", e);
        }
    }

    private void markDirty(ByteBufferWrapper buffer) {
        if (!this.isDirty) {
            this.isDirty = true;
        }
        buffer.markDirty();
    }

    public void force() {
        long finished;
        long started;
        long l = started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        if (this.isDirty) {
            this.myStorageLockContext.myStorageLock.flushBuffersForOwner(this.myStorageIndex, this.myStorageLockContext);
            this.isDirty = false;
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Flushed " + this.myFile + " for " + (finished - started));
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    static {
        int lower2 = 100;
        int upper = SystemInfo.is64Bit ? 500 : 200;
        BUFFER_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        long max = PagedFileStorage.maxDirectMemory() - (long)(2 * BUFFER_SIZE);
        LOWER_LIMIT = (int)Math.min(0x6400000L, max);
        UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemProperties.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; max=" + max / 0x100000L);
        ourNativeByteOrder = ByteOrder.nativeOrder();
        ourLock = new StorageLock();
    }

    public static class StorageLockContext {
        private final boolean myCheckThreadAccess;
        private final ReentrantLock myLock = new ReentrantLock();
        private final StorageLock myStorageLock;

        private StorageLockContext(StorageLock lock, boolean checkAccess) {
            this.myStorageLock = lock;
            this.myCheckThreadAccess = checkAccess;
        }

        public void lock() {
            this.myLock.lock();
        }

        public void unlock() {
            this.myLock.unlock();
        }
    }

    public static class StorageLock {
        public final StorageLockContext myDefaultStorageLockContext;
        private final ConcurrentIntObjectMap<PagedFileStorage> myIndex2Storage = ContainerUtil.createConcurrentIntObjectMap();
        private final LinkedHashMap<Integer, ByteBufferWrapper> mySegments;
        private final ReentrantLock mySegmentsAccessLock = new ReentrantLock();
        private final ReentrantLock mySegmentsAllocationLock = new ReentrantLock();
        private final ConcurrentLinkedQueue<ByteBufferWrapper> mySegmentsToRemove = new ConcurrentLinkedQueue();
        private volatile long mySize;
        private volatile long mySizeLimit;
        private volatile int myMappingChangeCount;

        public StorageLock() {
            this(true);
        }

        public StorageLock(boolean checkThreadAccess) {
            this.myDefaultStorageLockContext = new StorageLockContext(this, checkThreadAccess);
            this.mySizeLimit = UPPER_LIMIT;
            this.mySegments = new LinkedHashMap<Integer, ByteBufferWrapper>(10, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, ByteBufferWrapper> eldest) {
                    return StorageLock.this.mySize > StorageLock.this.mySizeLimit;
                }

                @Override
                @Nullable
                public ByteBufferWrapper remove(Object key) {
                    ByteBufferWrapper wrapper = (ByteBufferWrapper)super.remove(key);
                    if (wrapper != null) {
                        ++StorageLock.this.myMappingChangeCount;
                        StorageLock.this.mySegmentsToRemove.offer(wrapper);
                        StorageLock.this.mySize = StorageLock.this.mySize - wrapper.myLength;
                    }
                    return wrapper;
                }
            };
        }

        private int registerPagedFileStorage(@NotNull PagedFileStorage storage2) {
            if (storage2 == null) {
                StorageLock.$$$reportNull$$$0(0);
            }
            int registered = this.myIndex2Storage.size();
            assert (registered <= 65535);
            int value = registered << 16;
            while (this.myIndex2Storage.cacheOrGet(value, storage2) != storage2) {
                assert (++registered <= 65535);
                value = registered << 16;
            }
            return value;
        }

        private PagedFileStorage getRegisteredPagedFileStorageByIndex(int index2) {
            return this.myIndex2Storage.get(index2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBufferWrapper get(Integer key) {
            ByteBufferWrapper wrapper;
            try {
                this.mySegmentsAccessLock.lock();
                wrapper = this.mySegments.get(key);
                if (wrapper != null) {
                    ByteBufferWrapper byteBufferWrapper = wrapper;
                    return byteBufferWrapper;
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.mySegmentsAllocationLock.lock();
            try {
                long finished;
                this.mySegmentsAccessLock.lock();
                try {
                    wrapper = this.mySegments.get(key);
                    if (wrapper != null) {
                        ByteBufferWrapper byteBufferWrapper = wrapper;
                        return byteBufferWrapper;
                    }
                }
                finally {
                    this.mySegmentsAccessLock.unlock();
                }
                long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
                wrapper = this.createValue(key);
                if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
                    IOStatistics.dump("Mapping " + wrapper.myLength + " from " + wrapper.myPosition + " file:" + wrapper.myFile + " for " + (finished - started));
                }
                this.mySegmentsAccessLock.lock();
                try {
                    this.mySegments.put(key, wrapper);
                    this.mySize += wrapper.myLength;
                }
                finally {
                    this.mySegmentsAccessLock.unlock();
                }
                this.ensureSize(this.mySizeLimit);
                ByteBufferWrapper byteBufferWrapper = wrapper;
                return byteBufferWrapper;
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
        }

        private void disposeRemovedSegments() {
            if (this.mySegmentsToRemove.isEmpty()) {
                return;
            }
            assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
            Iterator<ByteBufferWrapper> iterator2 = this.mySegmentsToRemove.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().dispose();
                iterator2.remove();
            }
        }

        private void ensureSize(long sizeLimit) {
            assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
            try {
                this.mySegmentsAccessLock.lock();
                while (this.mySize > sizeLimit) {
                    this.mySegments.doRemoveEldestEntry();
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.disposeRemovedSegments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private ByteBufferWrapper createValue(Integer key) {
            int storageIndex = key & 0xFFFF0000;
            PagedFileStorage owner = this.getRegisteredPagedFileStorageByIndex(storageIndex);
            assert (owner != null) : "No storage for index " + storageIndex;
            StorageLock.checkThreadAccess(owner.myStorageLockContext);
            long off = (long)(key & 0xFFFF) * (long)owner.myPageSize;
            long ownerLength = owner.length();
            if (off > ownerLength) {
                throw new IndexOutOfBoundsException("off=" + off + " key.owner.length()=" + ownerLength);
            }
            int min = (int)Math.min(ownerLength - off, (long)owner.myPageSize);
            ByteBufferWrapper wrapper = ByteBufferWrapper.readWriteDirect(owner.myFile, off, min);
            OutOfMemoryError oome = null;
            while (true) {
                ByteBufferWrapper byteBufferWrapper;
                try {
                    wrapper.getBuffer();
                    if (oome != null) {
                        LOG.info("Successfully recovered OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB new size limit: " + this.mySizeLimit / 0x100000L + "MB trying to allocate " + wrapper.myLength + " block");
                    }
                    byteBufferWrapper = wrapper;
                }
                catch (IOException e) {
                    throw new MappingFailedException("Cannot map buffer", e);
                }
                catch (OutOfMemoryError e) {
                    long newSize;
                    oome = e;
                    if (this.mySizeLimit > (long)LOWER_LIMIT) {
                        this.mySizeLimit -= (long)owner.myPageSize;
                    }
                    if ((newSize = this.mySize - (long)owner.myPageSize) < 0L) {
                        LOG.info("Currently allocated:" + this.mySize);
                        LOG.info("Mapping failed due to OOME. Current buffers: " + this.mySegments);
                        LOG.info(oome);
                        try {
                            Object reserved;
                            Object max;
                            Class<?> aClass2 = Class.forName("java.nio.Bits");
                            Field reservedMemory = aClass2.getDeclaredField("reservedMemory");
                            reservedMemory.setAccessible(true);
                            Field maxMemory = aClass2.getDeclaredField("maxMemory");
                            maxMemory.setAccessible(true);
                            Class<?> clazz = aClass2;
                            synchronized (clazz) {
                                max = maxMemory.get(null);
                                reserved = reservedMemory.get(null);
                            }
                            LOG.info("Max memory:" + max + ", reserved memory:" + reserved);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new MappingFailedException("Cannot recover from OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB new size limit: " + this.mySizeLimit / 0x100000L + "MB trying to allocate " + wrapper.myLength + " block", e);
                    }
                    this.ensureSize(newSize);
                    continue;
                }
                if (byteBufferWrapper == null) {
                    StorageLock.$$$reportNull$$$0(1);
                }
                return byteBufferWrapper;
                break;
            }
        }

        private static void checkThreadAccess(StorageLockContext storageLockContext) {
            if (storageLockContext.myCheckThreadAccess && !storageLockContext.myLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Must hold StorageLock lock to access PagedFileStorage");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Map<Integer, ByteBufferWrapper> getBuffersOrderedForOwner(int index2, StorageLockContext storageLockContext) {
            this.mySegmentsAccessLock.lock();
            try {
                StorageLock.checkThreadAccess(storageLockContext);
                TreeMap<Integer, ByteBufferWrapper> mineBuffers = null;
                for (Map.Entry<Integer, ByteBufferWrapper> entry : this.mySegments.entrySet()) {
                    if ((entry.getKey() & 0xFFFF0000) != index2) continue;
                    if (mineBuffers == null) {
                        mineBuffers = new TreeMap<Integer, ByteBufferWrapper>(new Comparator<Integer>(){

                            @Override
                            public int compare(Integer o1, Integer o2) {
                                return o1 - o2;
                            }
                        });
                    }
                    mineBuffers.put(entry.getKey(), entry.getValue());
                }
                Iterator<Map.Entry<Integer, ByteBufferWrapper>> iterator2 = mineBuffers;
                return iterator2;
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unmapBuffersForOwner(int index2, StorageLockContext storageLockContext) {
            Map<Integer, ByteBufferWrapper> buffers = this.getBuffersOrderedForOwner(index2, storageLockContext);
            if (buffers != null) {
                this.mySegmentsAccessLock.lock();
                try {
                    for (Integer key : buffers.keySet()) {
                        this.mySegments.remove(key);
                    }
                }
                finally {
                    this.mySegmentsAccessLock.unlock();
                }
                this.mySegmentsAllocationLock.lock();
                try {
                    this.disposeRemovedSegments();
                }
                finally {
                    this.mySegmentsAllocationLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushBuffersForOwner(int index2, StorageLockContext storageLockContext) {
            Map<Integer, ByteBufferWrapper> buffers = this.getBuffersOrderedForOwner(index2, storageLockContext);
            if (buffers != null) {
                this.mySegmentsAllocationLock.lock();
                try {
                    Disposable fileContext = null;
                    for (ByteBufferWrapper buffer : buffers.values()) {
                        if (buffer instanceof ReadWriteDirectBufferWrapper) {
                            fileContext = ((ReadWriteDirectBufferWrapper)buffer).flushWithContext(fileContext);
                            continue;
                        }
                        buffer.flush();
                    }
                    if (fileContext != null) {
                        fileContext.dispose();
                    }
                }
                finally {
                    this.mySegmentsAllocationLock.unlock();
                }
            }
        }

        public void invalidateBuffer(int page) {
            this.mySegmentsAccessLock.lock();
            try {
                this.mySegments.remove(page);
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.mySegmentsAllocationLock.lock();
            try {
                this.disposeRemovedSegments();
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/PagedFileStorage$StorageLock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/PagedFileStorage$StorageLock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerPagedFileStorage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

