/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Exception;
import Ice.LocalException;
import IceInternal.Instance;
import IceInternal.OutgoingAsyncBase;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.QueueExecutorService;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RetryException;
import java.util.concurrent.Callable;

public class QueueRequestHandler
implements RequestHandler {
    private final RequestHandler _delegate;
    private final QueueExecutorService _executor;

    public QueueRequestHandler(Instance instance, RequestHandler delegate) {
        this._executor = instance.getQueueExecutor();
        assert (delegate != null);
        this._delegate = delegate;
    }

    @Override
    public RequestHandler update(RequestHandler previousHandler, RequestHandler newHandler) {
        try {
            if (previousHandler == this || previousHandler == this._delegate) {
                return newHandler;
            }
            if (previousHandler.getConnection() == this._delegate.getConnection()) {
                return newHandler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int sendAsyncRequest(final ProxyOutgoingAsyncBase out) throws RetryException {
        return this._executor.execute(new Callable<Integer>(){

            @Override
            public Integer call() throws RetryException {
                return QueueRequestHandler.this._delegate.sendAsyncRequest(out);
            }
        });
    }

    @Override
    public void asyncRequestCanceled(final OutgoingAsyncBase outAsync, final LocalException ex) {
        this._executor.executeNoThrow(new Callable<Void>(){

            @Override
            public Void call() {
                QueueRequestHandler.this._delegate.asyncRequestCanceled(outAsync, ex);
                return null;
            }
        });
    }

    @Override
    public Reference getReference() {
        return this._delegate.getReference();
    }

    @Override
    public ConnectionI getConnection() {
        return this._delegate.getConnection();
    }
}

