/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class RolloverResponse
extends ActionResponse
implements ToXContentObject {
    private static final String NEW_INDEX = "new_index";
    private static final String OLD_INDEX = "old_index";
    private static final String DRY_RUN = "dry_run";
    private static final String ROLLED_OVER = "rolled_over";
    private static final String CONDITIONS = "conditions";
    private static final String ACKNOWLEDGED = "acknowledged";
    private static final String SHARDS_ACKED = "shards_acknowledged";
    private String oldIndex;
    private String newIndex;
    private Set<Map.Entry<String, Boolean>> conditionStatus;
    private boolean dryRun;
    private boolean rolledOver;
    private boolean acknowledged;
    private boolean shardsAcknowledged;

    RolloverResponse() {
    }

    RolloverResponse(String oldIndex, String newIndex, Set<Condition.Result> conditionResults, boolean dryRun, boolean rolledOver, boolean acknowledged, boolean shardsAcknowledged) {
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.dryRun = dryRun;
        this.rolledOver = rolledOver;
        this.acknowledged = acknowledged;
        this.shardsAcknowledged = shardsAcknowledged;
        this.conditionStatus = conditionResults.stream().map(result -> new AbstractMap.SimpleEntry<String, Boolean>(result.condition.toString(), result.matched)).collect(Collectors.toSet());
    }

    public String getOldIndex() {
        return this.oldIndex;
    }

    public String getNewIndex() {
        return this.newIndex;
    }

    public Set<Map.Entry<String, Boolean>> getConditionStatus() {
        return this.conditionStatus;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isRolledOver() {
        return this.rolledOver;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Deprecated
    public boolean isShardsAcked() {
        return this.shardsAcknowledged;
    }

    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.oldIndex = in.readString();
        this.newIndex = in.readString();
        int conditionSize = in.readVInt();
        HashSet<Map.Entry<String, Boolean>> conditions = new HashSet<Map.Entry<String, Boolean>>(conditionSize);
        for (int i = 0; i < conditionSize; ++i) {
            String condition = in.readString();
            boolean satisfied = in.readBoolean();
            conditions.add(new AbstractMap.SimpleEntry<String, Boolean>(condition, satisfied));
        }
        this.conditionStatus = conditions;
        this.dryRun = in.readBoolean();
        this.rolledOver = in.readBoolean();
        this.acknowledged = in.readBoolean();
        this.shardsAcknowledged = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.oldIndex);
        out.writeString(this.newIndex);
        out.writeVInt(this.conditionStatus.size());
        for (Map.Entry<String, Boolean> entry : this.conditionStatus) {
            out.writeString(entry.getKey());
            out.writeBoolean(entry.getValue());
        }
        out.writeBoolean(this.dryRun);
        out.writeBoolean(this.rolledOver);
        out.writeBoolean(this.acknowledged);
        out.writeBoolean(this.shardsAcknowledged);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OLD_INDEX, this.oldIndex);
        builder.field(NEW_INDEX, this.newIndex);
        builder.field(ROLLED_OVER, this.rolledOver);
        builder.field(DRY_RUN, this.dryRun);
        builder.field(ACKNOWLEDGED, this.acknowledged);
        builder.field(SHARDS_ACKED, this.shardsAcknowledged);
        builder.startObject(CONDITIONS);
        for (Map.Entry<String, Boolean> entry : this.conditionStatus) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

