/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.sort.SortOrder;

class CompositeValuesSourceConfig {
    private final String name;
    private final ValuesSource vs;
    private final int reverseMul;
    private final boolean canEarlyTerminate;

    CompositeValuesSourceConfig(String name, ValuesSource vs, SortOrder order, boolean canEarlyTerminate) {
        this.name = name;
        this.vs = vs;
        this.canEarlyTerminate = canEarlyTerminate;
        this.reverseMul = order == SortOrder.ASC ? 1 : -1;
    }

    String name() {
        return this.name;
    }

    ValuesSource valuesSource() {
        return this.vs;
    }

    int reverseMul() {
        assert (this.reverseMul == -1 || this.reverseMul == 1);
        return this.reverseMul;
    }

    boolean canEarlyTerminate() {
        return this.canEarlyTerminate;
    }
}

