/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.rankeval.RankEvalAction;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.index.rankeval.RankEvalSpec;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestRankEvalAction
extends BaseRestHandler {
    public RestRankEvalAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_rank_eval", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_rank_eval", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_rank_eval", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_rank_eval", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RankEvalRequest rankEvalRequest = new RankEvalRequest();
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestRankEvalAction.parseRankEvalRequest(rankEvalRequest, request, parser);
        }
        return channel -> client.executeLocally((GenericAction)RankEvalAction.INSTANCE, (ActionRequest)rankEvalRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private static void parseRankEvalRequest(RankEvalRequest rankEvalRequest, RestRequest request, XContentParser parser) {
        List<String> indices = Arrays.asList(Strings.splitStringByCommaToArray((String)request.param("index")));
        RankEvalSpec spec = RankEvalSpec.parse(parser);
        spec.addIndices(indices);
        rankEvalRequest.setRankEvalSpec(spec);
    }

    public String getName() {
        return "rank_eval_action";
    }
}

