/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.openide.awt.Mnemonics;

public class LogFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(LogFrame.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(2);
    private Log log = Log.getInstance();
    private LogListModel logModel = new LogListModel();
    private JButton clearButton;
    private JButton closeButton;
    private JButton copyButton;
    private JScrollPane jScrollPane1;
    private JList logList;

    public LogFrame() {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.closeButton);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("log-16.png").getImage());
        images.add(Icons.get("log-32.png").getImage());
        images.add(Icons.get("log-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.closeButtonActionPerformed(e);
            }
        });
        this.selectLastRecord();
    }

    private void selectLastRecord() {
        this.logList.clearSelection();
        int index = this.logModel.getSize() - 1;
        this.logList.setSelectedIndex(index);
        this.logList.ensureIndexIsVisible(index);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.logList = new JList();
        this.closeButton = new JButton();
        this.clearButton = new JButton();
        this.copyButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(l10n.getString("LogFrame.title"));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                LogFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.logList.setModel(this.logModel);
        this.logList.setCellRenderer(new LogRenderer());
        this.jScrollPane1.setViewportView(this.logList);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/close-22.png")));
        Mnemonics.setLocalizedText(this.closeButton, l10n.getString("Close_"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/clear-22.png")));
        Mnemonics.setLocalizedText(this.clearButton, l10n.getString("LogFrame.clearButton.text"));
        this.clearButton.setToolTipText(l10n.getString("LogFrame.clearButton.toolTipText"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogFrame.this.clearButtonActionPerformed(evt);
            }
        });
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/copy-22.png")));
        Mnemonics.setLocalizedText(this.copyButton, l10n.getString("CopyToClipboard_"));
        this.copyButton.setToolTipText(l10n.getString("LogFrame.copyButton.toolTipText"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogFrame.this.copyButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 549, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 206, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 258, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.clearButton)).addComponent(this.copyButton)).addContainerGap()));
        layout.linkSize(1, this.clearButton, this.closeButton, this.copyButton);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.log.clearRecords();
        Context.mainFrame.getStatusPanel().setStatusMessage(null, null, null, false);
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        try {
            logger.fine("Copying logs to clipboard");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder builder = new StringBuilder();
            for (Log.Record record : this.log.getRecords()) {
                builder.append("[");
                builder.append(timeFormat.format(record.getTime()));
                builder.append("] ");
                builder.append(record.getMessage().replaceAll("<.*?>", ""));
                builder.append("\n");
            }
            StringSelection text = new StringSelection(builder.toString());
            clipboard.setContents(text, null);
        }
        catch (IllegalStateException ex) {
            logger.log(Level.WARNING, "System clipboard not available", ex);
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.closeButton.requestFocusInWindow();
    }

    private class LogRenderer
    implements ListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();

        private LogRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Log.Record record = (Log.Record)value;
            String text = "[" + timeFormat.format(record.getTime()) + "] " + record.getMessage();
            ((JLabel)c).setText("<html>" + MiscUtils.escapeHtml(text) + "</html>");
            ((JLabel)c).setIcon(record.getIcon() != null ? record.getIcon() : Icons.STATUS_BLANK);
            return c;
        }
    }

    private class LogListModel
    extends AbstractListModel {
        private int oldSize = this.getSize();

        public LogListModel() {
            LogFrame.this.log.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 0: {
                            LogListModel.this.fireContentsChanged(LogListModel.this, 0, LogListModel.this.getSize());
                            break;
                        }
                        case 1: 
                        case 2: {
                            LogListModel.this.fireIntervalRemoved(LogListModel.this, 0, LogListModel.this.oldSize);
                            break;
                        }
                        default: {
                            logger.warning("Unknown action event type");
                            assert (false) : "Unknown action event type";
                            break;
                        }
                    }
                    LogListModel.this.oldSize = LogListModel.this.getSize();
                    LogFrame.this.selectLastRecord();
                }
            });
        }

        @Override
        public int getSize() {
            return LogFrame.this.log.size();
        }

        @Override
        public Log.Record getElementAt(int index) {
            return LogFrame.this.log.getRecords().get(index);
        }
    }
}

