/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.geonames.Location;
import org.fibs.geotag.gui.DateTimeChooser;
import org.fibs.geotag.gui.menus.CopyLocationMenu;
import org.fibs.geotag.gui.menus.CopyOffsetMenu;
import org.fibs.geotag.gui.menus.GoogleEarthMenu;
import org.fibs.geotag.gui.menus.MatchTracksMenu;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.gui.menus.SaveLocationsMenu;
import org.fibs.geotag.gui.menus.ShowOnMapMenu;
import org.fibs.geotag.gui.menus.actions.CopyOffsetToAllAction;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.CopyLocationNameTask;
import org.fibs.geotag.tasks.FillGapsTask;
import org.fibs.geotag.tasks.FindAltitudeTask;
import org.fibs.geotag.tasks.LocationNamesTask;
import org.fibs.geotag.tasks.RemoveImagesTask;
import org.fibs.geotag.tasks.SelectLocationNameTask;
import org.fibs.geotag.tasks.SetOffsetTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.track.TrackStore;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImagesTablePopupMenu
extends JPopupMenu
implements ActionListener,
MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(ImagesTablePopupMenu.class);
    private static final String SELECT_CORRECT_TIME = i18n.tr("Set time of image");
    private static final String FILL_GAPS = i18n.tr("Fill gaps");
    private static final String FILL_THIS_GAP = i18n.tr("for this image");
    private static final String FILL_SELECTED_GAPS = i18n.tr("between selected images");
    private static final String FILL_ALL_GAPS = i18n.tr("all gaps between images");
    private static final String LOCATION_NAMES = i18n.tr("Location names");
    private static final String LOCATION_NAME_THIS = i18n.tr("find for this image");
    private static final String LOCATION_NAMES_SELECTED = i18n.tr("find for selected images");
    private static final String LOCATION_NAMES_ALL = i18n.tr("find for all images");
    private static final String LOCATION_NAMES_SELECT = i18n.tr("Select");
    private static final String COPY_LOCATION_NAME = i18n.tr("Copy");
    private static final String COPY_LOCATION_NAME_PREVIOUS = i18n.tr("to previous image");
    private static final String COPY_LOCATION_NAME_NEXT = i18n.tr("to next image");
    private static final String COPY_LOCATION_NAME_SELECTED = i18n.tr("to selected images");
    private static final String COPY_LOCATION_NAME_ALL = i18n.tr("to all images");
    private static final String REMOVE_IMAGES = i18n.tr("Remove images");
    private static final String FIND_ALTITUDE = i18n.tr("Find altitude");
    private static final String FIND_THIS_ALTITUDE = i18n.tr("for this image");
    private static final String FIND_SELECTED_ALTITUDES = i18n.tr("for selected images");
    private static final String FIND_ALL_ALTITUDES = i18n.tr("for all images");
    private static final String REMOVE_THIS_IMAGE = i18n.tr("This image");
    private static final String REMOVE_SELECTED_IMAGES = i18n.tr("Selected images");
    private static final String REMOVE_ALL_IMAGES = i18n.tr("All images");
    private JFrame parentFrame;
    ImagesTable imagesTable;
    private ImagesTableModel tableModel;
    private int[] selectedRows;
    private JMenuItem chooseTimeItem;
    private JMenuItem fillThisGapItem;
    private JMenuItem fillGapsInSelectionItem;
    private JMenuItem fillAllGapsItem;
    private JMenuItem locationNameThisItem;
    private JMenuItem locationNamesSelectedItem;
    private JMenuItem locationNamesAllItem;
    private JMenuItem copyLocationNamePreviousItem;
    private JMenuItem copyLocationNameNextItem;
    private JMenuItem copyLocationNameSelectedItem;
    private JMenuItem copyLocationNameAllItem;
    private JMenuItem removeThisImageItem;
    private JMenuItem removeSelectedImagesItem;
    private JMenuItem removeAllImagesItem;
    private JMenuItem findAltitudeThisImageItem;
    private JMenuItem findAltitudeSelectedImagesItem;
    private JMenuItem findAltitudeAllImagesItem;
    ImageInfo imageInfo;

    public ImagesTablePopupMenu(JFrame parentFrame, ImagesTable imagesTable, int row, boolean backgroundTask) {
        CopyLocationMenu copyLocationsMenu;
        MatchTracksMenu matchTracksMenu;
        CopyOffsetMenu copyOffsetMenu;
        this.parentFrame = parentFrame;
        this.imagesTable = imagesTable;
        this.tableModel = (ImagesTableModel)imagesTable.getModel();
        TrackStore trackStore = TrackStore.getTrackStore();
        this.selectedRows = imagesTable.getSelectedRows();
        this.imageInfo = ((ImagesTableModel)imagesTable.getModel()).getImageInfo(row);
        JMenuItem headerItem = new JMenuItem(this.imageInfo.getName());
        int fontSize = headerItem.getFont().getSize();
        int fontStyle = headerItem.getFont().getStyle();
        Font font = new Font(headerItem.getFont().getName(), fontStyle, fontSize);
        headerItem.setFont(font);
        headerItem.setEnabled(false);
        this.add(headerItem);
        this.add(new JSeparator());
        this.add(new ShowOnMapMenu(backgroundTask, imagesTable, this.imageInfo, false));
        this.add(new ShowOnMapMenu(backgroundTask, imagesTable, this.imageInfo, true));
        this.add(new GoogleEarthMenu(backgroundTask, imagesTable, this.imageInfo));
        this.chooseTimeItem = new JMenuItem(String.valueOf(SELECT_CORRECT_TIME) + "...");
        boolean enabled = !backgroundTask;
        this.chooseTimeItem.setEnabled(enabled);
        this.chooseTimeItem.addActionListener(this);
        if (enabled) {
            this.add(this.chooseTimeItem);
        }
        if ((copyOffsetMenu = new CopyOffsetMenu(backgroundTask, imagesTable, this.imageInfo)).isEnabled()) {
            this.add(copyOffsetMenu);
        }
        if ((matchTracksMenu = new MatchTracksMenu(backgroundTask, imagesTable, this.imageInfo, trackStore)).isEnabled()) {
            this.add(matchTracksMenu);
        }
        if ((copyLocationsMenu = new CopyLocationMenu(backgroundTask, imagesTable, this.imageInfo)).isEnabled()) {
            this.add(copyLocationsMenu);
        }
        this.addFillGapsMenu(backgroundTask, trackStore);
        this.addLocationNamesMenu(row, backgroundTask);
        this.addFindAltitudeMenu(row, backgroundTask);
        this.add(new SaveLocationsMenu(backgroundTask, imagesTable, this.imageInfo));
        this.addRemoveImagesMenu(backgroundTask);
    }

    private void addFindAltitudeMenu(int row, boolean backgroundTask) {
        JMenu findAltitudeMenu = new JMenu(FIND_ALTITUDE);
        boolean addMenu = false;
        this.findAltitudeThisImageItem = new JMenuItem(FIND_THIS_ALTITUDE);
        boolean enabled = !backgroundTask && this.imageInfo.hasLocation();
        addMenu |= enabled;
        this.findAltitudeThisImageItem.setEnabled(enabled);
        this.findAltitudeThisImageItem.addActionListener(this);
        findAltitudeMenu.add(this.findAltitudeThisImageItem);
        this.findAltitudeSelectedImagesItem = new JMenuItem(FIND_SELECTED_ALTITUDES);
        enabled = false;
        int index = 0;
        while (index < this.selectedRows.length) {
            if (this.tableModel.getImageInfo(this.selectedRows[index]).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        addMenu |= enabled;
        this.findAltitudeSelectedImagesItem.setEnabled(enabled);
        this.findAltitudeSelectedImagesItem.addActionListener(this);
        findAltitudeMenu.add(this.findAltitudeSelectedImagesItem);
        this.findAltitudeAllImagesItem = new JMenuItem(FIND_ALL_ALTITUDES);
        enabled = false;
        index = 0;
        while (index < this.tableModel.getRowCount()) {
            if (this.tableModel.getImageInfo(index).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        this.findAltitudeAllImagesItem.setEnabled(enabled);
        this.findAltitudeAllImagesItem.addActionListener(this);
        findAltitudeMenu.add(this.findAltitudeAllImagesItem);
        if (addMenu |= enabled) {
            this.add(findAltitudeMenu);
        }
    }

    private void addLocationNamesMenu(int row, boolean backgroundTask) {
        JMenu locationNamesMenu = new JMenu(LOCATION_NAMES);
        boolean addMenu = false;
        this.locationNameThisItem = new JMenuItem(LOCATION_NAME_THIS);
        boolean enabled = !backgroundTask && this.imageInfo.hasLocation();
        addMenu |= enabled;
        this.locationNameThisItem.setEnabled(enabled);
        this.locationNameThisItem.addActionListener(this);
        locationNamesMenu.add(this.locationNameThisItem);
        this.locationNamesSelectedItem = new JMenuItem(LOCATION_NAMES_SELECTED);
        enabled = false;
        int index = 0;
        while (index < this.selectedRows.length) {
            if (this.tableModel.getImageInfo(this.selectedRows[index]).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        addMenu |= enabled;
        this.locationNamesSelectedItem.setEnabled(enabled);
        this.locationNamesSelectedItem.addActionListener(this);
        locationNamesMenu.add(this.locationNamesSelectedItem);
        this.locationNamesAllItem = new JMenuItem(LOCATION_NAMES_ALL);
        enabled = false;
        index = 0;
        while (index < this.tableModel.getRowCount()) {
            if (this.tableModel.getImageInfo(index).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        addMenu |= enabled;
        this.locationNamesAllItem.setEnabled(enabled);
        this.locationNamesAllItem.addActionListener(this);
        locationNamesMenu.add(this.locationNamesAllItem);
        this.addSelectLocationsMenu(locationNamesMenu);
        JMenu copyLocationNameMenu = new JMenu(COPY_LOCATION_NAME);
        boolean addSubMenu = false;
        this.copyLocationNamePreviousItem = new JMenuItem(COPY_LOCATION_NAME_PREVIOUS);
        enabled = !backgroundTask && this.imageInfo.hasLocationName() && row > 0;
        addSubMenu |= enabled;
        this.copyLocationNamePreviousItem.setEnabled(enabled);
        this.copyLocationNamePreviousItem.addActionListener(this);
        copyLocationNameMenu.add(this.copyLocationNamePreviousItem);
        this.copyLocationNameNextItem = new JMenuItem(COPY_LOCATION_NAME_NEXT);
        enabled = !backgroundTask && this.imageInfo.hasLocationName() && row < this.tableModel.getRowCount() - 1;
        addSubMenu |= enabled;
        this.copyLocationNameNextItem.setEnabled(enabled);
        this.copyLocationNameNextItem.addActionListener(this);
        copyLocationNameMenu.add(this.copyLocationNameNextItem);
        this.copyLocationNameSelectedItem = new JMenuItem(COPY_LOCATION_NAME_SELECTED);
        enabled = !backgroundTask && this.imageInfo.hasLocationName() && this.selectedRows.length > 0;
        addSubMenu |= enabled;
        this.copyLocationNameSelectedItem.setEnabled(enabled);
        this.copyLocationNameSelectedItem.addActionListener(this);
        copyLocationNameMenu.add(this.copyLocationNameSelectedItem);
        this.copyLocationNameAllItem = new JMenuItem(COPY_LOCATION_NAME_ALL);
        enabled = !backgroundTask && this.imageInfo.hasLocationName();
        this.copyLocationNameAllItem.setEnabled(enabled);
        this.copyLocationNameAllItem.addActionListener(this);
        copyLocationNameMenu.add(this.copyLocationNameAllItem);
        if (addSubMenu |= enabled) {
            locationNamesMenu.add(copyLocationNameMenu);
        }
        if (addMenu) {
            this.add(locationNamesMenu);
        }
    }

    private void addSelectLocationsMenu(JMenu locationNamesMenu) {
        JMenu selectLocationMenu = new JMenu(LOCATION_NAMES_SELECT);
        List<Location> nearbyLocations = this.imageInfo.getNearbyLocations();
        if (nearbyLocations != null && nearbyLocations.size() > 0) {
            Iterator<Location> iterator = nearbyLocations.iterator();
            while (iterator.hasNext()) {
                Location location;
                final Location itemLocation = location = iterator.next();
                StringBuilder locationText = new StringBuilder(location.getName());
                if (location.getProvince() != null && location.getProvince().length() > 0) {
                    locationText.append(", ").append(location.getProvince());
                }
                if (location.getCountryName() != null && location.getCountryName().length() > 0) {
                    locationText.append(", ").append(location.getCountryName());
                }
                Units.DISTANCE distanceUnit = Units.DISTANCE.values()[Settings.get(Settings.SETTING.DISTANCE_UNIT, 0)];
                locationText.append(" (");
                if (location.getFeatureName() != null) {
                    locationText.append(location.getFeatureName());
                    locationText.append(" - ");
                }
                locationText.append(String.format("%.2f %s)", new Double(location.getDistance(distanceUnit)), Units.getAbbreviation(distanceUnit)));
                if (itemLocation.getAlternateNames() == null) {
                    JMenuItem selectLocationItem = new JMenuItem(locationText.toString(), location.getIcon());
                    selectLocationItem.addActionListener(new LocationNameActionListener(itemLocation.getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TaskExecutor.execute(new SelectLocationNameTask(i18n.tr("Select location name"), ImagesTablePopupMenu.this.getTableModel(), ImagesTablePopupMenu.this.getImageInfo(), itemLocation, itemLocation.getName(), ImageInfo.DATA_SOURCE.MANUAL));
                        }
                    });
                    selectLocationMenu.add(selectLocationItem);
                    continue;
                }
                JMenu selectLocationNameMenu = new JMenu(locationText.toString());
                JMenuItem selectLocationItem = new JMenuItem(itemLocation.getName());
                selectLocationItem.addActionListener(new LocationNameActionListener(itemLocation.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TaskExecutor.execute(new SelectLocationNameTask(i18n.tr("Select location name"), ImagesTablePopupMenu.this.getTableModel(), ImagesTablePopupMenu.this.getImageInfo(), itemLocation, this.getName(), ImageInfo.DATA_SOURCE.MANUAL));
                    }
                });
                selectLocationNameMenu.add(selectLocationItem);
                for (String alternateName : itemLocation.getAlternateNames()) {
                    selectLocationItem = new JMenuItem(alternateName);
                    selectLocationItem.addActionListener(new LocationNameActionListener(alternateName){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TaskExecutor.execute(new SelectLocationNameTask(i18n.tr("Select location name"), ImagesTablePopupMenu.this.getTableModel(), ImagesTablePopupMenu.this.getImageInfo(), itemLocation, this.getName(), ImageInfo.DATA_SOURCE.MANUAL));
                        }
                    });
                    selectLocationNameMenu.add(selectLocationItem);
                }
                selectLocationMenu.add(selectLocationNameMenu);
            }
            locationNamesMenu.add(selectLocationMenu);
        }
    }

    private void addFillGapsMenu(boolean backgroundTask, TrackStore trackStore) {
        JMenu fillGapsMenu = new JMenu(FILL_GAPS);
        boolean addMenu = false;
        this.fillThisGapItem = new JMenuItem(FILL_THIS_GAP);
        boolean enabled = !backgroundTask && trackStore.hasTracks() && !this.imageInfo.hasLocation();
        addMenu |= enabled;
        this.fillThisGapItem.setEnabled(enabled);
        this.fillThisGapItem.addActionListener(this);
        fillGapsMenu.add(this.fillThisGapItem);
        this.fillGapsInSelectionItem = new JMenuItem(FILL_SELECTED_GAPS);
        enabled = false;
        int index = 0;
        while (index < this.selectedRows.length) {
            if (!this.tableModel.getImageInfo(this.selectedRows[index]).hasLocation()) {
                enabled = !backgroundTask && trackStore.hasTracks();
                break;
            }
            ++index;
        }
        addMenu |= enabled;
        this.fillGapsInSelectionItem.setEnabled(enabled);
        this.fillGapsInSelectionItem.addActionListener(this);
        fillGapsMenu.add(this.fillGapsInSelectionItem);
        this.fillAllGapsItem = new JMenuItem(FILL_ALL_GAPS);
        enabled = false;
        index = 0;
        while (index < this.tableModel.getRowCount()) {
            if (!this.tableModel.getImageInfo(index).hasLocation()) {
                enabled = !backgroundTask && trackStore.hasTracks();
                break;
            }
            ++index;
        }
        this.fillAllGapsItem.setEnabled(enabled);
        this.fillAllGapsItem.addActionListener(this);
        fillGapsMenu.add(this.fillAllGapsItem);
        if (addMenu |= enabled) {
            this.add(fillGapsMenu);
        }
    }

    private void addRemoveImagesMenu(boolean backgroundTask) {
        JMenu removeImagesMenu = new JMenu(REMOVE_IMAGES);
        boolean addMenu = false;
        this.removeThisImageItem = new JMenuItem(REMOVE_THIS_IMAGE);
        boolean enabled = !backgroundTask;
        addMenu |= enabled;
        this.removeThisImageItem.setEnabled(enabled);
        this.removeThisImageItem.addActionListener(this);
        removeImagesMenu.add(this.removeThisImageItem);
        this.removeSelectedImagesItem = new JMenuItem(REMOVE_SELECTED_IMAGES);
        enabled = !backgroundTask && this.selectedRows.length > 0;
        addMenu |= enabled;
        this.removeSelectedImagesItem.setEnabled(enabled);
        this.removeSelectedImagesItem.addActionListener(this);
        removeImagesMenu.add(this.removeSelectedImagesItem);
        this.removeAllImagesItem = new JMenuItem(REMOVE_ALL_IMAGES);
        enabled = !backgroundTask;
        this.removeAllImagesItem.setEnabled(enabled);
        this.removeAllImagesItem.addActionListener(this);
        removeImagesMenu.add(this.removeAllImagesItem);
        if (addMenu |= enabled) {
            this.add(removeImagesMenu);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.chooseTimeItem) {
            this.chooseTime();
        } else if (event.getSource() == this.fillThisGapItem) {
            this.fillThisGap();
        } else if (event.getSource() == this.fillGapsInSelectionItem) {
            this.fillGapsInSelection();
        } else if (event.getSource() == this.fillAllGapsItem) {
            this.fillAllGaps();
        } else if (event.getSource() == this.locationNameThisItem) {
            this.findOneLocationName();
        } else if (event.getSource() == this.locationNamesSelectedItem) {
            this.findSelectedLocationNames();
        } else if (event.getSource() == this.locationNamesAllItem) {
            this.findAllLocationNames();
        } else if (event.getSource() == this.copyLocationNamePreviousItem) {
            this.copyLocationNameToPrevious();
        } else if (event.getSource() == this.copyLocationNameNextItem) {
            this.copyLocationNameToNext();
        } else if (event.getSource() == this.copyLocationNameSelectedItem) {
            this.copyLocationNameToSelected();
        } else if (event.getSource() == this.copyLocationNameAllItem) {
            this.copyLocationNameToAll();
        } else if (event.getSource() == this.removeThisImageItem) {
            this.removeOneImage();
        } else if (event.getSource() == this.removeSelectedImagesItem) {
            this.removeSelectedImages();
        } else if (event.getSource() == this.removeAllImagesItem) {
            this.removeAllImages();
        } else if (event.getSource() == this.findAltitudeThisImageItem) {
            this.findThisAltitude();
        } else if (event.getSource() == this.findAltitudeSelectedImagesItem) {
            this.findSelectedAltitudes();
        } else if (event.getSource() == this.findAltitudeAllImagesItem) {
            this.findAllAltitudes();
        }
    }

    private void chooseTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ImageInfo.getDateFormatPattern());
        try {
            Date cameraDate = dateFormat.parse(this.imageInfo.getCameraDate());
            Calendar createCalendar = Calendar.getInstance();
            createCalendar.setTime(cameraDate);
            DateTimeChooser chooser = new DateTimeChooser(this.parentFrame, i18n.tr("Select Date and Time"), createCalendar, false);
            Calendar chosenDate = chooser.openChooser();
            if (chosenDate != null) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                String gmtTime = dateFormat.format(chosenDate.getTime());
                final int offset = this.imageInfo.calculateOffset(gmtTime, this.imageInfo.getCameraDate());
                ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
                imageList.add(this.imageInfo);
                SetOffsetTask setOffsetTask = new SetOffsetTask(null, SELECT_CORRECT_TIME, this.tableModel, offset, imageList){

                    @Override
                    protected void done() {
                        super.done();
                        String message = i18n.tr("Do you want to use this time difference for all images?");
                        if (JOptionPane.showConfirmDialog(ImagesTablePopupMenu.this.getParentFrame(), message, ImageInfo.getOffsetString(offset), 0, 3) == 0) {
                            new CopyOffsetToAllAction(ImagesTablePopupMenu.this.imageInfo, ImagesTablePopupMenu.this.imagesTable).perform();
                        }
                        ImagesTablePopupMenu.this.getTableModel().sortRows();
                    }
                };
                TaskExecutor.execute(setOffsetTask);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void fillThisGap() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.imageInfo);
        TaskExecutor.execute(new FillGapsTask(FILL_GAPS, FILL_THIS_GAP, this.tableModel, images));
    }

    private void fillGapsInSelection() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            ImageInfo candidate = this.tableModel.getImageInfo(this.selectedRows[index]);
            if (!candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new FillGapsTask(FILL_GAPS, FILL_SELECTED_GAPS, this.tableModel, images));
    }

    private void fillAllGaps() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            ImageInfo candidate = this.tableModel.getImageInfo(index);
            if (!candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new FillGapsTask(FILL_GAPS, FILL_ALL_GAPS, this.tableModel, images));
    }

    private void findOneLocationName() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.imageInfo);
        TaskExecutor.execute(new LocationNamesTask(LOCATION_NAMES, LOCATION_NAME_THIS, this.tableModel, images));
    }

    private void findSelectedLocationNames() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            ImageInfo candidate = this.tableModel.getImageInfo(this.selectedRows[index]);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new LocationNamesTask(LOCATION_NAMES, LOCATION_NAMES_SELECTED, this.tableModel, images));
    }

    private void findAllLocationNames() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            ImageInfo candidate = this.tableModel.getImageInfo(index);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new LocationNamesTask(LOCATION_NAMES, LOCATION_NAMES_ALL, this.tableModel, images));
    }

    private void findThisAltitude() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.imageInfo);
        TaskExecutor.execute(new FindAltitudeTask(FIND_ALTITUDE, FIND_THIS_ALTITUDE, this.tableModel, images));
    }

    private void findSelectedAltitudes() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            ImageInfo candidate = this.tableModel.getImageInfo(this.selectedRows[index]);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new FindAltitudeTask(FIND_ALTITUDE, FIND_SELECTED_ALTITUDES, this.tableModel, images));
    }

    private void findAllAltitudes() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            ImageInfo candidate = this.tableModel.getImageInfo(index);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        TaskExecutor.execute(new FindAltitudeTask(FIND_ALTITUDE, FIND_ALL_ALTITUDES, this.tableModel, images));
    }

    private void copyLocationNameToPrevious() {
        int row = this.tableModel.getRow(this.imageInfo);
        if (row > 0) {
            ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
            imageList.add(this.tableModel.getImageInfo(row - 1));
            TaskExecutor.execute(new CopyLocationNameTask(String.valueOf(LOCATION_NAMES) + " - " + COPY_LOCATION_NAME, COPY_LOCATION_NAME_PREVIOUS, this.tableModel, this.imageInfo, imageList));
        }
    }

    private void copyLocationNameToNext() {
        int row = this.tableModel.getRow(this.imageInfo);
        if (row < this.tableModel.getRowCount() - 1) {
            ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
            imageList.add(this.tableModel.getImageInfo(row + 1));
            TaskExecutor.execute(new CopyLocationNameTask(String.valueOf(LOCATION_NAMES) + " - " + COPY_LOCATION_NAME, COPY_LOCATION_NAME_NEXT, this.tableModel, this.imageInfo, imageList));
        }
    }

    private void copyLocationNameToSelected() {
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            imageList.add(this.tableModel.getImageInfo(this.selectedRows[index]));
            ++index;
        }
        TaskExecutor.execute(new CopyLocationNameTask(String.valueOf(LOCATION_NAMES) + " - " + COPY_LOCATION_NAME, COPY_LOCATION_NAME_SELECTED, this.tableModel, this.imageInfo, imageList));
    }

    private void copyLocationNameToAll() {
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            imageList.add(this.tableModel.getImageInfo(index));
            ++index;
        }
        TaskExecutor.execute(new CopyLocationNameTask(String.valueOf(LOCATION_NAMES) + " - " + COPY_LOCATION_NAME, COPY_LOCATION_NAME_ALL, this.tableModel, this.imageInfo, imageList));
    }

    private void removeOneImage() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.imageInfo);
        TaskExecutor.execute(new RemoveImagesTask(REMOVE_IMAGES, REMOVE_THIS_IMAGE, this.tableModel, images));
    }

    private void removeSelectedImages() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            images.add(this.tableModel.getImageInfo(this.selectedRows[index]));
            ++index;
        }
        TaskExecutor.execute(new RemoveImagesTask(REMOVE_IMAGES, REMOVE_SELECTED_IMAGES, this.tableModel, images));
    }

    private void removeAllImages() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            images.add(this.tableModel.getImageInfo(index));
            ++index;
        }
        TaskExecutor.execute(new RemoveImagesTask(REMOVE_IMAGES, REMOVE_ALL_IMAGES, this.tableModel, images));
    }

    JFrame getParentFrame() {
        return this.parentFrame;
    }

    ImagesTable getImagesTable() {
        return this.imagesTable;
    }

    ImagesTableModel getTableModel() {
        return this.tableModel;
    }

    int[] getSelectedRows() {
        return this.selectedRows;
    }

    ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    abstract class LocationNameActionListener
    implements ActionListener {
        private String name;

        public LocationNameActionListener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

