/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.image.ImageRotator;
import org.fibs.geotag.tasks.PreviewLoaderTask;
import org.fibs.geotag.tasks.TaskExecutor;

public class PreviewComponent
extends Component {
    private BufferedImage image;
    private ImageInfo imageInfo;

    public PreviewComponent() {
    }

    public PreviewComponent(String name) {
        this.setName(name);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    private double determineScaleFactor() {
        double factor = 1.0;
        if (this.image.getWidth() > this.getWidth()) {
            factor = (double)this.getWidth() / (double)this.image.getWidth();
        }
        if (this.image.getHeight() > this.getHeight()) {
            factor = Math.min(factor, (double)this.getHeight() / (double)this.image.getHeight());
        }
        return factor;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.image != null) {
            double scaleFactor = this.determineScaleFactor();
            AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
            double translateX = ((double)this.getWidth() - (double)this.image.getWidth() * scaleFactor) / 2.0;
            double translateY = ((double)this.getHeight() - (double)this.image.getHeight() * scaleFactor) / 2.0;
            AffineTransform translateTransform = AffineTransform.getTranslateInstance(translateX, translateY);
            AffineTransform transform = scaleTransform;
            transform.preConcatenate(translateTransform);
            g2d.drawImage(this.image, transform, null);
        } else if (this.getName() != null) {
            g2d.drawString(this.getName(), this.getWidth() / 2, this.getHeight() / 2);
        } else {
            super.paint(g);
        }
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(final ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
        if (imageInfo != null) {
            File file = new File(imageInfo.getPath());
            TaskExecutor.execute(new PreviewLoaderTask(file, 500L){

                @Override
                protected void done() {
                    BufferedImage bufferedImage = this.getImage();
                    if (bufferedImage != null) {
                        BufferedImage rotatedImage = new ImageRotator(bufferedImage, imageInfo).rotate();
                        PreviewComponent.this.setImage(rotatedImage);
                    } else {
                        PreviewComponent.this.setImage(null);
                    }
                }
            });
        } else {
            this.setImage(null);
        }
    }

    void setImage(BufferedImage image) {
        if (image != null && image.getType() != 1) {
            BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics graphics = rgbImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            this.image = rgbImage;
        } else {
            this.image = image;
        }
        this.repaint();
    }
}

