/*

   Copyright (C) 2001,2002,2003,2004 Michael Rubinstein

   This file is part of the L-function package L.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   Check the License for details. You should have received a copy of it, along
   with the package; see the file 'COPYING'. If not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include "Lmisc.h"

template <class ttype>
Complex L_function <ttype>::
partial_dirichlet_series(Complex s, long long N1, long long N2)
{
    Complex z=0.;
    long long m,n;
         if(what_type_L==-1)   //i.e. if the Riemann zeta function
            for(n=N1;n<=N2;n++) z=z+exp(-s*LOG(n));
        else if(what_type_L!=1) //if not periodic
            for(n=N1;n<=N2;n++) z=z+dirichlet_coefficient[n]*exp(-s*LOG(n));
        else //if periodic
            for(n=N1;n<=N2;n++)
            {
                m=n%period; if(m==0)m=period;
                z=z+dirichlet_coefficient[m]*exp(-s*LOG(n));
            }
          return z;
}
 //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
template <class ttype>
Complex L_function <ttype>::
dirichlet_series(Complex s, long long N)
{
    Complex z=0.;
    long long m,n;
     if(N==-1) N=number_of_dirichlet_coefficients;
    if(N>number_of_dirichlet_coefficients&&what_type_L!=-1&&what_type_L!=1)
    {

        if(print_warning){
            print_warning=false;
            cout << "WARNING from dirichlet series- we don't have enough Dirichlet coefficients." << endl;
            cout << "Will use the maximum possible, though the output ";
            cout << "will not necessarily be accurate." << endl;
        }
        N=number_of_dirichlet_coefficients;
    }
    if(what_type_L==-1)   //i.e. if the Riemann zeta function
        for(n=1;n<=N;n++) z=z+exp(-s*LOG(n));
    else if(what_type_L!=1) //if not periodic
        for(n=1;n<=N;n++) z=z+dirichlet_coefficient[n]*exp(-s*LOG(n));
    else //if periodic
        for(n=1;n<=N;n++)
        {
            m=n%period; if(m==0)m=period;
            z=z+dirichlet_coefficient[m]*exp(-s*LOG(n));
        }
      return z;

}



