/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.ui.BasicComp;
import com.sun.media.ui.DefaultControlPanel;
import com.sun.media.ui.ToolTip;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.Time;

public class ProgressSlider
extends BasicComp
implements MouseListener,
MouseMotionListener,
Runnable,
ComponentListener,
ControllerListener {
    Image imageGrabber;
    Image imageGrabberDown;
    int grabberWidth;
    int grabberHeight;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 0;
    int rightBorder = 0;
    int sliderWidth;
    MediaThread timer = null;
    protected boolean justSeeked = false;
    protected boolean stopTimer = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Player player;
    private DefaultControlPanel controlPanel;
    private ToolTip toolTip = null;
    private double progressCaching = 1.0;
    private boolean resetMediaTime = false;
    Object disposeLock = new Object();
    Object syncStop = new Object();
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public ProgressSlider(String label, DefaultControlPanel cp, Player p) {
        super(label);
        this.player = p;
        this.controlPanel = cp;
        this.imageGrabber = BasicComp.fetchImage("grabber.gif");
        this.imageGrabberDown = BasicComp.fetchImage("grabber-pressed.gif");
        this.grabberWidth = this.imageGrabber.getWidth(this);
        this.grabberHeight = this.imageGrabber.getHeight(this);
        this.rightBorder = this.leftBorder = this.grabberWidth / 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.grabberPosition = 0;
        this.grabbed = false;
        this.entered = false;
        this.height = 18;
        this.width = 20;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.addComponentListener(this);
        this.player.addControllerListener(this);
    }

    public void addNotify() {
        super.addNotify();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                ProgressSlider slider = this;
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                this.timer = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = ProgressSlider.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                this.timer.setName("Progress Slider thread");
                cons = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.timer;
                objectArray2[1] = new Integer(MediaThread.getControlPriority());
                objectArray[0] = cons.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
                this.stopTimer = false;
                this.timer.start();
            }
            catch (Exception exception) {}
        } else {
            this.timer = new MediaThread(this);
            this.timer.setName("Progress Slider thread");
            this.timer.useControlPriority();
            this.stopTimer = false;
            this.timer.start();
        }
    }

    public void removeNotify() {
        Object object;
        if (this.timer != null) {
            object = this.syncStop;
            synchronized (object) {
                this.stopTimer = true;
                this.timer = null;
            }
        }
        object = this.disposeLock;
        synchronized (object) {
            if (this.toolTip != null) {
                ((Component)this.toolTip).setVisible(false);
            }
        }
        super.removeNotify();
    }

    public synchronized void dispose() {
        Object object = this.syncStop;
        synchronized (object) {
            if (this.timer != null) {
                this.stopTimer = true;
            }
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeComponentListener(this);
        Object object2 = this.disposeLock;
        synchronized (object2) {
            if (this.toolTip != null) {
                this.toolTip.dispose();
                this.toolTip = null;
            }
        }
        this.timer = null;
        this.player = null;
    }

    public void run() {
        int counter = 0;
        int pausecnt = -1;
        boolean doUpdate = true;
        while (!this.stopTimer) {
            try {
                if (this.player != null && this.player.getState() == 600) {
                    doUpdate = true;
                    pausecnt = -1;
                } else if (this.player != null && pausecnt < 5) {
                    ++pausecnt;
                    doUpdate = true;
                } else if (this.resetMediaTime) {
                    doUpdate = true;
                    this.resetMediaTime = false;
                } else {
                    doUpdate = false;
                }
                try {
                    long nanoDuration;
                    if (doUpdate && (nanoDuration = this.player.getDuration().getNanoseconds()) > 0L) {
                        long nanoTime = this.player.getMediaNanoseconds();
                        this.seek((float)nanoTime / (float)nanoDuration);
                        if (!this.grabbed) {
                            this.updateToolTip(nanoTime);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int sleepTime = this.isEnabled() ? 200 : 1000;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (++counter == 1000 / sleepTime) {
                    counter = 0;
                    this.controlPanel.update();
                }
                if (!this.justSeeked) continue;
                this.justSeeked = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        if (this.isEnabled()) {
            int y = this.height / 2 - 2;
            int grabberY = this.height / 2 - this.grabberHeight / 2;
            g.setColor(this.getBackground().darker());
            g.drawRect(this.leftBorder, y, this.sliderWidth, 3);
            g.setColor(this.getBackground());
            int downloadCredit = this.grabberWidth;
            g.draw3DRect(this.leftBorder, y, (int)((double)(this.sliderWidth - downloadCredit) * this.progressCaching + (double)downloadCredit), 3, false);
            if (this.grabbed || this.entered) {
                g.drawImage(this.imageGrabberDown, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, grabberY, this);
            } else {
                g.drawImage(this.imageGrabber, this.grabberPosition + this.leftBorder - this.grabberWidth / 2, grabberY, this);
            }
        } else if (this.player != null) {
            String strTime = this.formatTime(this.player.getMediaNanoseconds());
            Font font = this.getFont();
            g.setFont(font);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            g.drawString(strTime, 2, 2 + fontMetrics.getAscent());
        }
    }

    private void sliderSeek(float fraction) {
        if (this.player == null) {
            return;
        }
        long value = (long)(fraction * (float)this.player.getDuration().getNanoseconds());
        this.justSeeked = true;
        if (value >= 0L) {
            this.player.setMediaTime(new Time(value));
            this.controlPanel.resetPauseCount();
            this.controlPanel.update();
        }
    }

    public void seek(float fraction) {
        if (this.justSeeked) {
            return;
        }
        if (!this.grabbed) {
            int newPosition = (int)(fraction * (float)this.sliderWidth);
            if (newPosition > this.sliderWidth) {
                newPosition = this.sliderWidth;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (this.grabberPosition != newPosition || !this.isEnabled()) {
                this.grabberPosition = newPosition;
                this.repaint();
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, this.height);
    }

    public float sliderToSeek(int x) {
        float s = (float)x / (float)this.sliderWidth;
        return s;
    }

    public int mouseToSlider(int x) {
        if (x < this.leftBorder) {
            x = this.leftBorder;
        }
        if (x > this.width - this.rightBorder) {
            x = this.width - this.rightBorder;
        }
        return x -= this.leftBorder;
    }

    public void mousePressed(MouseEvent me) {
        if (!this.isEnabled()) {
            return;
        }
        this.grabbed = true;
        this.grabberPosition = this.mouseToSlider(me.getX());
        this.repaint();
    }

    public synchronized void mouseReleased(MouseEvent me) {
        if (!this.isEnabled()) {
            return;
        }
        this.grabbed = false;
        this.grabberPosition = this.mouseToSlider(me.getX());
        float seek = this.sliderToSeek(this.grabberPosition);
        this.sliderSeek(seek);
        if (this.toolTip != null && !this.entered) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public synchronized void mouseEntered(MouseEvent me) {
        this.entered = true;
        if (this.toolTip == null && this.isEnabled() && this.player != null) {
            this.toolTip = new ToolTip("time/duration");
            this.updateToolTip(this.player.getMediaNanoseconds());
            if (this.isShowing()) {
                Point pointScreen = this.getLocationOnScreen();
                pointScreen.y += this.height + 4;
                ((Component)this.toolTip).setLocation(pointScreen);
                this.toolTip.show();
            }
        }
        this.repaint();
    }

    public synchronized void mouseExited(MouseEvent me) {
        if (this.toolTip != null && !this.grabbed) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.entered = false;
        this.repaint();
    }

    public synchronized void mouseMoved(MouseEvent me) {
        if (this.toolTip != null && this.isShowing()) {
            Dimension dim = this.toolTip.getSize();
            Point pointScreen = this.getLocationOnScreen();
            pointScreen.x += me.getX() - dim.width - 2;
            pointScreen.y += me.getY();
        }
    }

    public synchronized void mouseDragged(MouseEvent me) {
        if (!this.isEnabled() || this.player == null) {
            return;
        }
        int newPosition = this.mouseToSlider(me.getX());
        if (newPosition != this.grabberPosition) {
            this.grabberPosition = newPosition;
            float seek = this.sliderToSeek(this.grabberPosition);
            if (this.player.getState() != 600) {
                this.sliderSeek(seek);
            }
            long value = (long)(seek * (float)this.player.getDuration().getNanoseconds());
            this.updateToolTip(value);
            this.repaint();
        }
    }

    public void componentResized(ComponentEvent event) {
        Dimension dim = this.getSize();
        if (dim.width - this.leftBorder - this.rightBorder < 1) {
            return;
        }
        this.grabberPosition = (int)((float)this.grabberPosition * ((float)(dim.width - this.leftBorder - this.rightBorder) / (float)(this.width - this.leftBorder - this.rightBorder)));
        this.width = dim.width;
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof CachingControlEvent) {
            CachingControl cachingControl = ((CachingControlEvent)event).getCachingControl();
            long length = cachingControl.getContentLength();
            long progress = cachingControl.getContentProgress();
            this.progressCaching = (double)progress / (double)length;
            this.repaint();
        } else if (event instanceof MediaTimeSetEvent) {
            this.resetMediaTime = true;
        }
    }

    private String formatTime(Time time) {
        String strTime = new String("<unknown>");
        if (time == null || time == Time.TIME_UNKNOWN || time == Duration.DURATION_UNKNOWN) {
            return strTime;
        }
        long nano = time.getNanoseconds();
        strTime = this.formatTime(nano);
        return strTime;
    }

    private String formatTime(long nanoSeconds) {
        int seconds = (int)(nanoSeconds / 1000000000L);
        int hours = seconds / 3600;
        int minutes = (seconds - hours * 3600) / 60;
        seconds = seconds - hours * 3600 - minutes * 60;
        nanoSeconds = nanoSeconds % 1000000000L / 10000000L;
        int hours10 = hours / 10;
        int minutes10 = minutes / 10;
        int seconds10 = seconds / 10;
        long nano10 = nanoSeconds / 10L;
        String strTime = new String("" + hours10 + (hours %= 10) + ":" + minutes10 + (minutes %= 10) + ":" + seconds10 + (seconds %= 10) + "." + nano10 + (nanoSeconds %= 10L));
        return strTime;
    }

    public void updateToolTip(long nanoMedia) {
        if (this.toolTip == null || this.player == null) {
            return;
        }
        Time timeDuration = this.player.getDuration();
        String strTool = new String(this.formatTime(nanoMedia) + " / " + this.formatTime(timeDuration));
        this.toolTip.setText(strTool);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

