/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.internal;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.internal.ByteOrderWrapper;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.j3d.J3DBuffer;

public class ByteBufferWrapper
extends BufferWrapper {
    private ByteBuffer buffer = null;

    public ByteBufferWrapper(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public ByteBufferWrapper(J3DBuffer j3DBuffer) {
        this.buffer = (ByteBuffer)j3DBuffer.getBuffer();
    }

    public static ByteBufferWrapper allocateDirect(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        return new ByteBufferWrapper(byteBuffer);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int n) {
        return this.buffer.get(n);
    }

    public ByteBufferWrapper get(byte[] byArray) {
        this.buffer.get(byArray);
        return this;
    }

    public ByteBufferWrapper get(byte[] byArray, int n, int n2) {
        this.buffer.get(byArray, n, n2);
        return this;
    }

    public ByteOrderWrapper order() {
        if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
            return ByteOrderWrapper.BIG_ENDIAN;
        }
        return ByteOrderWrapper.LITTLE_ENDIAN;
    }

    public ByteBufferWrapper order(ByteOrderWrapper byteOrderWrapper) {
        if (byteOrderWrapper == ByteOrderWrapper.BIG_ENDIAN) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return this;
    }

    public FloatBufferWrapper asFloatBuffer() {
        return new FloatBufferWrapper(this.buffer.asFloatBuffer());
    }

    public DoubleBufferWrapper asDoubleBuffer() {
        return new DoubleBufferWrapper(this.buffer.asDoubleBuffer());
    }

    public ByteBufferWrapper put(byte[] byArray) {
        this.buffer.put(byArray);
        return this;
    }

    public J3DBuffer getJ3DBuffer() {
        return new J3DBuffer((Buffer)this.buffer);
    }
}

