/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.KBCubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;

public class KBCubicSplineCurve {
    private float totalCurveLength;
    private KBCubicSplineSegment[] cubicSplineSegment;
    public int numSegments;

    KBCubicSplineCurve() {
        this.numSegments = 0;
        this.totalCurveLength = 0.0f;
    }

    KBCubicSplineCurve(KBKeyFrame[] kBKeyFrameArray) {
        int n = kBKeyFrameArray.length;
        if (n < 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBCubicSplineCurve0"));
        }
        this.numSegments = n - 3;
        this.cubicSplineSegment = new KBCubicSplineSegment[this.numSegments];
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        while (n2 < this.numSegments) {
            this.cubicSplineSegment[n2] = new KBCubicSplineSegment(kBKeyFrameArray[n2], kBKeyFrameArray[n3], kBKeyFrameArray[n4], kBKeyFrameArray[n5]);
            ++n2;
            ++n3;
            ++n4;
            ++n5;
        }
        this.computeTotalCurveLength();
    }

    KBCubicSplineCurve(KBCubicSplineSegment[] kBCubicSplineSegmentArray) {
        this.cubicSplineSegment = new KBCubicSplineSegment[kBCubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i = 0; i < this.numSegments; ++i) {
            this.cubicSplineSegment[i] = kBCubicSplineSegmentArray[i];
        }
        this.computeTotalCurveLength();
    }

    public void setSegments(KBCubicSplineSegment[] kBCubicSplineSegmentArray) {
        this.cubicSplineSegment = new KBCubicSplineSegment[kBCubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i = 0; i < this.numSegments; ++i) {
            this.cubicSplineSegment[i] = kBCubicSplineSegmentArray[i];
        }
        this.computeTotalCurveLength();
    }

    public KBCubicSplineSegment getSegment(int n) {
        return this.cubicSplineSegment[n];
    }

    private void computeTotalCurveLength() {
        this.totalCurveLength = 0.0f;
        for (int i = 0; i < this.numSegments; ++i) {
            this.totalCurveLength += this.cubicSplineSegment[i].length;
        }
    }

    public float getTotalCurveLength() {
        return this.totalCurveLength;
    }
}

