/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

public final class Solvers {
    public static final double[] solveQuadric(double d, double d2, double d3) {
        double[] dArray;
        double d4;
        double d5 = d2 * d2 - 4.0 * d * d3;
        if (d5 < 0.0) {
            return null;
        }
        d5 = Math.sqrt(d5);
        double d6 = d2 < 0.0 ? -0.5 * (d2 - d5) : -0.5 * (d2 + d5);
        double d7 = d6 / d;
        if (d7 > (d4 = d3 / d6)) {
            double[] dArray2 = new double[2];
            dArray2[0] = d4;
            dArray = dArray2;
            dArray2[1] = d7;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = d7;
            dArray = dArray3;
            dArray3[1] = d4;
        }
        return dArray;
    }

    public static double[] solveQuartic(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = 1.0 / d;
        double d8 = d2 * d7;
        double d9 = d8 * d8;
        double d10 = d3 * d7;
        double d11 = -0.375 * d9 + d10;
        double d12 = d4 * d7;
        double d13 = d5 * d7;
        double d14 = -0.01171875 * d9 * d9 + 0.0625 * d9 * d10 - 0.25 * d8 * d12 + d13;
        double d15 = 0.125 * d9 * d8 - 0.5 * d8 * d10 + d12;
        double d16 = Solvers.solveCubicForQuartic(-0.5 * d11, -d14, 0.5 * d14 * d11 - 0.125 * d15 * d15);
        double d17 = 2.0 * d16 - d11;
        if (d17 < 0.0) {
            if (d17 > 1.0E-10) {
                d17 = 0.0;
            } else {
                return null;
            }
        }
        if (d17 < 1.0E-10) {
            d6 = d16 * d16 - d14;
            if (d6 < 0.0) {
                return null;
            }
            d6 = Math.sqrt(d6);
        } else {
            d17 = Math.sqrt(d17);
            d6 = 0.5 * d15 / d17;
        }
        double d18 = d17 * d17;
        double d19 = -0.25 * d8;
        double d20 = d18 - 4.0 * (d16 - d6);
        double d21 = d18 - 4.0 * (d16 + d6);
        if (d20 >= 0.0 && d21 >= 0.0) {
            d20 = Math.sqrt(d20);
            d21 = Math.sqrt(d21);
            double[] dArray = new double[]{-0.5 * (d17 + d20) + d19, -0.5 * (d17 - d20) + d19, 0.5 * (d17 + d21) + d19, 0.5 * (d17 - d21) + d19};
            for (int i = 1; i < 4; ++i) {
                for (int j = i; j > 0 && dArray[j - 1] > dArray[j]; --j) {
                    double d22 = dArray[j];
                    dArray[j] = dArray[j - 1];
                    dArray[j - 1] = d22;
                }
            }
            return dArray;
        }
        if (d20 >= 0.0) {
            d20 = Math.sqrt(d20);
            double[] dArray = new double[]{-0.5 * (d17 + d20) + d19, -0.5 * (d17 - d20) + d19};
            return dArray;
        }
        if (d21 >= 0.0) {
            d21 = Math.sqrt(d21);
            double[] dArray = new double[]{0.5 * (d17 - d21) + d19, 0.5 * (d17 + d21) + d19};
            return dArray;
        }
        return null;
    }

    private static final double solveCubicForQuartic(double d, double d2, double d3) {
        double d4 = d * d;
        double d5 = (d4 - 3.0 * d2) / 9.0;
        double d6 = (d * (d4 - 4.5 * d2) + 13.5 * d3) / 27.0;
        double d7 = d5 * d5 * d5;
        double d8 = d6 * d6;
        double d9 = d7 - d8;
        double d10 = d / 3.0;
        if (d9 >= 0.0) {
            d9 = d6 / Math.sqrt(d7);
            double d11 = Math.acos(d9) / 3.0;
            double d12 = -2.0 * Math.sqrt(d5);
            return d12 * Math.cos(d11) - d10;
        }
        double d13 = Math.pow(Math.sqrt(d8 - d7) + Math.abs(d6), 0.3333333333333333);
        if (d6 < 0.0) {
            return d13 + d5 / d13 - d10;
        }
        return -(d13 + d5 / d13) - d10;
    }
}

