/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.VoidParameter;

public class Configuration {
    static LogWriter vlog = new LogWriter("Configuration");
    private static final String IDENTIFIER_STRING = "TigerVNC Configuration file Version 1.0";
    private static Configuration global_ = null;
    private static Configuration server_ = null;
    private static Configuration viewer_ = null;
    private String name;
    public VoidParameter head;
    public Configuration _next;

    public static Configuration global() {
        if (global_ == null) {
            global_ = new Configuration("Global");
        }
        return global_;
    }

    public static Configuration server() {
        if (server_ == null) {
            server_ = new Configuration("Server");
        }
        return server_;
    }

    public static Configuration viewer() {
        if (viewer_ == null) {
            viewer_ = new Configuration("Viewer");
        }
        return viewer_;
    }

    public static void enableServerParams() {
        Configuration.global().appendConfiguration(Configuration.server());
    }

    public static void enableViewerParams() {
        Configuration.global().appendConfiguration(Configuration.viewer());
    }

    public void appendConfiguration(Configuration configuration) {
        configuration._next = this._next;
        this._next = configuration;
    }

    public Configuration(String string, Configuration configuration) {
        this.name = string;
        this.head = null;
        this._next = null;
        if (configuration != null) {
            this._next = configuration._next;
            configuration._next = this;
        }
    }

    public Configuration(String string) {
        this(string, null);
    }

    public final String getName() {
        return this.name;
    }

    public Configuration assign(Configuration configuration) {
        VoidParameter voidParameter = this.head;
        while (voidParameter != null) {
            VoidParameter voidParameter2 = configuration.get(voidParameter.getName());
            if (voidParameter2 != null) {
                voidParameter.immutable = false;
                String string = voidParameter2.getValueStr();
                vlog.debug("operator=(" + voidParameter.getName() + ", " + string + ")");
                voidParameter.setParam(string);
            }
            voidParameter = voidParameter._next;
        }
        if (this._next != null) {
            this._next = configuration;
        }
        return this;
    }

    public boolean set(String string, String string2, boolean bl) {
        return this.set(string, string.length(), string2, bl);
    }

    public boolean set(String string, String string2) {
        return this.set(string, string.length(), string2, false);
    }

    public boolean set(String string, int n, String string2, boolean bl) {
        VoidParameter voidParameter = this.head;
        while (voidParameter != null) {
            if (voidParameter.getName().length() == n && voidParameter.getName().equalsIgnoreCase(string.substring(0, n))) {
                boolean bl2 = voidParameter.setParam(string2);
                voidParameter.setHasBeenSet();
                if (bl2 && bl) {
                    voidParameter.setImmutable();
                }
                return bl2;
            }
            voidParameter = voidParameter._next;
        }
        return this._next != null ? this._next.set(string, n, string2, bl) : false;
    }

    boolean set(String string, boolean bl) {
        int n;
        boolean bl2 = false;
        if (string.charAt(0) == '-') {
            bl2 = true;
            if ((string = string.substring(1)).charAt(0) == '-') {
                string = string.substring(1);
            }
        }
        if ((n = string.indexOf(61)) > -1) {
            return this.set(string, n, string.substring(n + 1), bl);
        }
        if (bl2) {
            VoidParameter voidParameter = this.head;
            while (voidParameter != null) {
                if (voidParameter.getName().equalsIgnoreCase(string)) {
                    boolean bl3 = voidParameter.setParam();
                    voidParameter.setHasBeenSet();
                    if (bl3 && bl) {
                        voidParameter.setImmutable();
                    }
                    return bl3;
                }
                voidParameter = voidParameter._next;
            }
        }
        return this._next != null ? this._next.set(string, bl) : false;
    }

    boolean set(String string) {
        return this.set(string, false);
    }

    public static boolean setParam(String string, String string2, boolean bl) {
        return Configuration.global().set(string, string2, bl);
    }

    public static boolean setParam(String string, String string2) {
        return Configuration.setParam(string, string2, false);
    }

    public static boolean setParam(String string, boolean bl) {
        return Configuration.global().set(string, bl);
    }

    public static boolean setParam(String string) {
        return Configuration.setParam(string, false);
    }

    public static boolean setParam(String string, int n, String string2, boolean bl) {
        return Configuration.global().set(string, n, string2, bl);
    }

    public VoidParameter get(String string) {
        VoidParameter voidParameter = this.head;
        while (voidParameter != null) {
            if (voidParameter.getName().equalsIgnoreCase(string)) {
                return voidParameter;
            }
            voidParameter = voidParameter._next;
        }
        return this._next != null ? this._next.get(string) : null;
    }

    public static VoidParameter getParam(String string) {
        return Configuration.global().get(string);
    }

    public static void listParams(int n, int n2) {
        Configuration.global().list(n, n2);
    }

    public static void listParams() {
        Configuration.listParams(79, 10);
    }

    public void list(int n, int n2) {
        VoidParameter voidParameter = this.head;
        System.err.format("%s Parameters:%n", this.name);
        while (voidParameter != null) {
            String string = voidParameter.getDefaultStr();
            String string2 = voidParameter.getDescription().trim();
            String string3 = "  %-" + n2 + "s -";
            System.err.format(string3, voidParameter.getName());
            int n3 = voidParameter.getName().length();
            if (n3 < n2) {
                n3 = n2;
            }
            n3 += 4;
            while (true) {
                int n4;
                int n5;
                if (n3 + (n5 = (n4 = string2.indexOf(32)) > -1 ? n4 : string2.length()) + 1 > n) {
                    string3 = "%n%" + (n2 + 4) + "s";
                    System.err.format(string3, "");
                    n3 = n2 + 4;
                }
                string3 = " %" + n5 + "s";
                System.err.format(string3, string2.substring(0, n5));
                n3 += n5 + 1;
                if (n4 == -1) break;
                string2 = string2.substring(n5 + 1);
            }
            if (string != null) {
                if (n3 + string.length() + 11 > n) {
                    System.err.format("%n%" + (n2 + 4) + "s", "");
                }
                System.err.format(" (default=%s)%n", string);
                string = null;
            } else {
                System.err.format("%n", new Object[0]);
            }
            voidParameter = voidParameter._next;
        }
        if (this._next != null) {
            this._next.list(n, n2);
        }
    }

    public void list() {
        this.list(79, 10);
    }

    public static enum ConfigurationObject {
        ConfGlobal,
        ConfServer,
        ConfViewer;

    }
}

