/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.mbox;

import gnu.inet.util.LineInputStream;
import gnu.mail.providers.mbox.MboxMessage;
import gnu.mail.providers.mbox.MboxOutputStream;
import gnu.mail.providers.mbox.MboxStore;
import gnu.mail.treeutil.StatusEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MboxFolder
extends Folder {
    static final DateFormat df = new SimpleDateFormat("EEE MMM d H:m:s yyyy");
    static final String GNU_MESSAGE_ID = "X-GNU-Message-Id";
    static final String FROM = "From ";
    final File file;
    final boolean inbox;
    MboxMessage[] messages;
    boolean open;
    boolean readOnly;
    Flags permanentFlags = null;

    protected MboxFolder(Store store, File file, boolean inbox) {
        super(store);
        this.file = file;
        this.inbox = inbox;
        this.open = false;
        this.readOnly = true;
        this.messages = new MboxMessage[0];
    }

    public String getName() {
        return this.inbox ? "INBOX" : this.file.getName();
    }

    public String getFullName() {
        File f;
        MboxStore s = (MboxStore)this.store;
        StringBuffer buf = new StringBuffer();
        for (f = this.file; f != null && !f.equals(s.root); f = f.getParentFile()) {
            if (buf.length() > 0) {
                buf.insert(0, File.separatorChar);
            }
            buf.insert(0, f.getName());
        }
        if (f == null && File.separatorChar == '\\') {
            return "\\\\\\" + this.file.getPath();
        }
        return buf.toString();
    }

    public URLName getURLName() throws MessagingException {
        String path = this.getFullName();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        path = MboxStore.encodeUrlPath(path);
        return new URLName("mbox", null, -1, path, null, null);
    }

    public int getType() throws MessagingException {
        if (this.file.exists()) {
            return this.file.isDirectory() ? 2 : 1;
        }
        return 0;
    }

    public boolean exists() throws MessagingException {
        return this.file.exists();
    }

    public boolean hasNewMessages() throws MessagingException {
        return this.getNewMessageCount() > 0;
    }

    public void open(int mode) throws MessagingException {
        String filename = this.file.getPath();
        if (mode == 2) {
            if (!this.file.canWrite()) {
                throw new MessagingException("Folder is read-only");
            }
            if (!this.acquireLock()) {
                throw new MessagingException("Unable to acquire lock: " + filename);
            }
            this.readOnly = false;
        }
        if (!this.file.canRead()) {
            throw new MessagingException("Can't read folder: " + filename);
        }
        LineInputStream in = null;
        try {
            MboxMessage m;
            ByteArrayInputStream bin;
            byte[] bytes;
            MboxStore mstore = (MboxStore)this.store;
            mstore.log("reading " + filename);
            ArrayList<MboxMessage> acc = new ArrayList<MboxMessage>(256);
            in = new LineInputStream(this.getInputStream());
            int count = 1;
            String fromLine = null;
            ByteArrayOutputStream buf = null;
            StatusEvent event = new StatusEvent(mstore, 0, "open");
            mstore.processStatusEvent(event);
            String line = in.readLine();
            while (line != null) {
                if (line.indexOf(FROM) == 0) {
                    if (buf != null) {
                        bytes = buf.toByteArray();
                        bin = new ByteArrayInputStream(bytes);
                        m = new MboxMessage(this, fromLine, bin, count++);
                        acc.add(m);
                        event = new StatusEvent(mstore, 1, "open", 1, -1, count - 1);
                        mstore.processStatusEvent(event);
                    }
                    fromLine = line;
                    buf = new ByteArrayOutputStream();
                } else if (buf != null) {
                    bytes = MboxFolder.decodeFrom(line).getBytes();
                    buf.write(bytes, 0, bytes.length);
                    buf.write(10);
                }
                line = in.readLine();
            }
            if (buf != null) {
                bytes = buf.toByteArray();
                bin = new ByteArrayInputStream(bytes);
                m = new MboxMessage(this, fromLine, bin, count++);
                acc.add(m);
                event = new StatusEvent(mstore, 1, "open", 1, -1, count - 1);
                mstore.processStatusEvent(event);
            }
            this.messages = new MboxMessage[acc.size()];
            acc.toArray(this.messages);
            buf = null;
            acc = null;
            event = new StatusEvent(mstore, 2, "open");
            mstore.processStatusEvent(event);
            this.open = true;
            this.notifyConnectionListeners(1);
        }
        catch (IOException e) {
            throw new MessagingException("Unable to open folder: " + filename, (Exception)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String decodeFrom(String line) {
        if (line != null) {
            int len = line.length();
            for (int i = 0; i < len - 5; ++i) {
                char c = line.charAt(i);
                if (i > 0 && c == 'F' && line.charAt(i + 1) == 'r' && line.charAt(i + 2) == 'o' && line.charAt(i + 3) == 'm' && line.charAt(i + 4) == ' ') {
                    return line.substring(1);
                }
                if (c != '>') break;
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean expunge) throws MessagingException {
        if (this.open) {
            if (expunge) {
                this.expunge();
            }
            if (!this.readOnly) {
                MboxStore mstore = (MboxStore)this.store;
                mstore.log("saving " + this.file.getAbsolutePath());
                MboxFolder mboxFolder = this;
                synchronized (mboxFolder) {
                    OutputStream os = null;
                    try {
                        os = this.getOutputStream();
                        BufferedOutputStream bos = new BufferedOutputStream(os);
                        MboxOutputStream mos = new MboxOutputStream(bos);
                        StatusEvent event = new StatusEvent(mstore, 0, "close");
                        mstore.processStatusEvent(event);
                        for (int i = 0; i < this.messages.length; ++i) {
                            String fromLine = this.fromLine(this.messages[i]);
                            bos.write(fromLine.getBytes());
                            bos.write(10);
                            bos.flush();
                            this.messages[i].writeTo(mos);
                            mos.flush();
                            event = new StatusEvent(mstore, 1, "close", 1, this.messages.length, i + 1);
                            mstore.processStatusEvent(event);
                        }
                        event = new StatusEvent(mstore, 2, "close");
                        mstore.processStatusEvent(event);
                    }
                    catch (IOException e) {
                        throw new MessagingException("I/O error writing mailbox", (Exception)e);
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                }
                if (!this.releaseLock()) {
                    mstore.log("unable to clear up lock file!");
                }
            }
            this.open = false;
            this.messages = new MboxMessage[0];
            this.notifyConnectionListeners(3);
        }
    }

    protected String fromLine(MboxMessage message) throws MessagingException {
        String fromLine = message.fromLine;
        if (fromLine == null) {
            StringBuffer buf = new StringBuffer(FROM);
            String from = "-";
            try {
                Address[] f = message.getFrom();
                if (f != null && f.length > 0) {
                    from = f[0] instanceof InternetAddress ? ((InternetAddress)f[0]).getAddress() : f[0].toString();
                }
            }
            catch (AddressException e) {
                // empty catch block
            }
            buf.append(from);
            buf.append(' ');
            Date date = message.getSentDate();
            if (date == null) {
                date = message.getReceivedDate();
            }
            if (date == null) {
                date = new Date();
            }
            buf.append(df.format(date));
            fromLine = buf.toString();
        }
        return fromLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] expunge() throws MessagingException {
        Message[] expunged;
        MboxFolder mboxFolder = this;
        synchronized (mboxFolder) {
            ArrayList<MboxMessage> elist = new ArrayList<MboxMessage>();
            if (this.open) {
                ArrayList<MboxMessage> mlist = new ArrayList<MboxMessage>();
                for (int i = 0; i < this.messages.length; ++i) {
                    Flags flags = this.messages[i].getFlags();
                    if (flags.contains(Flags.Flag.DELETED)) {
                        elist.add(this.messages[i]);
                        if (!(this.messages[i] instanceof MboxMessage)) continue;
                        this.messages[i].setExpunged(true);
                        continue;
                    }
                    mlist.add(this.messages[i]);
                }
                this.messages = new MboxMessage[mlist.size()];
                mlist.toArray(this.messages);
            }
            expunged = new Message[elist.size()];
            elist.toArray(expunged);
        }
        if (expunged.length > 0) {
            this.notifyMessageRemovedListeners(true, expunged);
        }
        return expunged;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Flags getPermanentFlags() {
        if (this.permanentFlags == null) {
            Flags flags = new Flags();
            flags.add(Flags.Flag.DELETED);
            flags.add(Flags.Flag.SEEN);
            flags.add(Flags.Flag.RECENT);
            this.permanentFlags = flags;
        }
        return this.permanentFlags;
    }

    public int getMessageCount() throws MessagingException {
        return this.messages.length;
    }

    public Message getMessage(int msgnum) throws MessagingException {
        int index = msgnum - 1;
        if (index < 0 || index >= this.messages.length) {
            throw new MessagingException("No such message: " + msgnum);
        }
        return this.messages[index];
    }

    public synchronized Message[] getMessages() throws MessagingException {
        Message[] m = new Message[this.messages.length];
        System.arraycopy(this.messages, 0, m, 0, this.messages.length);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendMessages(Message[] m) throws MessagingException {
        MboxMessage[] n;
        MboxFolder mboxFolder = this;
        synchronized (mboxFolder) {
            ArrayList<MboxMessage> appended = new ArrayList<MboxMessage>(m.length);
            int count = this.messages.length;
            for (int i = 0; i < m.length; ++i) {
                if (!(m[i] instanceof MimeMessage)) continue;
                MimeMessage mimem = (MimeMessage)m[i];
                MboxMessage mboxm = new MboxMessage(this, mimem, count++);
                if (mimem instanceof MboxMessage) {
                    mboxm.fromLine = ((MboxMessage)mimem).fromLine;
                }
                appended.add(mboxm);
            }
            n = new MboxMessage[appended.size()];
            if (n.length > 0) {
                appended.toArray(n);
                ArrayList<MboxMessage> acc = new ArrayList<MboxMessage>(this.messages.length + n.length);
                acc.addAll(Arrays.asList(this.messages));
                acc.addAll(Arrays.asList(n));
                this.messages = new MboxMessage[acc.size()];
                acc.toArray(this.messages);
                acc = null;
            }
        }
        if (n.length > 0) {
            this.notifyMessageAddedListeners((Message[])n);
        }
    }

    public Folder getParent() throws MessagingException {
        if (this.inbox) {
            return this.store.getDefaultFolder();
        }
        if (this.file.equals(((MboxStore)this.store).root)) {
            return null;
        }
        File parent = this.file.getParentFile();
        return new MboxFolder(this.store, parent, false);
    }

    public Folder[] list() throws MessagingException {
        if (this.getType() != 2) {
            throw new MessagingException("This folder can't contain subfolders");
        }
        try {
            File[] files = this.file.listFiles();
            Folder[] folders = new Folder[files.length];
            for (int i = 0; i < files.length; ++i) {
                folders[i] = new MboxFolder(this.store, files[i], false);
            }
            return folders;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public Folder[] list(String pattern) throws MessagingException {
        if (this.getType() != 2) {
            throw new MessagingException("This folder can't contain subfolders");
        }
        try {
            File[] files = this.file.listFiles(new MboxFilenameFilter(pattern));
            Folder[] folders = new Folder[files.length];
            for (int i = 0; i < files.length; ++i) {
                folders[i] = new MboxFolder(this.store, files[i], false);
            }
            return folders;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public char getSeparator() throws MessagingException {
        return File.separatorChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(int type) throws MessagingException {
        if (this.file.exists()) {
            throw new MessagingException("Folder already exists");
        }
        switch (type) {
            case 2: {
                try {
                    if (!this.file.mkdirs()) {
                        return false;
                    }
                    this.notifyFolderListeners(1);
                    return true;
                }
                catch (SecurityException e) {
                    throw new MessagingException("Access denied", (Exception)e);
                }
            }
            case 1: {
                try {
                    File parent = this.file.getParentFile();
                    if (!parent.exists() && !parent.mkdirs()) {
                        return false;
                    }
                    MboxFolder mboxFolder = this;
                    synchronized (mboxFolder) {
                        this.createNewFile(this.file);
                    }
                    this.notifyFolderListeners(1);
                    return true;
                }
                catch (IOException e) {
                    throw new MessagingException("I/O error writing mailbox", (Exception)e);
                }
                catch (SecurityException e) {
                    throw new MessagingException("Access denied", (Exception)e);
                }
            }
        }
        return false;
    }

    public boolean delete(boolean recurse) throws MessagingException {
        if (recurse) {
            try {
                if (this.file.isDirectory()) {
                    Folder[] folders = this.list();
                    for (int i = 0; i < folders.length; ++i) {
                        if (folders[i].delete(recurse)) continue;
                        return false;
                    }
                }
                if (!this.readOnly) {
                    this.releaseLock();
                }
                if (!this.file.delete()) {
                    return false;
                }
                this.notifyFolderListeners(2);
                return true;
            }
            catch (SecurityException e) {
                throw new MessagingException("Access denied", (Exception)e);
            }
        }
        try {
            Folder[] folders;
            if (this.file.isDirectory() && (folders = this.list()).length > 0) {
                return false;
            }
            if (!this.readOnly) {
                this.releaseLock();
            }
            if (!this.file.delete()) {
                return false;
            }
            this.notifyFolderListeners(2);
            return true;
        }
        catch (SecurityException e) {
            throw new MessagingException("Access denied", (Exception)e);
        }
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        if (folder instanceof MboxFolder) {
            File newfile = ((MboxFolder)folder).file;
            if (!this.file.renameTo(newfile)) {
                return false;
            }
            this.notifyFolderRenamedListeners(folder);
            return true;
        }
        throw new MessagingException("Target not an MboxFolder");
    }

    public Folder getFolder(String name) throws MessagingException {
        if (!this.file.isDirectory()) {
            throw new MessagingException("Folder cannot contain folders");
        }
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        File f = new File(this.file, name);
        return new MboxFolder(this.store, f, false);
    }

    private boolean isGzip() {
        return this.file.getName().toLowerCase().endsWith(".gz");
    }

    private InputStream getInputStream() throws IOException {
        InputStream in = new FileInputStream(this.file);
        if (this.isGzip()) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    private OutputStream getOutputStream() throws IOException {
        OutputStream out = new FileOutputStream(this.file);
        if (this.isGzip()) {
            out = new GZIPOutputStream(out);
        }
        return out;
    }

    public synchronized boolean acquireLock() {
        MboxStore mstore = (MboxStore)this.store;
        try {
            String filename = this.file.getPath();
            String lockFilename = filename + ".lock";
            File lock = new File(lockFilename);
            mstore.log("creating " + lock.getPath());
            if (lock.exists()) {
                return false;
            }
            this.createNewFile(lock);
            return true;
        }
        catch (IOException e) {
            mstore.log("I/O exception acquiring lock on " + this.file.getPath());
        }
        catch (SecurityException e) {
            mstore.log("Security exception acquiring lock on " + this.file.getPath());
        }
        return false;
    }

    private void createNewFile(File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        out.flush();
        out.close();
    }

    public synchronized boolean releaseLock() {
        MboxStore mstore = (MboxStore)this.store;
        try {
            String filename = this.file.getPath();
            String lockFilename = filename + ".lock";
            File lock = new File(lockFilename);
            mstore.log("removing " + lock.getPath());
            return !lock.exists() || lock.delete();
        }
        catch (SecurityException e) {
            mstore.log("Security exception releasing lock on " + this.file.getPath());
            return false;
        }
    }

    class MboxFilenameFilter
    implements FileFilter {
        String pattern;
        int asteriskIndex;
        int percentIndex;

        MboxFilenameFilter(String pattern) {
            this.pattern = pattern;
            this.asteriskIndex = pattern.indexOf(42);
            this.percentIndex = pattern.indexOf(37);
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName();
            if (this.asteriskIndex > -1) {
                String start = this.pattern.substring(0, this.asteriskIndex);
                String end = this.pattern.substring(this.asteriskIndex + 1, this.pattern.length());
                return name.startsWith(start) && name.endsWith(end);
            }
            if (this.percentIndex > -1) {
                String start = this.pattern.substring(0, this.percentIndex);
                String end = this.pattern.substring(this.percentIndex + 1, this.pattern.length());
                File parent = f.getParentFile();
                return parent != null && parent.equals(MboxFolder.this.file) && name.startsWith(start) && name.endsWith(end);
            }
            return name.equals(this.pattern);
        }
    }
}

