/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tomcat.util.ExceptionUtils;

public class ServerInfo {
    private static String serverInfo = null;
    private static String serverBuilt = null;
    private static String serverNumber = null;

    public static String getServerInfo() {
        return serverInfo;
    }

    public static String getServerBuilt() {
        return serverBuilt;
    }

    public static String getServerNumber() {
        return serverNumber;
    }

    public static void main(String[] args) {
        System.out.println("Server version: " + ServerInfo.getServerInfo());
        System.out.println("Server built:   " + ServerInfo.getServerBuilt());
        System.out.println("Server number:  " + ServerInfo.getServerNumber());
        System.out.println("OS Name:        " + System.getProperty("os.name"));
        System.out.println("OS Version:     " + System.getProperty("os.version"));
        System.out.println("Architecture:   " + System.getProperty("os.arch"));
        System.out.println("JVM Version:    " + System.getProperty("java.runtime.version"));
        System.out.println("JVM Vendor:     " + System.getProperty("java.vm.vendor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = ServerInfo.class.getResourceAsStream("/org/apache/catalina/util/ServerInfo.properties");
            props.load(is);
            serverInfo = props.getProperty("server.info");
            serverBuilt = props.getProperty("server.built");
            serverNumber = props.getProperty("server.number");
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (serverInfo == null) {
            serverInfo = "Apache Tomcat 7.0.x-dev";
        }
        if (serverBuilt == null) {
            serverBuilt = "unknown";
        }
        if (serverNumber == null) {
            serverNumber = "7.0.x";
        }
    }
}

