/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fil extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "Bengali";
        final String metaValue_bo = "Tibetan";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_hy = "Armenian";
        final String metaValue_ja = "Japanese";
        final String metaValue_ka = "Georgian";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_la = "Latin";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "luo", "Luo" },
            { "Zsym", "Mga Simbolo" },
            { "fil", "Filipino" },
            { "luy", "Luyia" },
            { "es_ES", "European Spanish" },
            { "teo", "Teso" },
            { "ab", "Abkhazian" },
            { "AC", "Acsencion island" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua and Barbuda" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "Amharic" },
            { "Arab", "Arabic" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "ar", "Arabe" },
            { "AS", "American Samoa" },
            { "as", "Assamese" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "sdh", "Katimugang Kurdish" },
            { "en_US", "Ingles (US)" },
            { "AX", "\u00c5land Islands" },
            { "ay", "Aymara" },
            { "AZ", "Azerbaijan" },
            { "az", "Azerbaijani" },
            { "BA", "Bosnia and Herzegovina" },
            { "ba", "Bashkir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "be", "Belarusian" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "Bulgarian" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bosnian" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "Mymr", "Myanmar" },
            { "BY", "Belarus" },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "ca", "Catalan" },
            { "CC", "Cocos (Keeling) Islands" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Congo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "Corsican" },
            { "CP", "Clipperton Island" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Czech" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "cv", "Chuvash" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "cy", "Welsh" },
            { "CZ", "Czech Republic" },
            { "da", "Danish" },
            { "pt_PT", "European Portuguese" },
            { "DE", "Germany" },
            { "de", "German" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republic" },
            { "bem", "Bemba" },
            { "dv", "Divehi" },
            { "es_419", "Latin American na Espanyol" },
            { "DZ", "Algeria" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "EA", "Ceuta and Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "EE", "Estonia" },
            { "ee", "Ewe" },
            { "EG", "Egypt" },
            { "EH", "Kanlurang Sahara" },
            { "ro_MD", "Moldavian" },
            { "el", metaValue_el },
            { "en", "Ingles" },
            { "eo", "Esperanto" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "es", "Espanyol" },
            { "ET", "Ethiopia" },
            { "et", "Estonian" },
            { "EU", "European Union" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "fa", "Persian" },
            { "Hans", "Pinasimple" },
            { "Hant", "Tradisyonal" },
            { "FI", "Finland" },
            { "fi", "Finnish" },
            { "FJ", "Fiji" },
            { "fj", "Fijian" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "bgn", "Kanlurang Balochi" },
            { "yue", "Cantonese" },
            { "FO", "Faroe Islands" },
            { "fo", "Faroese" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "fr", "French" },
            { "fy", "Kanlurang Frisian" },
            { "GA", "Gabon" },
            { "ga", "Irish" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "gd", "Scots Gaelic" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "gl", "Galician" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "und", "Hindi Kilalang Wika" },
            { "GR", "Greece" },
            { "GS", "South Georgia and the South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "Manx" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Central Kurdish" },
            { "zxx", "Walang nilalaman na ukol sa wika" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "de_AT", "Austrian German" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard Island and McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "hr", "Croatian" },
            { "agq", "Aghem" },
            { "gsw", "Swiss German" },
            { "HT", "Haiti" },
            { "ht", "Haitian" },
            { "HU", "Hungary" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "ia", "Interlingua" },
            { "IC", "Canary Island" },
            { "ID", "Indonesia" },
            { "id", "Indonesian" },
            { "IE", "Ireland" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "is", "Icelandic" },
            { "IT", "Italy" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "sma", "Katimugang Sami" },
            { "jv", "Javanese" },
            { "guz", "Gusii" },
            { "smj", "Lule Sami" },
            { "de_CH", "Swiss High German" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "sms", "Skolt Sami" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "kg", "Kongo" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Saint Kitts and Nevis" },
            { "fr_CA", "Canadian French" },
            { "ko", metaValue_ko },
            { "KP", "Hilagang Korea" },
            { "KR", "Timog Korea" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "fr_CH", "Swiss French" },
            { "KW", "Kuwait" },
            { "kw", "Cornish" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Islands" },
            { "ky", "Kirghiz" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Cyrillic" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "lb", "Luxembourgish" },
            { "LC", "Saint Lucia" },
            { "lg", "Ganda" },
            { "nds", "Low German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "lt", "Lithuanian" },
            { "LU", "Luxembourg" },
            { "lu", "Luba-Katanga" },
            { "LV", "Latvia" },
            { "lv", "Latvian" },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "mg", "Malagasy" },
            { "Thai", metaValue_th },
            { "MH", "Marshall Islands" },
            { "mi", "Maori" },
            { "MK", "Macedonia" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_mn },
            { "MN", "Mongolia" },
            { "MO", "Macau SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "mr", "Marathi" },
            { "MS", "Montserrat" },
            { "ms", "Malay" },
            { "MT", "Malta" },
            { "mt", "Maltese" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozambique" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibia" },
            { "nb", "Norwegian Bokmal" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "nd", "Hilagang Ndebele" },
            { "NE", "Niger" },
            { "ne", "Nepali" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "NO", "Norway" },
            { "no", "Norwegian" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "New Zealand" },
            { "kab", "Kabyle" },
            { "oc", "Occitan" },
            { "kam", "Kamba" },
            { "mer", "Meru" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetic" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "en_GB", "Ingles ng British" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Pilipinas" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "pl", "Polish" },
            { "PM", "Saint Pierre and Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "ps", "Pashto" },
            { "PT", "Portugal" },
            { "pt", "Portuges" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "pt_BR", "Portuges ng Brasil" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "QA", "Qatar" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "QO", "Outlying Oceania" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "001", "Mundo" },
            { "Ethi", "Ethiopic" },
            { "002", "Africa" },
            { "003", "Hilagang Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Timog Amerika" },
            { "009", "Oceania" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "RO", "Romania" },
            { "ro", "Romanian" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "ru", "Russian" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "en_AU", "Ingles ng Australya" },
            { "SA", "Saudi Arabia" },
            { "sa", "Sanskrit" },
            { "SB", "Solomon Islands" },
            { "twq", "Tasawaq" },
            { "011", "Kanlurang Africa" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "013", "Gitnang Amerika" },
            { "SE", "Sweden" },
            { "se", "Hilagang Sami" },
            { "014", "Silangang Africa" },
            { "015", "Hilagang Africa" },
            { "SG", "Singapore" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "sh", "Serbo-Croatian" },
            { "si", metaValue_si },
            { "017", "Gitnang Africa" },
            { "SI", "Slovenia" },
            { "018", "Katimugang Africa" },
            { "SJ", "Svalbard and Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovakia" },
            { "sk", "Slovak" },
            { "SL", "Sierra Leone" },
            { "sl", "Slovenian" },
            { "SM", "San Marino" },
            { "sm", "Samoan" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somalia" },
            { "so", "Somali" },
            { "arn", "Mapuche" },
            { "sq", "Albanian" },
            { "SR", "Suriname" },
            { "sr", "Serbian" },
            { "SS", "Timog Sudan" },
            { "ss", "Swati" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "st", "Southern Sotho" },
            { "su", "Sundanese" },
            { "SV", "El Salvador" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan de Cunha" },
            { "asa", "Asu" },
            { "021", "Northern America" },
            { "142", "Asya" },
            { "TC", "Turks and Caicos Islands" },
            { "143", "Gitnang Asya" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Kanlurang Asya" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "TH", "Thailand" },
            { "ti", "Tigrinya" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Ingles sa Canada" },
            { "029", "Carribbean" },
            { "TK", "Tokelau" },
            { "tk", "Turkmen" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "Tswana" },
            { "TO", "Tonga" },
            { "to", "Tongan" },
            { "dyo", "Jola-Fonyi" },
            { "TR", "Turkey" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "swb", "Comorian" },
            { "TT", "Trinidad and Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ty", "Tahitian" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Hindi Kilalang Script" },
            { "150", "Europe" },
            { "UA", "Ukraine" },
            { "030", "Silangang Asya" },
            { "151", "Silangang Europe" },
            { "154", "Hilagang Europe" },
            { "sw_CD", "Swahili (Congo)" },
            { "034", "Katimugang Asya" },
            { "155", "Kanlurang Europe" },
            { "035", "Timog-Silangang Asya" },
            { "UG", "Uganda" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Karaniwan" },
            { "039", "Katimugang Europe" },
            { "uk", "Ukranian" },
            { "Sinh", metaValue_si },
            { "UM", "U.S. Outlying Islands" },
            { "ur", "Urdu" },
            { "US", "Estados Unidos" },
            { "haw", "Hawaiian" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "uz", "Uzbek" },
            { "tzm", "Tamazight ng Gitnang Atlas" },
            { "VA", "Vatican City" },
            { "nds_NL", "Low Saxon" },
            { "VC", "Saint Vincent and the Grenadines" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "vi", "Vietnamese" },
            { "khq", "Koyra Chiini" },
            { "VN", "Vietnam" },
            { "quc", "K\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "Rwa" },
            { "gag", "Gagauz" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis and Futuna" },
            { "Grek", metaValue_el },
            { "057", "Rehiyon ng Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wo", "Wolof" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Modernong Karaniwang Arabe" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "Latn", metaValue_la },
            { "061", "Polynesia" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Hindi Nakasulat" },
            { "wbp", "Warlpiri" },
            { "moh", "Mohawk" },
            { "YE", "Yemen" },
            { "nqo", "N\u2019Ko" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "es_MX", "Espanyol ng Mehiko" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "South Africa" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Chinese" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Bopomofo" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "zu", "Zulu" },
            { "ZW", "Zimbabwe" },
            { "Geor", metaValue_ka },
            { "ZZ", "Hindi Kilalang Rehiyon" },
            { "nso", "Northern Sotho" },
            { "loz", "Lozi" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "zh_Hans", "Simplified Chinese" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "nus", "Nuer" },
            { "dav", "Taita" },
            { "lrc", "Hilagang Luri" },
            { "mua", "Mundang" },
            { "Khmr", metaValue_km },
            { "saq", "Samburu" },
            { "efi", "Efik" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
