/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.SpaceCs;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HAbstract;
import com.dickimawbooks.texparserlib.html.L2HAlignRow;
import com.dickimawbooks.texparserlib.html.L2HAmp;
import com.dickimawbooks.texparserlib.html.L2HAtMakeCaption;
import com.dickimawbooks.texparserlib.html.L2HBibItem;
import com.dickimawbooks.texparserlib.html.L2HBigOperator;
import com.dickimawbooks.texparserlib.html.L2HCaption;
import com.dickimawbooks.texparserlib.html.L2HContentsLine;
import com.dickimawbooks.texparserlib.html.L2HDescriptionItem;
import com.dickimawbooks.texparserlib.html.L2HDescriptionLabel;
import com.dickimawbooks.texparserlib.html.L2HEqnarray;
import com.dickimawbooks.texparserlib.html.L2HFloat;
import com.dickimawbooks.texparserlib.html.L2HFontFamilyDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontShapeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontSizeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontWeightDeclaration;
import com.dickimawbooks.texparserlib.html.L2HHyperlink;
import com.dickimawbooks.texparserlib.html.L2HHypertarget;
import com.dickimawbooks.texparserlib.html.L2HItem;
import com.dickimawbooks.texparserlib.html.L2HLetter;
import com.dickimawbooks.texparserlib.html.L2HMaketitle;
import com.dickimawbooks.texparserlib.html.L2HMathAlignRow;
import com.dickimawbooks.texparserlib.html.L2HMathDeclaration;
import com.dickimawbooks.texparserlib.html.L2HMathGroup;
import com.dickimawbooks.texparserlib.html.L2HMathSymbol;
import com.dickimawbooks.texparserlib.html.L2HMbox;
import com.dickimawbooks.texparserlib.html.L2HNoBreakSpace;
import com.dickimawbooks.texparserlib.html.L2HNormalFont;
import com.dickimawbooks.texparserlib.html.L2HNumberline;
import com.dickimawbooks.texparserlib.html.L2HOther;
import com.dickimawbooks.texparserlib.html.L2HPar;
import com.dickimawbooks.texparserlib.html.L2HSection;
import com.dickimawbooks.texparserlib.html.L2HTableOfContents;
import com.dickimawbooks.texparserlib.html.L2HTabular;
import com.dickimawbooks.texparserlib.html.L2HTextSubscript;
import com.dickimawbooks.texparserlib.html.L2HTextSuperscript;
import com.dickimawbooks.texparserlib.html.L2HTheBibliography;
import com.dickimawbooks.texparserlib.html.L2HUndefined;
import com.dickimawbooks.texparserlib.html.L2Hhfill;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.DescriptionDec;
import com.dickimawbooks.texparserlib.latex.FontFamilyDeclaration;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontSizeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontWeightDeclaration;
import com.dickimawbooks.texparserlib.latex.IndexLocation;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import java.util.Vector;

public class L2HConverter
extends LaTeXParserListener
implements Writeable {
    private Vector<String> styCs;
    private int indexLoc = 0;
    private Writer writer;
    private TeXApp texApp;
    private Path outPath;
    private Path basePath;
    private boolean useMathJax = true;
    private boolean unicodeScriptSupport = true;
    private String suffix = "html";
    private Vector<String> extraCssStyles = new Vector();
    private Stack<TrivListDec> trivListStack = new Stack();

    public L2HConverter(TeXApp teXApp) {
        this(teXApp, true, null, null, false);
    }

    public L2HConverter(TeXApp teXApp, Vector<AuxData> vector) {
        this(teXApp, null, vector);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, boolean bl2) {
        this(teXApp, bl, null, bl2);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, Vector<AuxData> vector) {
        this(teXApp, bl, null, vector);
    }

    public L2HConverter(TeXApp teXApp, File file) {
        this(teXApp, true, file);
    }

    public L2HConverter(TeXApp teXApp, File file, Vector<AuxData> vector) {
        this(teXApp, true, file, vector);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file) {
        this(teXApp, bl, file, null);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector) {
        this(teXApp, bl, file, vector, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, boolean bl2) {
        this(teXApp, bl, file, null, bl2);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2) {
        super(null, vector, bl2);
        this.texApp = teXApp;
        this.outPath = file == null ? null : file.toPath();
        this.styCs = new Vector();
        this.setWriteable(this);
        this.setUseMathJax(bl);
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.parser.putControlSequence(new GenericCommand("TeX", null, this.createString("TeX")));
        this.parser.putControlSequence(new GenericCommand("LaTeX", null, this.createString("LaTeX")));
        this.putControlSequence(new L2HHypertarget());
        this.putControlSequence(new L2HHyperlink());
        this.putControlSequence(new L2HAmp());
        this.putControlSequence(new L2HNoBreakSpace());
        this.putControlSequence(new SpaceCs("newblock"));
        this.putControlSequence(new L2HTheBibliography());
        this.putControlSequence(new L2HTableOfContents());
        this.putControlSequence(new L2HContentsLine());
        this.putControlSequence(new L2HBibItem());
        this.putControlSequence(new L2HMaketitle());
        this.putControlSequence(new L2HMbox());
        this.putControlSequence(new L2HTextSuperscript());
        this.putControlSequence(new L2HTextSubscript());
        this.putControlSequence(new L2HSection());
        this.putControlSequence(new L2HSection("subsection"));
        this.putControlSequence(new L2HSection("subsubsection"));
        this.putControlSequence(new L2HSection("paragraph"));
        this.putControlSequence(new L2HSection("subparagraph"));
        this.putControlSequence(new L2HSection("part"));
        this.putControlSequence(new L2HNumberline());
        this.putControlSequence(new L2HCaption());
        this.putControlSequence(new L2HAtMakeCaption());
        this.putControlSequence(new L2HFloat("figure"));
        this.putControlSequence(new L2HFloat("table"));
        this.putControlSequence(new L2HAbstract());
        this.putControlSequence(new L2HItem());
        this.putControlSequence(new L2HDescriptionLabel());
        this.putControlSequence(new L2HDescriptionItem());
        this.putControlSequence(new L2HMathDeclaration("math"));
        L2HMathDeclaration l2HMathDeclaration = new L2HMathDeclaration("(");
        this.parser.putControlSequence(l2HMathDeclaration);
        this.parser.putControlSequence(new EndDeclaration(")", l2HMathDeclaration));
        this.parser.putControlSequence(new L2HMathDeclaration("displaymath", 2));
        L2HMathDeclaration l2HMathDeclaration2 = new L2HMathDeclaration("[", 2);
        this.parser.putControlSequence(l2HMathDeclaration2);
        this.parser.putControlSequence(new EndDeclaration("]", l2HMathDeclaration2));
        this.parser.putControlSequence(new L2HMathDeclaration("equation", 2, true));
        this.parser.putControlSequence(new L2HTabular());
        this.parser.putControlSequence(new L2HTabular("array"));
        this.parser.putControlSequence(new L2HEqnarray());
        this.parser.putControlSequence(new L2HEqnarray("eqnarray*", false));
        this.putControlSequence(new L2Hhfill("hfill"));
        this.putControlSequence(new L2Hhfill("hfil"));
        this.putControlSequence(new L2HNormalFont());
        this.putControlSequence(new GenericCommand(true, "labelitemii", null, new HtmlTag("&#x2013;")));
        this.putControlSequence(new Relax("indent"));
        this.putControlSequence(new Relax("noindent"));
        try {
            LaTeXSty laTeXSty = this.getLaTeXSty(null, "hyperref");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new L2HBigOperator(string, n, n2);
    }

    @Override
    public BigOperator createBigOperator(String string, int n) {
        return new L2HBigOperator(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new L2HMathSymbol(string, n);
    }

    @Override
    public Letter getLetter(int n) {
        return new L2HLetter(n);
    }

    @Override
    public Other getOther(int n) {
        return new L2HOther(n);
    }

    @Override
    public Par getPar() {
        return new L2HPar();
    }

    @Override
    public MathGroup createMathGroup() {
        return new L2HMathGroup();
    }

    @Override
    public AlignRow createAlignRow(TeXObjectList teXObjectList) throws IOException {
        return new L2HAlignRow(this.getParser(), teXObjectList);
    }

    public AlignRow createMathAlignRow(TeXObjectList teXObjectList, boolean bl) throws IOException {
        return new L2HMathAlignRow(this.getParser(), teXObjectList, bl);
    }

    @Override
    public void cr(boolean bl, TeXObject teXObject) throws IOException {
        TeXSettings teXSettings = this.getParser().getSettings();
        if (teXSettings.getAlignMode() == 1) {
            teXSettings.startRow();
        } else {
            this.writeln("<br>\n");
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getStyle() {
        String string = "";
        if (this.parser != null) {
            TeXSettings teXSettings = this.parser.getSettings();
            switch (teXSettings.getCurrentFontFamily()) {
                case 0: {
                    string = "font-family: serif; ";
                    break;
                }
                case 1: {
                    string = "font-family: sans-serif; ";
                    break;
                }
                case 2: {
                    string = "font-family: monospace; ";
                }
            }
            switch (teXSettings.getCurrentFontShape()) {
                case 0: {
                    string = string + "font-style: normal; font-variant: normal; ";
                    break;
                }
                case 1: {
                    string = string + "font-style: italic; font-variant: normal; ";
                    break;
                }
                case 2: {
                    string = string + "font-style: oblique; font-variant: normal; ";
                    break;
                }
                case 3: {
                    int n;
                    TeXSettings teXSettings2 = teXSettings.getParent();
                    string = teXSettings2 != null ? ((n = teXSettings2.getFontShape()) == 0 || n == -1 ? (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ") : string + "font-style: normal; ") : (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ");
                    string = string + "font-variant: normal; ";
                    break;
                }
                case 4: {
                    string = string + "font-style: normal; font-variant: small-caps; ";
                }
            }
            switch (teXSettings.getCurrentFontWeight()) {
                case 0: {
                    string = string + "font-weight: normal; ";
                    break;
                }
                case 1: {
                    string = string + "font-weight: bold; ";
                }
            }
        }
        return string;
    }

    @Override
    public FontWeightDeclaration getFontWeightDeclaration(String string, int n) {
        return new L2HFontWeightDeclaration(string, n);
    }

    @Override
    public FontSizeDeclaration getFontSizeDeclaration(String string, int n) {
        return new L2HFontSizeDeclaration(string, n);
    }

    @Override
    public FontShapeDeclaration getFontShapeDeclaration(String string, int n) {
        return new L2HFontShapeDeclaration(string, n);
    }

    @Override
    public FontFamilyDeclaration getFontFamilyDeclaration(String string, int n) {
        return new L2HFontFamilyDeclaration(string, n);
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
        if (this.writer == null) {
            return;
        }
        if (n >= 32 && n <= 126) {
            this.writer.write((char)n);
        } else {
            this.writer.write("&#x" + Integer.toHexString(n) + ";");
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(string);
    }

    @Override
    public void write(char c) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.write("" + c);
    }

    @Override
    public void writeln(String string) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.write(String.format("%s%n", string));
        this.writer.flush();
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write("<a href=\"" + string + "\">");
        teXObject.process(this.parser);
        this.writer.write("</a>");
    }

    @Override
    public void substituting(String string, String string2) {
        this.texApp.substituting(this.parser, string, string2);
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    public boolean supportUnicodeScript() {
        return this.unicodeScriptSupport;
    }

    public void setSupportUnicodeScript(boolean bl) {
        this.unicodeScriptSupport = bl;
    }

    public boolean useMathJax() {
        return this.useMathJax;
    }

    public void setUseMathJax(boolean bl) {
        this.useMathJax = bl;
    }

    public String mathJaxStartInline() {
        return "\\(";
    }

    public String mathJaxEndInline() {
        return "\\)";
    }

    public String mathJaxStartDisplay() {
        return "\\[";
    }

    public String mathJaxEndDisplay() {
        return "\\]";
    }

    public void writeMathJaxHeader() throws IOException {
        this.setUseMathJax(true);
        this.writeable.writeln("<!-- MathJax -->");
        this.writeable.writeln("<script type=\"text/x-mathjax-config\">");
        this.writeable.writeln("MathJax.Hub.Config({tex2jax:");
        this.writeable.writeln("{");
        this.writeable.writeln(String.format("  inlineMath: [['%s','%s']],", this.mathJaxStartInline().replace("\\", "\\\\"), this.mathJaxEndInline().replace("\\", "\\\\")));
        this.writeable.writeln(String.format("  displayMath: [ ['%s','%s'] ]", this.mathJaxStartDisplay().replace("\\", "\\\\"), this.mathJaxEndDisplay().replace("\\", "\\\\")));
        this.writeable.writeln("}});");
        this.writeable.writeln("</script>");
        this.writeable.write("<script type=\"text/javascript\" src=");
        this.writeable.writeln("\"http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML\">");
        this.writeable.writeln("</script>");
    }

    protected void writeTabularCss(String string, String string2) throws IOException {
        String string3 = "";
        if (string != null) {
            string3 = string3 + string.charAt(0);
        }
        if (string2 != null) {
            string3 = string3 + string2.charAt(0);
        }
        this.writeln("table.tabular-" + string3);
        this.writeln("{");
        this.writeln("  display: inline-table;");
        this.writeln("  border-collapse: collapse;");
        if (string != null) {
            this.writeln("  align: " + string + ";");
        }
        if (string2 != null) {
            this.writeln("  vertical-align: " + string2 + ";");
        }
        this.writeln("}");
    }

    public void writeCssStyles() throws IOException {
        this.writeln("div.displaymath { display: block; text-align: center; }");
        this.writeln("span.eqno { float: right; }");
        this.writeln("div.table { display: block; text-align: center; }");
        this.writeTabularCss("center", "middle");
        this.writeTabularCss("center", "bottom");
        this.writeTabularCss("center", "top");
        this.writeTabularCss("left", "middle");
        this.writeTabularCss("left", "bottom");
        this.writeTabularCss("left", "top");
        this.writeTabularCss("right", "middle");
        this.writeTabularCss("right", "bottom");
        this.writeTabularCss("right", "top");
        this.writeTabularCss(null, "middle");
        this.writeTabularCss(null, "bottom");
        this.writeTabularCss(null, "top");
        this.writeTabularCss("left", null);
        this.writeTabularCss("center", null);
        this.writeTabularCss("right", null);
        this.writeln("div.figure { display: block; text-align: center; }");
        this.writeln("div.caption { display: block; text-align: center; }");
        this.writeln("div.marginpar { float: right; }");
        this.writeln("div.abstract { display: block; margin-right: 4em; margin-left: 4em;}");
        this.writeln("div.title { display: block; text-align: center; font-size: x-large;}");
        this.writeln("div.author { display: block; text-align: center; font-size: large;}");
        this.writeln("div.date { display: block; text-align: center; font-size: medium;}");
        this.writeln("div.bibliography { display: block; margin-left: 4em; }");
        this.writeln("div.bibitem { display: inline; float: left; text-indent: -3em; }");
        this.writeln("div.mbox { display: inline; }");
        this.writeln("span.numberline { display: inline-block; width: 3em; }");
        this.writeln("div.toc-part { padding-left: .5em; padding-bottom: 2ex; font-weight: bold; font-size: large;}");
        this.writeln("div.toc-chapter { padding-left: .5em; padding-bottom: 2ex; font-weight: bold; font-size: large;}");
        this.writeln("div.toc-section { padding-left: 1em; font-weight: bold;}");
        this.writeln("div.toc-subsection { padding-left: 1.5em; }");
        this.writeln("div.toc-subsubsection { padding-left: 2em; }");
        this.writeln("div.toc-paragraph { padding-left: 2.5em; }");
        this.writeln("div.toc-subparagraph { padding-left: 3em; }");
        this.writeln(".displaylist { display: block; list-style-type: none; }");
        this.writeln(".inlinelist { display: inline; }");
        this.writeln("span.inlineitem { margin-right: .5em; margin-left: .5em; }");
        this.writeln("span.numitem { float: left; margin-left: -3em; text-align: right; min-width: 2.5em; }");
        this.writeln("span.bulletitem { float: left; margin-left: -1em; }");
        this.writeln("span.descitem { font: normal; font-weight: bold; }");
        for (String string : this.extraCssStyles) {
            this.writeln(string);
        }
    }

    public void addCssStyle(String string) {
        this.extraCssStyles.add(string);
    }

    @Override
    public void documentclass(KeyValList keyValList, String string) throws IOException {
        super.documentclass(keyValList, string);
        this.writeable.writeln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        this.writeable.writeln("<html>");
        this.writeable.writeln("<head>");
        this.writeable.writeln("<style type=\"text/css\">");
        this.writeCssStyles();
        this.writeable.writeln("</style>");
        if (this.useMathJax()) {
            this.writeMathJaxHeader();
        }
    }

    @Override
    public void beginDocument() throws IOException {
        TeXObject teXObject = this.getParser().getControlSequence("@title");
        if (!(teXObject instanceof Undefined) && teXObject != null) {
            TeXObjectList teXObjectList;
            if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this.getParser())) != null) {
                teXObject = teXObjectList;
            }
            this.writeable.write("<title>");
            this.writeable.write(teXObject.toString(this.getParser()));
            this.writeable.writeln("</title>");
        }
        this.writeable.writeln("</head>");
        this.writeable.writeln("<body>");
        super.beginDocument();
        this.getParser().getSettings().setCharMapMode(1);
    }

    @Override
    public void endDocument() throws IOException {
        this.processFootnotes();
        this.writeable.writeln("</body>");
        this.writeable.writeln("</html>");
        super.endDocument();
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            if (teXObject != null || teXObject2 != null) {
                this.write("\\left");
                this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            }
            this.write("\\frac{");
            teXObject3.process(this.getParser());
            this.write("}{");
            teXObject4.process(this.getParser());
            this.write("}");
            if (teXObject != null || teXObject2 != null) {
                this.write("\\right");
                this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            }
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.write("<table style=\"display: inline;\"><tr style=\"border-bottom-style: solid;\"><td>");
        teXObject3.process(this.parser);
        this.write("</td></tr>");
        this.write("<tr><td>");
        teXObject4.process(this.parser);
        this.write("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            this.write(teXObject3.toString(this.getParser()));
            this.write("\\abovewithdelims ");
            this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            this.write(teXDimension.toString(this.getParser()));
            this.write(teXObject4.toString(this.getParser()));
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.write("<table><tr><td>");
        teXObject3.process(this.parser);
        this.write("</td></tr>");
        this.write("<tr><td>");
        teXObject4.process(this.parser);
        this.write("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.write("_{");
            teXObject.process(this.parser);
            this.write("}");
        } else {
            this.write("<sub>");
            teXObject.process(this.parser);
            this.write("</sub>");
        }
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.write("^{");
            teXObject.process(this.parser);
            this.write("}");
        } else {
            this.write("<sup>");
            teXObject.process(this.parser);
            this.write("</sup>");
        }
    }

    public void verb(String string, boolean bl, char c, String string2) throws IOException {
        this.write("<code style=\"white-space: pre;\">");
        super.verb(string, bl, c, string2);
        this.write("</code>");
    }

    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        this.write(String.format("<img src=\"%s\"/>", string));
    }

    protected void writeTransform(String string, String string2) throws IOException {
        this.writeTransform(string, string2, null);
    }

    protected void writeTransform(String string, String string2, String string3) throws IOException {
        this.write(String.format("<%s style=\"display: inline-block; transform: %s; -ms-transform: %s; -webkit-transform: %s;", string, string2, string2, string2));
        if (string3 != null) {
            this.write(String.format(" transform-origin: %s; -ms-transform-origin: %s; -webkit-transform-origin: %s;", string3, string3, string3));
        }
        this.write("\">");
    }

    public void transform(String string, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.writeTransform("div", string);
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.write("</div>");
    }

    @Override
    public void rotate(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void rotate(double d, double d2, double d3, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (d2 == 0.0 && d3 == 0.0) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%d%% %d%%", d2, d3)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void rotate(double d, TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXDimension == null && teXDimension == null) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            String string = "0%";
            String string2 = "0%";
            if (teXDimension != null) {
                string = String.format("%f%s", teXDimension.format());
            }
            if (teXDimension2 != null) {
                string2 = String.format("%f%s", teXDimension2.format());
            }
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%s %s", string, string2)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void scale(double d, double d2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scale(%f,%f)", d, d2), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleX(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleX(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleY(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleY(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void resize(TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.write("<div style=\"display: inline-block;");
        if (teXDimension != null) {
            this.write(String.format(" width: %s;", teXDimension.format()));
        }
        if (teXDimension2 != null) {
            this.write(String.format(" height: %s;", teXDimension2.format()));
        }
        this.write("\">");
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.write("</div>");
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file) throws IOException {
        this.getTeXApp().message(this.getTeXApp().getMessage("message.reading", file));
        this.basePath = file.getParentFile().toPath();
        if (this.writer == null) {
            Files.createDirectories(this.outPath, new FileAttribute[0]);
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string = string.substring(0, n);
            }
            File file2 = new File(this.outPath.toFile(), string + "." + this.getSuffix());
            this.getTeXApp().message(this.getTeXApp().getMessage("message.writing", file2));
            this.writer = new PrintWriter(file2);
        }
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new L2HUndefined(string);
    }

    @Override
    public void doFootnoteRule() throws IOException {
        this.writeln("<p><hr><p>");
    }

    @Override
    public IndexLocation createIndexLocation(String string) throws IOException {
        ++this.indexLoc;
        String string2 = String.format("idx-%s-%d", HtmlTag.getUriFragment(string), this.indexLoc);
        this.write(String.format("<a name=\"%s\"></a>", string2));
        return new IndexLocation(new HtmlTag(String.format("<a ref=\"#%s\">%d</a>", string2, this.indexLoc)));
    }

    @Override
    public void registerControlSequence(LaTeXSty laTeXSty, ControlSequence controlSequence) {
        this.styCs.add(controlSequence.getName());
        this.putControlSequence(controlSequence);
    }

    public boolean isStyControlSequence(ControlSequence controlSequence) {
        return this.styCs.contains(controlSequence.getName());
    }

    @Override
    public void startList(TrivListDec trivListDec) throws IOException {
        super.startList(trivListDec);
        if (trivListDec instanceof DescriptionDec) {
            this.write(String.format("%n<dl>%n", new Object[0]));
        } else if (trivListDec.isInLine()) {
            this.write("<div class=\"inlinelist\">");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.write(String.format("%n<ol class=\"displaylist\">%n", new Object[0]));
        } else {
            this.write(String.format("%n<ul class=\"displaylist\">%n", new Object[0]));
        }
    }

    @Override
    public void endList(TrivListDec trivListDec) throws IOException {
        if (trivListDec instanceof DescriptionDec) {
            this.write(String.format("%n</dl>%n", new Object[0]));
        } else if (trivListDec.isInLine()) {
            this.write("</div>");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.write(String.format("%n</ol>%n", new Object[0]));
        } else {
            this.write(String.format("%n</ul>%n", new Object[0]));
        }
        super.endList(trivListDec);
    }
}

