/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class MainUtil {
    MainUtil() {
    }

    public static void runMain(Object main, String[] args, String defCommand) throws Exception {
        if (args.length > 0) {
            String command = args[0];
            Method[] methods = main.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(command)) continue;
                String[] remaining = new String[args.length - 1];
                System.arraycopy(args, 1, remaining, 0, remaining.length);
                try {
                    method.invoke(main, MainUtil.bindParameters(method, remaining));
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IllegalArgumentException) {
                        System.err.println("Syntax error: " + cause.getMessage());
                    }
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw e;
                }
                return;
            }
        }
        if (defCommand != null) {
            MainUtil.runMain(main, new String[]{defCommand}, null);
        }
    }

    private static Object[] bindParameters(Method method, String[] args) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int len = parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            Class<?> type = parameterTypes[i];
            int remaining = Math.max(0, args.length - i);
            if (type.equals(String[].class)) {
                String[] rest = new String[remaining];
                System.arraycopy(args, 1, rest, 0, remaining);
                parameters.add(rest);
                continue;
            }
            if (remaining > 0) {
                parameters.add(MainUtil.convertParameter(args[i], parameterTypes[i]));
                continue;
            }
            parameters.add(null);
        }
        return parameters.toArray();
    }

    private static Object convertParameter(String arg, Class type) {
        if (type.equals(String.class)) {
            return arg;
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(arg, 10);
        }
        if (type.equals(File.class)) {
            return new File(arg);
        }
        throw new UnsupportedOperationException("Unknown type " + type);
    }
}

