/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.typedesc;

import com.sun.star.lib.uno.typedesc.MemberDescriptionHelper;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import java.lang.reflect.Method;

public final class MethodDescription {
    public static final int ID_QUERY_INTERFACE = 0;
    public static final int ID_ACQUIRE = 1;
    public static final int ID_RELEASE = 2;
    private final String name;
    private final int index;
    private final boolean oneway;
    private final TypeDescription[] inSignature;
    private final TypeDescription[] outSignature;
    private final TypeDescription returnSignature;
    private final Method method;

    MethodDescription(String name, int index, boolean oneway, TypeDescription[] inSignature, TypeDescription[] outSignature, TypeDescription returnSignature, Method method) {
        this.name = name;
        this.index = index;
        this.oneway = oneway;
        this.inSignature = inSignature;
        this.outSignature = outSignature;
        this.returnSignature = returnSignature;
        this.method = method;
    }

    MethodDescription(MethodDescription other, int index) {
        this(other.getName(), index, other.isOneway(), other.getInSignature(), other.getOutSignature(), other.getReturnSignature(), other.getMethod());
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnsigned() {
        return MemberDescriptionHelper.isUnsigned(this.returnSignature);
    }

    public boolean isAny() {
        return MemberDescriptionHelper.isAny(this.returnSignature);
    }

    public boolean isInterface() {
        return MemberDescriptionHelper.isInterface(this.returnSignature);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public boolean isConst() {
        return false;
    }

    public TypeDescription[] getInSignature() {
        return this.inSignature;
    }

    public TypeDescription[] getOutSignature() {
        return this.outSignature;
    }

    public TypeDescription getReturnSignature() {
        return this.returnSignature;
    }

    public Method getMethod() {
        return this.method;
    }
}

