/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;
    private SymmetryDesc desc;
    CIPChirality cip;

    public boolean isBio() {
        return this.isBio;
    }

    public SymmetryInterface setPointGroup(SymmetryInterface siLast, T3 center, T3[] atomset, BS bsAtoms, boolean haveVibration, float distanceTolerance, float linearTolerance, boolean localEnvOnly) {
        this.pointGroup = PointGroup.getPointGroup(siLast == null ? null : ((Symmetry)siLast).pointGroup, center, atomset, bsAtoms, haveVibration, distanceTolerance, linearTolerance, localEnvOnly);
        return this;
    }

    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    public Object getPointGroupInfo(int modelIndex, String drawID, boolean asInfo, String type, int index, float scale) {
        if (drawID == null && !asInfo && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (drawID == null && this.pointGroup.isDrawType(type, index, scale)) {
            return this.pointGroup.drawInfo;
        }
        if (asInfo && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(modelIndex, drawID, asInfo, type, index, scale);
    }

    public void setSpaceGroup(boolean doNormalize) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, doNormalize, false);
        }
    }

    public int addSpaceGroupOperation(String xyz, int opId) {
        return this.spaceGroup.addSymmetry(xyz, opId, false);
    }

    public int addBioMoleculeOperation(M4 mat, boolean isReverse) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((isReverse ? "!" : "") + "[[bio" + mat, 0, false);
    }

    public void setLattice(int latt) {
        this.spaceGroup.setLatticeParam(latt);
    }

    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroupFrom(SymmetryInterface symmetry) {
        this.spaceGroup = (SpaceGroup)symmetry.getSpaceGroup();
    }

    public boolean createSpaceGroup(int desiredSpaceGroupIndex, String name, Object data) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(desiredSpaceGroupIndex, name, data);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug((String)("using generated space group " + this.spaceGroup.dumpInfo(null)));
        }
        return this.spaceGroup != null;
    }

    public String getSpaceGroupInfoStr(String name, SymmetryInterface cellInfo) {
        return SpaceGroup.getInfo(this.spaceGroup, name, cellInfo);
    }

    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    public void setFinalOperations(String name, P3[] atoms, int iAtomFirst, int noSymmetryCount, boolean doNormalize, String filterSymop) {
        if (name != null && (name.startsWith("bio") || name.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = name;
        }
        if (filterSymop != null) {
            Lst lst = new Lst();
            lst.addLast((Object)this.spaceGroup.operations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!filterSymop.contains(" " + (i + 1) + " ")) continue;
                lst.addLast((Object)this.spaceGroup.operations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, name + " *(" + filterSymop.trim() + ")", lst);
        }
        this.spaceGroup.setFinalOperations(atoms, iAtomFirst, noSymmetryCount, doNormalize);
    }

    public M4 getSpaceGroupOperation(int i) {
        return this.spaceGroup == null || this.spaceGroup.operations == null || i >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[i] : this.spaceGroup.finalOperations[i]);
    }

    public String getSpaceGroupXyz(int i, boolean doNormalize) {
        return this.spaceGroup.getXyz(i, doNormalize);
    }

    public void newSpaceGroupPoint(int i, P3 atom1, P3 atom2, int transX, int transY, int transZ, M4 o) {
        if (o == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation op = this.spaceGroup.operations[i];
            if (!op.isFinalized) {
                op.doFinalize();
            }
            SymmetryOperation.newPoint(op, atom1, atom2, transX, transY, transZ);
            return;
        }
        SymmetryOperation.newPoint(o == null ? this.spaceGroup.finalOperations[i] : o, atom1, atom2, transX, transY, transZ);
    }

    public V3[] rotateAxes(int iop, V3[] axes, P3 ptTemp, M3 mTemp) {
        return iop == 0 ? axes : this.spaceGroup.finalOperations[iop].rotateAxes(axes, this.unitCell, ptTemp, mTemp);
    }

    public String getSpaceGroupOperationCode(int iOp) {
        return this.spaceGroup.operations[iOp].subsystemCode;
    }

    public void setTimeReversal(int op, int val) {
        this.spaceGroup.operations[op].setTimeReversal(val);
    }

    public float getSpinOp(int op) {
        return this.spaceGroup.operations[op].getMagneticOp();
    }

    public boolean addLatticeVectors(Lst<float[]> lattvecs) {
        return this.spaceGroup.addLatticeVectors(lattvecs);
    }

    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    public Matrix getOperationRsVs(int iop) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[iop].rsvs;
    }

    public int getSiteMultiplicity(P3 pt) {
        return this.spaceGroup.getSiteMultiplicity(pt, this.unitCell);
    }

    public String addOp(String code, Matrix rs, Matrix vs, Matrix sigma) {
        this.spaceGroup.isSSG = true;
        String s = SymmetryOperation.getXYZFromRsVs(rs, vs, false);
        int i = this.spaceGroup.addSymmetry(s, -1, true);
        this.spaceGroup.operations[i].setSigma(code, sigma);
        return s;
    }

    public String getMatrixFromString(String xyz, float[] rotTransMatrix, boolean allowScaling, int modDim) {
        return SymmetryOperation.getMatrixFromString(null, xyz, rotTransMatrix, allowScaling);
    }

    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    public void setSpaceGroupName(String name) {
        if (this.spaceGroup != null) {
            this.spaceGroup.name = name;
            if (this.spaceGroup.name.startsWith("HM:")) {
                this.spaceGroup.latticeType = this.spaceGroup.name.substring(3, 4);
            }
        }
    }

    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    public String getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? "P" : this.spaceGroup.latticeType);
    }

    public void setLatticeType(String type) {
        if (this.spaceGroup != null) {
            this.spaceGroup.latticeType = type;
        }
    }

    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.intlTableNumber);
    }

    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    public String getSymmetryInfoStr() {
        return this.symmetryInfo == null ? "" : this.symmetryInfo.infoStr;
    }

    public M4[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        return this.spaceGroup.finalOperations;
    }

    public boolean isSimple() {
        return this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null;
    }

    public SymmetryInterface setSymmetryInfo(int modelIndex, Map<String, Object> modelAuxiliaryInfo, float[] unitCellParams) {
        this.symmetryInfo = new SymmetryInfo();
        float[] params = this.symmetryInfo.setSymmetryInfo(modelAuxiliaryInfo, unitCellParams);
        if (params != null) {
            this.setUnitCell(params, modelAuxiliaryInfo.containsKey("jmolData"));
            this.unitCell.moreInfo = (Lst)modelAuxiliaryInfo.get("moreUnitCellInfo");
            modelAuxiliaryInfo.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)modelAuxiliaryInfo.get("unitCellOffset"));
            M3 matUnitCellOrientation = (M3)modelAuxiliaryInfo.get("matUnitCellOrientation");
            if (matUnitCellOrientation != null) {
                this.initializeOrientation(matUnitCellOrientation);
            }
            if (Logger.debugging) {
                Logger.debug((String)("symmetryInfos[" + modelIndex + "]:\n" + this.unitCell.dumpInfo(true)));
            }
        }
        return this;
    }

    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public boolean checkUnitCell(SymmetryInterface uc, P3 cell, P3 ptTemp, boolean isAbsolute) {
        uc.toFractional((T3)ptTemp, isAbsolute);
        return ptTemp.x >= cell.x - 1.0f - 0.02f && ptTemp.x <= cell.x + 0.02f && ptTemp.y >= cell.y - 1.0f - 0.02f && ptTemp.y <= cell.y + 0.02f && ptTemp.z >= cell.z - 1.0f - 0.02f && ptTemp.z <= cell.z + 0.02f;
    }

    public void setUnitCell(float[] unitCellParams, boolean setRelative) {
        this.unitCell = UnitCell.fromParams(unitCellParams, setRelative);
    }

    public boolean unitCellEquals(SymmetryInterface uc2) {
        return ((Symmetry)uc2).unitCell.isSameAs(this.unitCell);
    }

    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    public void initializeOrientation(M3 mat) {
        this.unitCell.initOrientation(mat);
    }

    public void unitize(T3 ptFrac) {
        this.unitCell.unitize(ptFrac);
    }

    public void toUnitCell(T3 pt, T3 offset) {
        this.unitCell.toUnitCell(pt, offset);
    }

    public P3 toSupercell(P3 fpt) {
        return this.unitCell.toSupercell(fpt);
    }

    public void toFractional(T3 pt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toFractional(pt, ignoreOffset);
        }
    }

    public void toFractionalM(M4 m) {
        if (!this.isBio) {
            this.unitCell.toFractionalM(m);
        }
    }

    public void toCartesian(T3 fpt, boolean ignoreOffset) {
        if (!this.isBio) {
            this.unitCell.toCartesian(fpt, ignoreOffset);
        }
    }

    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    public float[] getUnitCellAsArray(boolean vectorsOnly) {
        return this.unitCell.getUnitCellAsArray(vectorsOnly);
    }

    public Tensor getTensor(Viewer vwr, float[] parBorU) {
        if (parBorU == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromParams(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true);
        }
        return this.unitCell.getTensor(vwr, parBorU);
    }

    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    public void setOffsetPt(T3 pt) {
        this.unitCell.setOffset(pt);
    }

    public void setOffset(int nnn) {
        P3 pt = new P3();
        SimpleUnitCell.ijkToPoint3f((int)nnn, (P3)pt, (int)0);
        this.unitCell.setOffset((T3)pt);
    }

    public P3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    public P3[] getCanonicalCopy(float scale, boolean withOffset) {
        return this.unitCell.getCanonicalCopy(scale, withOffset);
    }

    public float getUnitCellInfoType(int infoType) {
        return this.unitCell.getInfo(infoType);
    }

    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    public void setMinMaxLatticeParameters(P3i minXYZ, P3i maxXYZ) {
        this.unitCell.setMinMaxLatticeParameters(minXYZ, maxXYZ);
    }

    public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
        return this.unitCell.checkDistance(f1, f2, distance, dx, iRange, jRange, kRange, ptOffset);
    }

    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    public SymmetryInterface getUnitCell(T3[] oabc, boolean setRelative, String name) {
        if (oabc == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(oabc, setRelative);
        if (name != null) {
            this.unitCell.name = name;
        }
        return this;
    }

    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    public BS notInCentroid(ModelSet modelSet, BS bsAtoms, int[] minmax) {
        try {
            BS bsDelete = new BS();
            int iAtom0 = bsAtoms.nextSetBit(0);
            JmolMolecule[] molecules = modelSet.getMolecules();
            int moleculeCount = molecules.length;
            Atom[] atoms = modelSet.at;
            boolean isOneMolecule = molecules[moleculeCount - 1].firstAtomIndex == modelSet.am[atoms[iAtom0].mi].firstAtomIndex;
            P3 center = new P3();
            boolean centroidPacked = minmax[6] == 1;
            int i = moleculeCount;
            block2: while (--i >= 0 && bsAtoms.get(molecules[i].firstAtomIndex)) {
                BS bs = molecules[i].atomList;
                center.set(0.0f, 0.0f, 0.0f);
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (isOneMolecule || centroidPacked) {
                        center.setT((T3)atoms[j]);
                        if (this.isNotCentroid(center, 1, minmax, centroidPacked)) {
                            if (isOneMolecule) {
                                bsDelete.set(j);
                            }
                        } else if (!isOneMolecule) {
                            continue block2;
                        }
                    } else {
                        center.add((T3)atoms[j]);
                        ++n;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                if (!centroidPacked && (n <= 0 || !this.isNotCentroid(center, n, minmax, false))) continue;
                bsDelete.or(bs);
            }
            return bsDelete;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 center, int n, int[] minmax, boolean centroidPacked) {
        center.scale(1.0f / (float)n);
        this.toFractional((T3)center, false);
        if (centroidPacked) {
            return center.x + 5.0E-6f <= (float)minmax[0] || center.x - 5.0E-6f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y - 5.0E-6f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z - 5.0E-6f > (float)minmax[5];
        }
        return center.x + 5.0E-6f <= (float)minmax[0] || center.x + 5.0E-5f > (float)minmax[3] || center.y + 5.0E-6f <= (float)minmax[1] || center.y + 5.0E-5f > (float)minmax[4] || center.z + 5.0E-6f <= (float)minmax[2] || center.z + 5.0E-5f > (float)minmax[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface((String)"org.jmol.symmetry.SymmetryDesc", (Viewer)modelSet.vwr, (String)"eval")) : this.desc).set(modelSet);
    }

    public Object getSymmetryInfoAtom(ModelSet modelSet, int iatom, String xyz, int op, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth) {
        return this.getDesc(modelSet).getSymopInfo(iatom, xyz, op, pt, pt2, id, type, scaleFactor, nth);
    }

    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String sgName, int modelIndex) {
        Map info;
        if (sgName == null && (info = modelSet.getModelAuxiliaryInfo(modelSet.vwr.am.cmi)) != null) {
            sgName = (String)info.get("spaceGroup");
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, modelIndex, sgName, 0, null, null, null, 0.0f, -1);
    }

    public String fcoord(T3 p) {
        return SymmetryOperation.fcoord(p);
    }

    public T3[] getV0abc(Object def) {
        return this.unitCell == null ? null : this.unitCell.getV0abc(def);
    }

    public Quat getQuaternionRotation(String abc) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(abc);
    }

    public T3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    public boolean getState(SB commands) {
        P3 pt = this.getFractionalOffset();
        boolean loadUC = false;
        if (pt != null && (pt.x != 0.0f || pt.y != 0.0f || pt.z != 0.0f)) {
            commands.append("; set unitcell ").append(Escape.eP((T3)pt));
            loadUC = true;
        }
        if ((pt = this.getUnitCellMultiplier()) != null) {
            commands.append("; set unitcell ").append(Escape.eP((T3)pt));
            loadUC = true;
        }
        return loadUC;
    }

    public AtomIndexIterator getIterator(Viewer vwr, Atom atom, Atom[] atoms, BS bsAtoms, float radius) {
        return ((UnitCellIterator)Interface.getInterface((String)"org.jmol.symmetry.UnitCellIterator", (Viewer)vwr, (String)"script")).set(this, atom, atoms, bsAtoms, radius);
    }

    public boolean toFromPrimitive(boolean toPrimitive, char type, T3[] oabc) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(oabc, false);
        }
        return this.unitCell.toFromPrimitive(toPrimitive, type, oabc);
    }

    public Lst<P3> generateCrystalClass(P3 pt0) {
        M4[] ops = this.getSymmetryOperations();
        Lst lst = new Lst();
        boolean isRandom = pt0 == null;
        float rand1 = 0.0f;
        float rand2 = 0.0f;
        float rand3 = 0.0f;
        if (isRandom) {
            rand1 = (float)Math.E;
            rand2 = (float)Math.PI;
            rand3 = (float)Math.log10(2000.0);
            pt0 = P3.new3((float)(rand1 + 1.0f), (float)(rand2 + 2.0f), (float)(rand3 + 3.0f));
        } else {
            pt0 = P3.newP((T3)pt0);
        }
        if (ops == null || this.unitCell == null) {
            lst.addLast((Object)pt0);
        } else {
            this.unitCell.toFractional((T3)pt0, true);
            P3 pt1 = null;
            P3 pt2 = null;
            P3 pt3 = null;
            if (isRandom) {
                pt1 = P3.new3((float)(rand2 + 4.0f), (float)(rand3 + 5.0f), (float)(rand1 + 6.0f));
                this.unitCell.toFractional((T3)pt1, true);
                pt2 = P3.new3((float)(rand3 + 7.0f), (float)(rand1 + 8.0f), (float)(rand2 + 9.0f));
                this.unitCell.toFractional((T3)pt2, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator iter = bspt.allocateCubeIterator();
            P3 pt = new P3();
            int i = ops.length;
            while (--i >= 0) {
                ops[i].rotate2((T3)pt0, (T3)pt);
                iter.initialize((T3)pt, 0.001f, false);
                if (iter.hasMoreElements()) continue;
                P3 ptNew = P3.newP((T3)pt);
                lst.addLast((Object)ptNew);
                bspt.addTuple((T3)ptNew);
                if (!isRandom) continue;
                if (pt2 != null) {
                    pt3 = new P3();
                    ops[i].rotate2((T3)pt2, (T3)pt3);
                    lst.addLast((Object)pt3);
                }
                if (pt1 == null) continue;
                pt3 = new P3();
                ops[i].rotate2((T3)pt1, (T3)pt3);
                lst.addLast((Object)pt3);
            }
            int j = lst.size();
            while (--j >= 0) {
                this.unitCell.toCartesian((T3)lst.get(j), true);
            }
        }
        return lst;
    }

    public void calculateCIPChiralityForAtoms(Viewer vwr, BS bsAtoms) {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        String dataClass = vwr.getBoolean(603979962) ? "CIPData" : "CIPDataTracker";
        CIPData data = ((CIPData)Interface.getInterface((String)("org.jmol.symmetry." + dataClass), (Viewer)vwr, (String)"script")).set(vwr, bsAtoms);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
    }

    public String[] calculateCIPChiralityForSmiles(Viewer vwr, String smiles) throws Exception {
        vwr.setCursor(3);
        CIPChirality cip = this.getCIPChirality(vwr);
        CIPDataSmiles data = ((CIPDataSmiles)Interface.getInterface((String)"org.jmol.symmetry.CIPDataSmiles", (Viewer)vwr, (String)"script")).setAtomsForSmiles(vwr, smiles);
        cip.getChiralityForAtoms(data);
        vwr.setCursor(0);
        return data.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer vwr) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface((String)"org.jmol.symmetry.CIPChirality", (Viewer)vwr, (String)"script")) : this.cip;
    }

    public Object getConventionalUnitCell(String latticeType) {
        return this.unitCell == null || latticeType == null ? null : this.unitCell.getConventionalUnitCell(latticeType);
    }
}

