/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class RelativeDragEvent
implements Event {
    private float _changeInX;
    private float _changeInY;
    private static final long serialVersionUID = 7743528698376037703L;

    public RelativeDragEvent() {
        this._changeInX = 0.0f;
        this._changeInY = 0.0f;
    }

    public RelativeDragEvent(float changeInX, float changeInY) {
        this._changeInX = changeInX;
        this._changeInY = changeInY;
    }

    public float getChangeInX() {
        return this._changeInX;
    }

    public float getChangeInY() {
        return this._changeInY;
    }

    public RelativeDragEvent(byte[] data) {
        if (data.length < 8) {
            System.err.println("Error constructing Drag Event.");
            this._changeInX = 0.0f;
            this._changeInY = 0.0f;
        } else {
            this._changeInX = Converter.byteArrayToFloat(data, 0);
            this._changeInY = Converter.byteArrayToFloat(data, 4);
        }
    }

    @Override
    public int getEventType() {
        return 7;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[12];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this._changeInX);
        Converter.floatToByteArray(data, 8, this._changeInY);
        return data;
    }
}

