/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Rectangle;

public class EnvelopeBuilder
extends ShapeBuilder<Rectangle, EnvelopeBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.ENVELOPE;
    private final Coordinate topLeft;
    private final Coordinate bottomRight;

    public EnvelopeBuilder(Coordinate topLeft, Coordinate bottomRight) {
        Objects.requireNonNull(topLeft, "topLeft of envelope cannot be null");
        Objects.requireNonNull(bottomRight, "bottomRight of envelope cannot be null");
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public EnvelopeBuilder(StreamInput in) throws IOException {
        this.topLeft = EnvelopeBuilder.readFromStream(in);
        this.bottomRight = EnvelopeBuilder.readFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        EnvelopeBuilder.writeCoordinateTo(this.topLeft, out);
        EnvelopeBuilder.writeCoordinateTo(this.bottomRight, out);
    }

    public Coordinate topLeft() {
        return this.topLeft;
    }

    public Coordinate bottomRight() {
        return this.bottomRight;
    }

    @Override
    protected StringBuilder contentToWKT() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.topLeft.x);
        sb.append(",");
        sb.append(" ");
        sb.append(this.bottomRight.x);
        sb.append(",");
        sb.append(" ");
        sb.append(this.topLeft.y);
        sb.append(",");
        sb.append(" ");
        sb.append(this.bottomRight.y);
        sb.append(")");
        return sb;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
        EnvelopeBuilder.toXContent(builder, this.topLeft);
        EnvelopeBuilder.toXContent(builder, this.bottomRight);
        builder.endArray();
        return builder.endObject();
    }

    @Override
    public Rectangle build() {
        return SPATIAL_CONTEXT.makeRectangle(this.topLeft.x, this.bottomRight.x, this.bottomRight.y, this.topLeft.y);
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnvelopeBuilder other = (EnvelopeBuilder)obj;
        return Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.bottomRight, other.bottomRight);
    }
}

