/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

final class GrokMatchGroup {
    private static final String DEFAULT_TYPE = "string";
    private final String patternName;
    private final String fieldName;
    private final String type;
    private final String groupValue;

    GrokMatchGroup(String groupName, String groupValue) {
        String[] parts = groupName.split(":");
        this.patternName = parts[0];
        this.fieldName = parts.length >= 2 ? parts[1] : null;
        this.type = parts.length == 3 ? parts[2] : DEFAULT_TYPE;
        this.groupValue = groupValue;
    }

    public String getName() {
        return this.fieldName == null ? this.patternName : this.fieldName;
    }

    public Object getValue() {
        if (this.groupValue == null) {
            return null;
        }
        switch (this.type) {
            case "int": {
                return Integer.parseInt(this.groupValue);
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(this.groupValue));
            }
        }
        return this.groupValue;
    }
}

