/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInference;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private SyntheticScopes syntheticScopes;
    private NewResolutionOldInference newResolutionOldInference;
    private PSICallResolver PSICallResolver;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);

    public CallResolver(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setResolutionOldInference(@NotNull NewResolutionOldInference newResolutionOldInference) {
        this.newResolutionOldInference = newResolutionOldInference;
    }

    @Inject
    public void setPSICallResolver(@NotNull PSICallResolver PSICallResolver2) {
        this.PSICallResolver = PSICallResolver2;
    }

    @Inject
    public void setSyntheticScopes(@NotNull SyntheticScopes syntheticScopes) {
        this.syntheticScopes = syntheticScopes;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        KtExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        return this.computeTasksAndResolveCall(context, referencedName, nameExpression, NewResolutionOldInference.ResolutionKind.Variable.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression, @NotNull BasicCallResolutionContext context) {
        return this.computeTasksAndResolveCall(context, nameExpression.getReferencedNameAsName(), nameExpression, NewResolutionOldInference.ResolutionKind.CallableReference.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull KtReferenceExpression functionReference, @NotNull Name name) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        return this.computeTasksAndResolveCall(callResolutionContext, name, functionReference, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull Name name, @NotNull TracingStrategy tracing) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        return this.computeTasksAndResolveCall(callResolutionContext, name, tracing, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        return this.computeTasksAndResolveCall(context, OperatorNameConventions.INVOKE, tracing, NewResolutionOldInference.ResolutionKind.Invoke.INSTANCE);
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull KtReferenceExpression referenceExpression, @NotNull NewResolutionOldInference.ResolutionKind<D> kind) {
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context.call);
        return this.computeTasksAndResolveCall(context, name, tracing, kind);
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull NewResolutionOldInference.ResolutionKind<D> kind) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(kind, name, null);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates2) {
        return this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, TracingStrategyImpl.create(referenceExpression, context.call));
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull Collection<ResolutionCandidate<D>> candidates2, @NotNull TracingStrategy tracing) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name) {
        return this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCollectionLiteralCallWithGivenDescriptor(@NotNull ExpressionTypingContext context, @NotNull KtCollectionLiteralExpression expression2, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List candidates2 = CollectionsKt.map(functionDescriptors2, descriptor2 -> ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, candidates2, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveEqualsCallWithGivenDescriptors(@NotNull ExpressionTypingContext context, @NotNull KtReferenceExpression expression2, @NotNull ExpressionReceiver receiver, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List resolutionCandidates = CollectionsKt.map(functionDescriptors2, descriptor2 -> ResolutionCandidate.create(call2, descriptor2, receiver, ExplicitReceiverKind.DISPATCH_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, resolutionCandidates, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull Call call2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        return this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope, call2, expectedType2, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, isAnnotationContext, this.languageVersionSettings));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name = callType == Call.CallType.ARRAY_GET_METHOD ? OperatorNameConventions.GET : OperatorNameConventions.SET;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)context.call.getCallElement();
            return this.computeTasksAndResolveCall(context, name, arrayAccessExpression, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)calleeExpression;
            return this.computeTasksAndResolveCall(context, expression2.getReferencedNameAsName(), expression2, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        }
        if (calleeExpression instanceof KtConstructorCalleeExpression) {
            return this.resolveCallForConstructor(context, (KtConstructorCalleeExpression)calleeExpression);
        }
        if (calleeExpression instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context.call.getCallElement();
            DeclarationDescriptor container2 = context.scope.getOwnerDescriptor();
            assert (container2 instanceof ConstructorDescriptor) : "Trying to resolve JetConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container2;
            return this.resolveConstructorDelegationCall(context, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression, (ClassConstructorDescriptor)container2);
        }
        if (calleeExpression == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        SimpleType expectedType2 = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression).getValueParameters().size();
            ArrayList<SimpleType> parameterTypes = new ArrayList<SimpleType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType2 = FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, parameterTypes, null, context.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, expectedType2, context.dataFlowInfo, context.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression, calleeType, context.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call2 = new CallTransformer.CallForImplicitInvoke(context.call.getExplicitReceiver(), expressionReceiver, context.call, false);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call2, calleeType);
        return this.resolveCallForInvoke(context.replaceCall(call2), tracingForInvoke);
    }

    private OverloadResolutionResults<ConstructorDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorCalleeExpression expression2) {
        assert (context.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context.call.getCallElement().getText();
        context.trace.record(BindingContext.LEXICAL_SCOPE, context.call.getCallElement(), context.scope);
        KtSimpleNameExpression functionReference = expression2.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        if (KotlinTypeKt.isError(constructedType)) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context.trace.report(Errors.NOT_A_CLASS.on(expression2));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        return this.resolveConstructorCall(context, functionReference, constructedType);
    }

    @NotNull
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression functionReference, @NotNull KotlinType constructedType) {
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(constructedType, context, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        return this.computeTasksFromCandidatesAndResolvedCall(context, functionReference, candidates2);
    }

    @Nullable
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call2) {
        BasicCallResolutionContext context = BasicCallResolutionContext.create(trace, scope, CallMaker.makeCall(null, null, call2), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false, this.languageVersionSettings);
        if (call2.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        if (constructorDescriptor.getConstructedClass().getKind() == ClassKind.ENUM_CLASS && call2.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context, call2, call2.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorDelegationCall call2, @NotNull KtConstructorDelegationReferenceExpression calleeExpression, @NotNull ClassConstructorDescriptor calleeConstructor) {
        KtElementImpl reportOn;
        context.trace.record(BindingContext.LEXICAL_SCOPE, call2, context.scope);
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ClassConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((KtConstructorDelegationCall)calleeExpression.getParent()));
            }
            if (call2.isImplicit()) {
                return OverloadResolutionResultsImpl.nameNotFound();
            }
        }
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType superType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(superType, context, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        TracingStrategy tracing = call2.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call2, context.call) : TracingStrategyImpl.create(calleeExpression, context.call);
        KtElementImpl ktElementImpl = reportOn = call2.isImplicit() ? call2 : calleeExpression;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            return this.checkArgumentTypesAndFail(context);
        }
        return this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, tracing);
    }

    @NotNull
    private static Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> prepareCandidatesAndContextForConstructorCall(@NotNull KotlinType superType, @NotNull BasicCallResolutionContext context, @NotNull SyntheticScopes syntheticScopes) {
        if (!(superType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return new Pair(Collections.emptyList(), (Object)context);
        }
        boolean anyConstructorHasDeclaredTypeParameters = CallResolver.anyConstructorHasDeclaredTypeParameters(superType.getConstructor().getDeclarationDescriptor());
        if (anyConstructorHasDeclaredTypeParameters) {
            context = (BasicCallResolutionContext)context.replaceExpectedType(superType);
        }
        List<ResolutionCandidate<ConstructorDescriptor>> candidates2 = CallResolverUtilKt.createResolutionCandidatesForConstructors(context.scope, context.call, superType, !anyConstructorHasDeclaredTypeParameters, syntheticScopes);
        return new Pair(candidates2, (Object)context);
    }

    private static boolean anyConstructorHasDeclaredTypeParameters(@Nullable ClassifierDescriptor classDescriptor) {
        if (!(classDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        for (ConstructorDescriptor constructorDescriptor : ((ClassDescriptor)classDescriptor).getConstructors()) {
            if (constructorDescriptor.getTypeParameters().size() <= constructorDescriptor.getContainingDeclaration().getDeclaredTypeParameters().size()) continue;
            return true;
        }
        return false;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context, @NotNull ResolutionCandidate<FunctionDescriptor> candidate2, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
            Set<ResolutionCandidate> candidates2 = Collections.singleton(candidate2);
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, resolutionTask, tracing);
        });
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        Call call2 = context.call;
        tracing.bindCall(context.trace, call2);
        boolean newInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        if (newInferenceEnabled && resolutionTask.resolutionKind.getKotlinCallKind() != KotlinCallKind.UNSUPPORTED) {
            assert (resolutionTask.name != null);
            return this.PSICallResolver.runResolutionAndInference(context, resolutionTask.name, resolutionTask.resolutionKind, tracing);
        }
        if (newInferenceEnabled && resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates) {
            assert (resolutionTask.givenCandidates != null);
            return this.PSICallResolver.runResolutionAndInferenceForGivenCandidates(context, resolutionTask.givenCandidates, tracing);
        }
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", call2);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<D> results = this.doResolveCall(newContext, resolutionTask, tracing);
        if (CoroutineInferenceUtilKt.isResultWithCoroutineInference(results)) {
            traceToResolveCall.commit();
            return results;
        }
        DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (CallResolverUtilKt.isInvokeCallOnVariable(context.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        Call call2 = context.call;
        if (CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call, BindingTraceFilter.Companion.getACCEPT_ALL(), false);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.record(call2, results, context, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        List<KtTypeProjection> typeArguments2 = context.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments2) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context.trace, null, this.languageVersionSettings);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (!(resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates)) {
            assert (resolutionTask.name != null);
            return this.newResolutionOldInference.runResolution(context, resolutionTask.name, resolutionTask.resolutionKind, tracing);
        }
        assert (resolutionTask.givenCandidates != null);
        return this.newResolutionOldInference.runResolutionForGivenCandidates(context, tracing, resolutionTask.givenCandidates);
    }

    private static class ResolutionTask<D extends CallableDescriptor> {
        @Nullable
        final Name name;
        @Nullable
        final Collection<ResolutionCandidate<D>> givenCandidates;
        @NotNull
        final NewResolutionOldInference.ResolutionKind<D> resolutionKind;

        private ResolutionTask(@NotNull NewResolutionOldInference.ResolutionKind<D> kind, @Nullable Name name, @Nullable Collection<ResolutionCandidate<D>> candidates2) {
            this.name = name;
            this.givenCandidates = candidates2;
            this.resolutionKind = kind;
        }
    }
}

