/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPlatformPathLocator;
import org.gradle.platform.base.Platform;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultSwiftXCTestSuite testComponent = this.createTestSuite((Project)project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                testComponent.getOperatingSystems().lockNow();
                Set operatingSystemFamilies = (Set)testComponent.getOperatingSystems().get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the application.");
                }
                Usage runtimeUsage = (Usage)XCTestConventionPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                BuildType buildType = BuildType.DEBUG;
                for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                    String operatingSystemSuffix = XCTestConventionPlugin.this.createDimensionSuffix((Named)operatingSystem, operatingSystemFamilies);
                    String variantName = buildType.getName() + operatingSystemSuffix;
                    Provider group = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider version = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal runtimeAttributes = XCTestConventionPlugin.this.attributesFactory.mutable();
                    runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                    runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                    runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                    NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider)testComponent.getModule(), group, version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, null, (UsageContext)new DefaultUsageContext(variantName + "-runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                    if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) continue;
                    ToolChainSelector.Result result = XCTestConventionPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                    DefaultSwiftXCTestBinary binary = ((SwiftPlatform)result.getTargetPlatform()).getOperatingSystem().isMacOsX() ? (DefaultSwiftXCTestBinary)((Object)testComponent.addBundle("executable", variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider())) : (DefaultSwiftXCTestBinary)((Object)testComponent.addExecutable("executable", variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider()));
                    testComponent.getTestBinary().set((Object)binary);
                    ProductionSwiftComponent mainComponent = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).findByName("main");
                    if (mainComponent == null) continue;
                    testComponent.getTestedComponent().set((Object)mainComponent);
                    testComponent.getImplementationDependencies().extendsFrom(new Configuration[]{mainComponent.getImplementationDependencies()});
                    project.getDependencies().add(binary.getImportPathConfiguration().getName(), (Object)project);
                }
                testComponent.getBinaries().whenElementKnown(DefaultSwiftXCTestBinary.class, (Action)new Action<DefaultSwiftXCTestBinary>(){

                    public void execute(DefaultSwiftXCTestBinary binary) {
                        XCTest testingTask = XCTestConventionPlugin.this.createTestingTask(project);
                        binary.getRunTask().set((Object)testingTask);
                        XCTestConventionPlugin.this.configureTestingTask(binary, testingTask);
                        XCTestConventionPlugin.this.configureTestSuiteBuildingTasks((ProjectInternal)project, binary);
                        XCTestConventionPlugin.this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, binary);
                    }
                });
                testComponent.getBinaries().realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }

    private void configureTestSuiteBuildingTasks(ProjectInternal project, final DefaultSwiftXCTestBinary binary) {
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainerInternal tasks = project.getTasks();
            final Names names = binary.getNames();
            SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
            DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            ModelRegistry modelRegistry = project.getModelRegistry();
            NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
            compile.getCompilerArgs().addAll(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            LinkMachOBundle link = (LinkMachOBundle)tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
            link.getLinkerArgs().set(project.provider((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }
            }));
            InstallXCTestBundle install = (InstallXCTestBundle)tasks.create(names.getTaskName("install"), InstallXCTestBundle.class);
            install.getBundleBinaryFile().set((Provider)link.getLinkedFile());
            install.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            binary.getInstallDirectory().set((Provider)install.getInstallDirectory());
            link.source((Object)binary.getObjects());
            link.lib((Object)binary.getLinkLibraries());
            final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
            Provider exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getBaseName().get());
                }
            }));
            link.getLinkedFile().set(exeLocation);
            link.getTargetPlatform().set((Object)currentPlatform);
            link.getToolChain().set((Object)toolChain);
            link.getDebuggable().set((Object)binary.isDebuggable());
            binary.getExecutableFile().set((Provider)link.getLinkedFile());
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set((Object)link);
            bundle.getRunScriptFile().set(install.getRunScriptFile());
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(((InstallExecutable)executable.getInstallTask().get()).getRunScriptFile());
        }
    }

    private XCTest createTestingTask(Project project) {
        TaskContainer tasks = project.getTasks();
        XCTest testTask = (XCTest)tasks.create("xcTest", XCTest.class);
        testTask.setGroup("verification");
        testTask.setDescription("Executes XCTest suites");
        return testTask;
    }

    private void configureTestingTask(SwiftXCTestBinary binary, XCTest testTask) {
        testTask.getTestInstallDirectory().set(binary.getInstallDirectory());
        testTask.getRunScriptFile().set(binary.getRunScriptFile());
        testTask.getWorkingDirectory().set(binary.getInstallDirectory());
    }

    private DefaultSwiftXCTestSuite createTestSuite(Project project) {
        DefaultSwiftXCTestSuite testSuite = (DefaultSwiftXCTestSuite)this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)testSuite);
        project.getComponents().add((Object)testSuite);
        testSuite.getModule().set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, final DefaultSwiftXCTestSuite testSuite, final DefaultSwiftXCTestBinary testExecutable) {
        SwiftComponent target = (SwiftComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionSwiftComponent)) {
            return;
        }
        final ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)target;
        final TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

            public void execute(SwiftBinary testedBinary) {
                if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                    return;
                }
                if (testSuite.getSourceCompatibility().getOrNull() == null) {
                    testExecutable.getSourceCompatibility().set(testedBinary.getSourceCompatibility());
                }
                AbstractLinkTask linkTest = (AbstractLinkTask)testExecutable.getLinkTask().get();
                if (testedComponent instanceof SwiftApplication) {
                    final UnexportMainSymbol unexportMainSymbol = (UnexportMainSymbol)tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                    unexportMainSymbol.source(new Object[]{testedBinary.getObjects()});
                    linkTest.source((Object)testedBinary.getObjects().filter((Spec)new Spec<File>(){

                        public boolean isSatisfiedBy(File objectFile) {
                            return !objectFile.equals(unexportMainSymbol.getMainObject());
                        }
                    }));
                    linkTest.source((Object)unexportMainSymbol.getObjects());
                } else {
                    linkTest.source((Object)testedBinary.getObjects());
                }
            }
        });
    }
}

